/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.monitoring.elastic.common;

import io.micrometer.elastic.ElasticConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.monitoring.elastic.common.ElasticRegistry;
import org.kie.kogito.monitoring.elastic.common.KogitoElasticConfig;

public class ElasticRegistryTest {
    @Test
    public void testElasticMicrometerIsUsingOurProperties() throws InterruptedException {
        ElasticRegistry elasticRegistry = new ElasticRegistry();
        KogitoElasticConfig kogitoElasticConfig = new KogitoElasticConfig();
        kogitoElasticConfig.withProperty("host", "http://mylocalhost:8080");
        kogitoElasticConfig.withProperty("index", "myIndex");
        kogitoElasticConfig.withProperty("step", "1s");
        kogitoElasticConfig.withProperty("timestampFieldName", "myTimestampName");
        kogitoElasticConfig.withProperty("userName", "pippo");
        kogitoElasticConfig.withProperty("password", "pluto");
        kogitoElasticConfig.withProperty("pipeline", "mypipe");
        kogitoElasticConfig.withProperty("indexDateSeparator", "/");
        kogitoElasticConfig.withProperty("documentType", "doc");
        Map configMap = kogitoElasticConfig.getConfigMap();
        HashMap countDownLatchMap = new HashMap();
        configMap.keySet().forEach(x -> countDownLatchMap.put(x, new CountDownLatch(1)));
        ElasticConfig elasticConfig = s -> {
            countDownLatchMap.computeIfPresent(s, (k, v) -> {
                v.countDown();
                return v;
            });
            return configMap.getOrDefault(s, null);
        };
        elasticRegistry.start(elasticConfig);
        for (CountDownLatch value : countDownLatchMap.values()) {
            Assertions.assertTrue((boolean)value.await(20L, TimeUnit.SECONDS));
        }
    }
}

