/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.filesystem;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.UserDefinedFileAttributeView;
import java.util.Collection;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.kie.kogito.process.MutableProcessInstances;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstanceDuplicatedException;
import org.kie.kogito.process.ProcessInstanceReadMode;
import org.kie.kogito.process.impl.AbstractProcessInstance;
import org.kie.kogito.serialization.process.ProcessInstanceMarshallerService;

public class FileSystemProcessInstances
implements MutableProcessInstances {
    public static final String PI_DESCRIPTION = "ProcessInstanceDescription";
    public static final String PI_STATUS = "ProcessInstanceStatus";
    private Process<?> process;
    private Path storage;
    private ProcessInstanceMarshallerService marshaller;

    public FileSystemProcessInstances(Process<?> process, Path storage) {
        this(process, storage, ProcessInstanceMarshallerService.newBuilder().withDefaultObjectMarshallerStrategies().build());
    }

    public FileSystemProcessInstances(Process<?> process, Path storage, ProcessInstanceMarshallerService marshaller) {
        this.process = process;
        this.storage = Paths.get(storage.toString(), process.id());
        this.marshaller = marshaller;
        try {
            Files.createDirectories(this.storage, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to create directories for file based storage of process instances", e);
        }
    }

    public Integer size() {
        Integer n;
        block8: {
            Stream<Path> stream = Files.walk(this.storage, new FileVisitOption[0]);
            try {
                Long count = stream.filter(file -> !Files.isDirectory(file, new LinkOption[0])).count();
                n = count.intValue();
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to count process instances ", e);
                }
            }
            stream.close();
        }
        return n;
    }

    public Optional findById(String id, ProcessInstanceReadMode mode) {
        Path processInstanceStorage = Paths.get(this.storage.toString(), id);
        if (Files.notExists(processInstanceStorage, new LinkOption[0])) {
            return Optional.empty();
        }
        byte[] data = this.readBytesFromFile(processInstanceStorage);
        return Optional.of(mode == ProcessInstanceReadMode.MUTABLE ? this.marshaller.unmarshallProcessInstance(data, this.process) : this.marshaller.unmarshallReadOnlyProcessInstance(data, this.process));
    }

    public Collection values(ProcessInstanceReadMode mode) {
        Collection collection;
        block8: {
            Stream<Path> stream = Files.walk(this.storage, new FileVisitOption[0]);
            try {
                collection = stream.filter(file -> !Files.isDirectory(file, new LinkOption[0])).map(this::readBytesFromFile).map(b -> mode == ProcessInstanceReadMode.MUTABLE ? this.marshaller.unmarshallProcessInstance(b, this.process) : this.marshaller.unmarshallReadOnlyProcessInstance(b, this.process)).collect(Collectors.toList());
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException("Unable to read process instances ", e);
                }
            }
            stream.close();
        }
        return collection;
    }

    public boolean exists(String id) {
        return Files.exists(Paths.get(this.storage.toString(), id), new LinkOption[0]);
    }

    public void create(String id, ProcessInstance instance) {
        if (this.isActive(instance)) {
            Path processInstanceStorage = Paths.get(this.storage.toString(), id);
            if (Files.exists(processInstanceStorage, new LinkOption[0])) {
                throw new ProcessInstanceDuplicatedException(id);
            }
            this.storeProcessInstance(processInstanceStorage, instance);
        }
    }

    public void update(String id, ProcessInstance instance) {
        Path processInstanceStorage;
        if (this.isActive(instance) && Files.exists(processInstanceStorage = Paths.get(this.storage.toString(), id), new LinkOption[0])) {
            this.storeProcessInstance(processInstanceStorage, instance);
            this.disconnect(processInstanceStorage, instance);
        }
    }

    public void remove(String id) {
        Path processInstanceStorage = Paths.get(this.storage.toString(), id);
        try {
            Files.deleteIfExists(processInstanceStorage);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to remove process instance with id " + id, e);
        }
    }

    protected void storeProcessInstance(Path processInstanceStorage, ProcessInstance<?> instance) {
        try {
            byte[] data = this.marshaller.marshallProcessInstance(instance);
            Files.write(processInstanceStorage, data, new OpenOption[0]);
            this.setMetadata(processInstanceStorage, PI_DESCRIPTION, instance.description());
            this.setMetadata(processInstanceStorage, PI_STATUS, String.valueOf(instance.status()));
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to store process instance with id " + instance.id(), e);
        }
    }

    protected byte[] readBytesFromFile(Path processInstanceStorage) {
        try {
            return Files.readAllBytes(processInstanceStorage);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to read process instance from " + processInstanceStorage, e);
        }
    }

    protected void disconnect(Path processInstanceStorage, ProcessInstance instance) {
        Supplier<byte[]> supplier = () -> this.readBytesFromFile(processInstanceStorage);
        ((AbstractProcessInstance)instance).internalRemoveProcessInstance(this.marshaller.createdReloadFunction(supplier));
    }

    public String getMetadata(Path file, String key) {
        if (this.supportsUserDefinedAttributes(file)) {
            UserDefinedFileAttributeView view = Files.getFileAttributeView(file, UserDefinedFileAttributeView.class, new LinkOption[0]);
            try {
                ByteBuffer bb = ByteBuffer.allocate(view.size(key));
                view.read(key, bb);
                bb.flip();
                return Charset.defaultCharset().decode(bb).toString();
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    public boolean setMetadata(Path file, String key, String value) {
        if (this.supportsUserDefinedAttributes(file)) {
            UserDefinedFileAttributeView view = Files.getFileAttributeView(file, UserDefinedFileAttributeView.class, new LinkOption[0]);
            try {
                if (value != null) {
                    view.write(key, Charset.defaultCharset().encode(value));
                } else {
                    view.delete(key);
                }
                return true;
            }
            catch (IOException e) {
                return false;
            }
        }
        return false;
    }

    protected boolean supportsUserDefinedAttributes(Path file) {
        try {
            return Files.getFileStore(file).supportsFileAttributeView(UserDefinedFileAttributeView.class);
        }
        catch (IOException e) {
            return false;
        }
    }
}

