/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.infinispan;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.drools.core.io.impl.ClassPathResource;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.jbpm.workflow.core.DroolsAction;
import org.jbpm.workflow.core.WorkflowProcess;
import org.jbpm.workflow.core.node.ActionNode;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.api.definition.process.Node;
import org.kie.api.io.Resource;
import org.kie.kogito.auth.IdentityProvider;
import org.kie.kogito.auth.SecurityPolicy;
import org.kie.kogito.persistence.KogitoProcessInstancesFactory;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstanceReadMode;
import org.kie.kogito.process.ProcessInstances;
import org.kie.kogito.process.ProcessInstancesFactory;
import org.kie.kogito.process.WorkItem;
import org.kie.kogito.process.bpmn2.BpmnProcess;
import org.kie.kogito.process.bpmn2.BpmnVariables;
import org.kie.kogito.process.workitem.Policy;
import org.kie.kogito.services.identity.StaticIdentityProvider;
import org.kie.kogito.testcontainers.KogitoInfinispanContainer;
import org.testcontainers.junit.jupiter.Container;
import org.testcontainers.junit.jupiter.Testcontainers;

@Testcontainers
class CacheProcessInstancesIT {
    @Container
    public KogitoInfinispanContainer container = new KogitoInfinispanContainer();
    private RemoteCacheManager cacheManager;

    CacheProcessInstancesIT() {
    }

    @BeforeEach
    void setup() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.addServer().host("127.0.0.1").port(this.container.getMappedPort());
        this.cacheManager = new RemoteCacheManager(builder.build());
    }

    @AfterEach
    void close() {
        if (this.cacheManager != null) {
            this.cacheManager.close();
        }
    }

    @Test
    void testFindByIdReadMode() {
        BpmnProcess process = (BpmnProcess)BpmnProcess.from((Resource[])new Resource[]{new ClassPathResource("BPMN2-UserTask-Script.bpmn2")}).get(0);
        for (Node node : ((WorkflowProcess)process.process()).getNodes()) {
            if (!(node instanceof ActionNode)) continue;
            DroolsAction a = ((ActionNode)node).getAction();
            a.setMetaData("Action", kcontext -> {
                System.out.println("The variable value is " + kcontext.getVariable("s") + " about to call toString on it");
                kcontext.getVariable("s").toString();
            });
        }
        process.setProcessInstancesFactory((ProcessInstancesFactory)new CacheProcessInstancesFactory(this.cacheManager));
        process.configure();
        ProcessInstance mutablePi = process.createInstance(BpmnVariables.create(Collections.singletonMap("var", "value")));
        mutablePi.start();
        Assertions.assertThat((int)mutablePi.status()).isEqualTo(5);
        Assertions.assertThat((Optional)mutablePi.error()).hasValueSatisfying(error -> {
            Assertions.assertThat((String)error.errorMessage()).contains(new CharSequence[]{"java.lang.NullPointerException"});
            Assertions.assertThat((String)error.failedNodeId()).isEqualTo("ScriptTask_1");
        });
        Assertions.assertThat((Map)((BpmnVariables)mutablePi.variables()).toMap()).containsExactly(new Map.Entry[]{Assertions.entry((Object)"var", (Object)"value")});
        ProcessInstances instances = process.instances();
        Assertions.assertThat((Integer)instances.size()).isOne();
        ProcessInstance pi = (ProcessInstance)instances.findById(mutablePi.id(), ProcessInstanceReadMode.READ_ONLY).get();
        Assertions.assertThatExceptionOfType(UnsupportedOperationException.class).isThrownBy(() -> pi.abort());
        ProcessInstance readOnlyPi = (ProcessInstance)instances.findById(mutablePi.id(), ProcessInstanceReadMode.READ_ONLY).get();
        Assertions.assertThat((int)readOnlyPi.status()).isEqualTo(5);
        Assertions.assertThat((Optional)readOnlyPi.error()).hasValueSatisfying(error -> {
            Assertions.assertThat((String)error.errorMessage()).contains(new CharSequence[]{"java.lang.NullPointerException"});
            Assertions.assertThat((String)error.failedNodeId()).isEqualTo("ScriptTask_1");
        });
        Assertions.assertThat((Map)((BpmnVariables)readOnlyPi.variables()).toMap()).containsExactly(new Map.Entry[]{Assertions.entry((Object)"var", (Object)"value")});
        Assertions.assertThatExceptionOfType(UnsupportedOperationException.class).isThrownBy(() -> readOnlyPi.abort());
        ((ProcessInstance)instances.findById(mutablePi.id()).get()).abort();
        Assertions.assertThat((Integer)instances.size()).isZero();
    }

    @Test
    void testValuesReadMode() {
        BpmnProcess process = (BpmnProcess)BpmnProcess.from((Resource[])new Resource[]{new ClassPathResource("BPMN2-UserTask.bpmn2")}).get(0);
        process.setProcessInstancesFactory((ProcessInstancesFactory)new CacheProcessInstancesFactory(this.cacheManager));
        process.configure();
        ProcessInstance processInstance = process.createInstance(BpmnVariables.create(Collections.singletonMap("test", "test")));
        processInstance.start();
        ProcessInstances instances = process.instances();
        Assertions.assertThat((Integer)instances.size()).isOne();
        ProcessInstance pi = (ProcessInstance)instances.values().stream().findFirst().get();
        Assertions.assertThatExceptionOfType(UnsupportedOperationException.class).isThrownBy(() -> pi.abort());
        ((ProcessInstance)instances.values(ProcessInstanceReadMode.MUTABLE).stream().findFirst().get()).abort();
        Assertions.assertThat((Integer)instances.size()).isZero();
    }

    @Test
    void testBasicFlow() {
        BpmnProcess process = (BpmnProcess)BpmnProcess.from((Resource[])new Resource[]{new ClassPathResource("BPMN2-UserTask.bpmn2")}).get(0);
        process.setProcessInstancesFactory((ProcessInstancesFactory)new CacheProcessInstancesFactory(this.cacheManager));
        process.configure();
        ProcessInstance processInstance = process.createInstance(BpmnVariables.create(Collections.singletonMap("test", "test")));
        processInstance.start();
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)processInstance.status());
        Assertions.assertThat((Integer)process.instances().size()).isOne();
        SecurityPolicy asJohn = SecurityPolicy.of((IdentityProvider)new StaticIdentityProvider("john"));
        Assertions.assertThat((List)((ProcessInstance)process.instances().values().iterator().next()).workItems(new Policy[]{asJohn})).hasSize(1);
        List workItems = processInstance.workItems(new Policy[]{asJohn});
        Assertions.assertThat((List)workItems).hasSize(1);
        WorkItem workItem = (WorkItem)workItems.get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"john", workItem.getParameters().get("ActorId"));
        processInstance.completeWorkItem(workItem.getId(), null, new Policy[]{asJohn});
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)processInstance.status());
        Assertions.assertThat((Integer)process.instances().size()).isZero();
    }

    private class CacheProcessInstancesFactory
    extends KogitoProcessInstancesFactory {
        CacheProcessInstancesFactory(RemoteCacheManager cacheManager) {
            super(cacheManager);
        }

        public boolean lock() {
            return false;
        }
    }
}

