/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.infinispan;

import java.util.Collection;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.kie.kogito.process.MutableProcessInstances;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstanceDuplicatedException;
import org.kie.kogito.process.ProcessInstanceReadMode;
import org.kie.kogito.process.impl.AbstractProcessInstance;
import org.kie.kogito.serialization.process.ProcessInstanceMarshallerService;

public class CacheProcessInstances
implements MutableProcessInstances {
    private final RemoteCache<String, byte[]> cache;
    private ProcessInstanceMarshallerService marshaller;
    private Process<?> process;
    private final boolean lock;

    public CacheProcessInstances(Process<?> process, RemoteCacheManager cacheManager, String templateName, boolean lock) {
        this.process = process;
        this.cache = cacheManager.administration().getOrCreateCache(process.id() + "_store", this.ignoreNullOrEmpty(templateName));
        this.marshaller = ProcessInstanceMarshallerService.newBuilder().withDefaultObjectMarshallerStrategies().build();
        this.lock = lock;
    }

    public Integer size() {
        return this.cache.size();
    }

    public Optional<? extends ProcessInstance> findById(String id, ProcessInstanceReadMode mode) {
        return this.lock ? this.findWithLock(id, mode) : this.findInternal(id, mode);
    }

    private Optional<? extends ProcessInstance> findInternal(String id, ProcessInstanceReadMode mode) {
        byte[] data = (byte[])this.cache.get((Object)id);
        if (data == null) {
            return Optional.empty();
        }
        return Optional.of(mode == ProcessInstanceReadMode.MUTABLE ? this.marshaller.unmarshallProcessInstance(data, this.process) : this.marshaller.unmarshallReadOnlyProcessInstance(data, this.process));
    }

    private Optional<? extends ProcessInstance> findWithLock(String id, ProcessInstanceReadMode mode) {
        MetadataValue versionedCache = this.cache.getWithMetadata((Object)id);
        if (versionedCache != null) {
            ProcessInstance instance = mode == ProcessInstanceReadMode.MUTABLE ? this.marshaller.unmarshallProcessInstance((byte[])versionedCache.getValue(), this.process) : this.marshaller.unmarshallReadOnlyProcessInstance((byte[])versionedCache.getValue(), this.process);
            ((AbstractProcessInstance)instance).setVersion(Long.valueOf(versionedCache.getVersion()));
            return Optional.of(instance);
        }
        return Optional.empty();
    }

    public Collection<? extends ProcessInstance> values(ProcessInstanceReadMode mode) {
        return this.cache.values().parallelStream().map(data -> mode == ProcessInstanceReadMode.MUTABLE ? this.marshaller.unmarshallProcessInstance(data, this.process) : this.marshaller.unmarshallReadOnlyProcessInstance(data, this.process)).collect(Collectors.toList());
    }

    public void update(String id, ProcessInstance instance) {
        this.updateStorage(id, instance, false);
    }

    public void remove(String id) {
        if (this.lock) {
            MetadataValue versionedCache = this.cache.getWithMetadata((Object)id);
            boolean success = this.cache.removeWithVersion((Object)id, versionedCache.getVersion());
            if (!success) {
                throw this.uncheckedException(null, "The document with ID: %s was deleted by other request.", id);
            }
        } else {
            this.cache.remove((Object)id);
        }
    }

    protected String ignoreNullOrEmpty(String value) {
        if (value == null || value.trim().isEmpty()) {
            return null;
        }
        return value;
    }

    public void create(String id, ProcessInstance instance) {
        this.updateStorage(id, instance, true);
    }

    protected void updateStorage(String id, ProcessInstance instance, boolean checkDuplicates) {
        if (this.isActive(instance)) {
            byte[] data = this.marshaller.marshallProcessInstance(instance);
            if (checkDuplicates) {
                byte[] existing = (byte[])this.cache.putIfAbsent((Object)id, (Object)data);
                if (existing != null) {
                    throw new ProcessInstanceDuplicatedException(id);
                }
            } else if (this.lock) {
                boolean success = this.cache.replaceWithVersion((Object)id, (Object)data, instance.version().longValue());
                if (!success) {
                    throw this.uncheckedException(null, "The document with ID: %s was updated or deleted by other request.", id);
                }
            } else {
                this.cache.put((Object)id, (Object)data);
            }
            this.disconnect(id, instance);
        }
    }

    private void disconnect(String id, ProcessInstance instance) {
        if (this.lock) {
            this.reloadWithLock(id, instance);
        } else {
            this.reload(id, instance);
        }
    }

    private void reloadWithLock(String id, ProcessInstance instance) {
        Supplier<byte[]> supplier = () -> {
            MetadataValue versionedCache = this.cache.getWithMetadata((Object)id);
            ((AbstractProcessInstance)instance).setVersion(Long.valueOf(versionedCache.getVersion()));
            return (byte[])versionedCache.getValue();
        };
        ((AbstractProcessInstance)instance).internalRemoveProcessInstance(this.marshaller.createdReloadFunction(supplier));
    }

    private void reload(String id, ProcessInstance instance) {
        Supplier<byte[]> supplier = () -> (byte[])this.cache.get((Object)id);
        ((AbstractProcessInstance)instance).internalRemoveProcessInstance(this.marshaller.createdReloadFunction(supplier));
    }

    public boolean exists(String id) {
        return this.cache.containsKey((Object)id);
    }

    public boolean lock() {
        return this.lock;
    }

    private RuntimeException uncheckedException(Exception ex, String message, Object ... param) {
        return new RuntimeException(String.format(message, param), ex);
    }
}

