/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.sql.DataSource;
import org.kie.kogito.persistence.jdbc.FileLoader;
import org.kie.kogito.persistence.jdbc.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericRepository
extends Repository {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericRepository.class);

    private DatabaseType getDataBaseType(Connection connection) throws SQLException {
        DatabaseMetaData metaData = connection.getMetaData();
        String dbProductName = metaData.getDatabaseProductName();
        return DatabaseType.create(dbProductName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    boolean tableExists(DataSource dataSource) {
        try (Connection connection = dataSource.getConnection();){
            DatabaseType databaseType = this.getDataBaseType(connection);
            DatabaseMetaData metaData = connection.getMetaData();
            String[] types = new String[]{"TABLE"};
            ResultSet tables = metaData.getTables(null, null, databaseType.tableNamePattern, types);
            if (tables.next()) {
                LOGGER.debug("Found process_instance table");
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (SQLException e) {
            String msg = "Failed to read table metadata";
            throw new RuntimeException(msg);
        }
    }

    @Override
    void createTable(DataSource dataSource) {
        try (Connection connection = dataSource.getConnection();){
            DatabaseType databaseType = this.getDataBaseType(connection);
            List<String> statements = FileLoader.getQueryFromFile(databaseType.dbIdentifier, "create_tables");
            for (String s : statements) {
                PreparedStatement prepareStatement = connection.prepareStatement(s.trim());
                try {
                    prepareStatement.execute();
                }
                finally {
                    if (prepareStatement == null) continue;
                    prepareStatement.close();
                }
            }
            LOGGER.info("DDL successfully done for ProcessInstance");
        }
        catch (SQLException e) {
            String msg = "Error creating process_instances table, the database should be configured properly before starting the application";
            LOGGER.error(msg, (Throwable)e);
            throw new RuntimeException(msg);
        }
    }

    @Override
    void insertInternal(DataSource dataSource, String processId, UUID id, byte[] payload) {
        try (Connection connection = dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement("INSERT INTO process_instances (id, payload, process_id, version) VALUES (?, ?, ?, ?)");){
            statement.setString(1, id.toString());
            statement.setBytes(2, payload);
            statement.setString(3, processId);
            statement.setLong(4, 0L);
            statement.executeUpdate();
        }
        catch (Exception e) {
            throw this.uncheckedException(e, "Error inserting process instance %s", id);
        }
    }

    @Override
    void updateInternal(DataSource dataSource, UUID id, byte[] payload) {
        try (Connection connection = dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement("UPDATE process_instances SET payload = ? WHERE id = ?");){
            statement.setBytes(1, payload);
            statement.setString(2, id.toString());
            statement.executeUpdate();
        }
        catch (Exception e) {
            throw this.uncheckedException(e, "Error updating process instance %s", id);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    boolean updateWithLock(DataSource dataSource, UUID id, byte[] payload, long version) {
        try (Connection connection = dataSource.getConnection();){
            boolean bl;
            block14: {
                PreparedStatement statement = connection.prepareStatement("UPDATE process_instances SET payload = ?, version = ? WHERE id = ? and version = ?");
                try {
                    statement.setBytes(1, payload);
                    statement.setLong(2, version + 1L);
                    statement.setString(3, id.toString());
                    statement.setLong(4, version);
                    int count = statement.executeUpdate();
                    boolean bl2 = bl = count == 1;
                    if (statement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return bl;
        }
        catch (Exception e) {
            throw this.uncheckedException(e, "Error updating with lock process instance %s", id);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    boolean deleteInternal(DataSource dataSource, UUID id) {
        try (Connection connection = dataSource.getConnection();){
            boolean bl;
            block14: {
                PreparedStatement statement = connection.prepareStatement("DELETE FROM process_instances WHERE id = ?");
                try {
                    statement.setString(1, id.toString());
                    int count = statement.executeUpdate();
                    boolean bl2 = bl = count == 1;
                    if (statement == null) break block14;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return bl;
        }
        catch (Exception e) {
            throw this.uncheckedException(e, "Error deleting process instance %s", id);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    Map<String, Object> findByIdInternal(DataSource dataSource, UUID id) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try (Connection connection = dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement("SELECT payload, version FROM process_instances WHERE id = ?");){
            statement.setString(1, id.toString());
            try (ResultSet resultSet = statement.executeQuery();){
                if (!resultSet.next()) return result;
                Optional<byte[]> b = Optional.ofNullable(resultSet.getBytes("payload"));
                if (b.isPresent()) {
                    result.put("payload", b.get());
                }
                result.put("version", resultSet.getLong("version"));
                HashMap<String, Object> hashMap = result;
                return hashMap;
            }
        }
        catch (Exception e) {
            throw this.uncheckedException(e, "Error finding process instance %s", id);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    List<byte[]> findAllInternal(DataSource dataSource, String processId) {
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        try (Connection connection = dataSource.getConnection();){
            ArrayList<byte[]> arrayList;
            block22: {
                PreparedStatement statement = connection.prepareStatement("SELECT payload FROM process_instances WHERE process_id = ?");
                try {
                    statement.setString(1, processId);
                    try (ResultSet resultSet = statement.executeQuery();){
                        while (resultSet.next()) {
                            result.add(resultSet.getBytes("payload"));
                        }
                    }
                    arrayList = result;
                    if (statement == null) break block22;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return arrayList;
        }
        catch (Exception e) {
            throw this.uncheckedException(e, "Error finding all process instances, for processId %s", processId);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    Long countInternal(DataSource dataSource, String processId) {
        try (Connection connection = dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement("SELECT COUNT(id) as count FROM process_instances WHERE process_id = ?");){
            statement.setString(1, processId);
            try (ResultSet resultSet = statement.executeQuery();){
                if (!resultSet.next()) return 0L;
                Long l = resultSet.getLong("count");
                return l;
            }
        }
        catch (Exception e) {
            throw this.uncheckedException(e, "Error counting process instances, for processId %s", processId);
        }
    }

    private static enum DatabaseType {
        ANSI("ansi", "process_instances"),
        ORACLE("Oracle", "PROCESS_INSTANCES"),
        POSTGRES("PostgreSQL", "process_instances");

        private final String dbIdentifier;
        private final String tableNamePattern;

        private DatabaseType(String dbIdentifier, String tableNamePattern) {
            this.dbIdentifier = dbIdentifier;
            this.tableNamePattern = tableNamePattern;
        }

        String getDbIdentifier() {
            return this.dbIdentifier;
        }

        public static DatabaseType create(String dbIdentifier) {
            if (ORACLE.getDbIdentifier().equals(dbIdentifier)) {
                return ORACLE;
            }
            if (POSTGRES.getDbIdentifier().equals(dbIdentifier)) {
                return POSTGRES;
            }
            String msg = String.format("Unrecognized DB (%s), defaulting to ansi", dbIdentifier);
            LOGGER.warn(msg);
            return ANSI;
        }
    }
}

