/*
 * Decompiled with CFR 0.152.
 */
package org.kie.persistence.jdbc;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.sql.DataSource;
import org.assertj.core.api.Assertions;
import org.drools.util.io.ClassPathResource;
import org.junit.jupiter.api.Test;
import org.kie.api.io.Resource;
import org.kie.kogito.Model;
import org.kie.kogito.auth.IdentityProvider;
import org.kie.kogito.auth.IdentityProviders;
import org.kie.kogito.auth.SecurityPolicy;
import org.kie.kogito.persistence.jdbc.JDBCProcessInstances;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstanceReadMode;
import org.kie.kogito.process.ProcessInstancesFactory;
import org.kie.kogito.process.WorkItem;
import org.kie.kogito.process.bpmn2.BpmnProcess;
import org.kie.kogito.process.bpmn2.BpmnProcessInstance;
import org.kie.kogito.process.bpmn2.BpmnVariables;
import org.kie.kogito.process.workitem.Policy;
import org.kie.persistence.jdbc.TestProcessInstancesFactory;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

abstract class AbstractProcessInstancesIT {
    public static final String TEST_ID = "02ac3854-46ee-42b7-8b63-5186c9889d96";
    public static SecurityPolicy securityPolicy = SecurityPolicy.of((IdentityProvider)IdentityProviders.of((String)"john"));

    AbstractProcessInstancesIT() {
    }

    public static BpmnProcess createProcess(TestProcessInstancesFactory factory, String fileName) {
        BpmnProcess process = (BpmnProcess)BpmnProcess.from((Resource[])new Resource[]{new ClassPathResource(fileName)}).get(0);
        process.setProcessInstancesFactory((ProcessInstancesFactory)factory);
        process.configure();
        process.instances().values(ProcessInstanceReadMode.MUTABLE).forEach(p -> p.abort());
        return process;
    }

    public static BpmnProcess configure(boolean lock) {
        BpmnProcess process = (BpmnProcess)BpmnProcess.from((Resource[])new Resource[]{new ClassPathResource("BPMN2-UserTask-Script.bpmn2")}).get(0);
        process.setProcessInstancesFactory((ProcessInstancesFactory)new TestProcessInstancesFactory(null, lock));
        process.configure();
        return process;
    }

    abstract DataSource getDataSource();

    @Test
    void testBasicTaskFlow() {
        TestProcessInstancesFactory factory = new TestProcessInstancesFactory(this.getDataSource(), false);
        BpmnProcess process = AbstractProcessInstancesIT.createProcess(factory, "BPMN2-UserTask.bpmn2");
        ProcessInstance processInstance = process.createInstance(BpmnVariables.create(Collections.singletonMap("test", "test")));
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        Assertions.assertThat((String)processInstance.description()).isEqualTo("User Task");
        JDBCProcessInstances processInstances = (JDBCProcessInstances)process.instances();
        Assertions.assertThat((Integer)processInstances.size()).isOne();
        Assertions.assertThat((boolean)processInstances.exists(processInstance.id())).isTrue();
        ((JDBCProcessInstances)Mockito.verify((Object)processInstances)).create((String)ArgumentMatchers.any(), (ProcessInstance)ArgumentMatchers.any());
        String testVar = (String)((BpmnVariables)processInstance.variables()).get("test");
        Assertions.assertThat((String)testVar).isEqualTo("test");
        Assertions.assertThat((String)processInstance.description()).isEqualTo("User Task");
        Assertions.assertThat((List)((ProcessInstance)process.instances().values().iterator().next()).workItems(new Policy[]{securityPolicy})).hasSize(1);
        WorkItem workItem = (WorkItem)processInstance.workItems(new Policy[]{securityPolicy}).get(0);
        Assertions.assertThat((Object)workItem).isNotNull();
        Assertions.assertThat((Map)workItem.getParameters()).containsEntry((Object)"ActorId", (Object)"john");
        processInstance.completeWorkItem(workItem.getId(), null, new Policy[]{securityPolicy});
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        processInstances = (JDBCProcessInstances)process.instances();
        ((JDBCProcessInstances)Mockito.verify((Object)processInstances, (VerificationMode)Mockito.times((int)2))).remove(processInstance.id());
        Assertions.assertThat((Integer)processInstances.size()).isZero();
        Assertions.assertThat((Collection)process.instances().values()).isEmpty();
    }

    @Test
    void testMultipleProcesses() {
        TestProcessInstancesFactory factory = new TestProcessInstancesFactory(this.getDataSource(), false);
        BpmnProcess utProcess = AbstractProcessInstancesIT.createProcess(factory, "BPMN2-UserTask.bpmn2");
        ProcessInstance utProcessInstance = utProcess.createInstance(BpmnVariables.create());
        utProcessInstance.start();
        BpmnProcess scriptProcess = AbstractProcessInstancesIT.createProcess(factory, "BPMN2-UserTask-Script.bpmn2");
        ProcessInstance scriptProcessInstance = scriptProcess.createInstance(BpmnVariables.create());
        scriptProcessInstance.start();
        ((JDBCProcessInstances)utProcess.instances()).remove(scriptProcessInstance.id());
        ((JDBCProcessInstances)scriptProcess.instances()).remove(utProcessInstance.id());
        Assertions.assertThat((Integer)utProcess.instances().size()).isOne();
        Assertions.assertThat((Collection)utProcess.instances().values()).hasSize(1);
        Assertions.assertThat((Optional)utProcess.instances().findById(utProcessInstance.id())).isPresent();
        Assertions.assertThat((Optional)utProcess.instances().findById(scriptProcessInstance.id())).isEmpty();
        Assertions.assertThat((Integer)scriptProcess.instances().size()).isOne();
        Assertions.assertThat((Collection)scriptProcess.instances().values()).hasSize(1);
        Assertions.assertThat((Optional)scriptProcess.instances().findById(scriptProcessInstance.id())).isPresent();
        Assertions.assertThat((Optional)scriptProcess.instances().findById(utProcessInstance.id())).isEmpty();
        ((JDBCProcessInstances)utProcess.instances()).remove(utProcessInstance.id());
        Assertions.assertThat((Integer)utProcess.instances().size()).isZero();
        Assertions.assertThat((Collection)utProcess.instances().values()).isEmpty();
        Assertions.assertThat((Optional)utProcess.instances().findById(utProcessInstance.id())).isEmpty();
        Assertions.assertThat((Optional)utProcess.instances().findById(scriptProcessInstance.id())).isEmpty();
        ((JDBCProcessInstances)scriptProcess.instances()).remove(scriptProcessInstance.id());
        Assertions.assertThat((Integer)scriptProcess.instances().size()).isZero();
        Assertions.assertThat((Collection)scriptProcess.instances().values()).isEmpty();
        Assertions.assertThat((Optional)scriptProcess.instances().findById(scriptProcessInstance.id())).isEmpty();
        Assertions.assertThat((Optional)scriptProcess.instances().findById(utProcessInstance.id())).isEmpty();
    }

    @Test
    void testBasicFlow() {
        TestProcessInstancesFactory factory = new TestProcessInstancesFactory(this.getDataSource(), false);
        BpmnProcess process = AbstractProcessInstancesIT.createProcess(factory, "BPMN2-UserTask.bpmn2");
        ProcessInstance processInstance = process.createInstance(BpmnVariables.create(Collections.singletonMap("test", "test")));
        processInstance.start();
        JDBCProcessInstances processInstances = (JDBCProcessInstances)process.instances();
        Assertions.assertThat((Integer)processInstances.size()).isOne();
        Optional foundOne = processInstances.findById(processInstance.id());
        BpmnProcessInstance instanceOne = (BpmnProcessInstance)foundOne.get();
        processInstances.update(processInstance.id(), (ProcessInstance)instanceOne);
        Assertions.assertThat((Integer)processInstances.size()).isOne();
        Assertions.assertThat((boolean)processInstances.exists(TEST_ID)).isFalse();
        Optional foundTwo = processInstances.findById(TEST_ID);
        Assertions.assertThat((Optional)foundTwo).isEmpty();
        processInstances.remove(processInstance.id());
        Assertions.assertThat((Integer)processInstances.size()).isZero();
        Assertions.assertThat((Collection)process.instances().values()).isEmpty();
    }

    @Test
    void testException() {
        BpmnProcess process = AbstractProcessInstancesIT.configure(false);
        JDBCProcessInstances processInstances = (JDBCProcessInstances)process.instances();
        Assertions.assertThatExceptionOfType(RuntimeException.class).isThrownBy(() -> processInstances.findById(TEST_ID));
        Assertions.assertThatExceptionOfType(RuntimeException.class).isThrownBy(() -> processInstances.remove(TEST_ID));
    }

    @Test
    public void testUpdate() {
        TestProcessInstancesFactory factory = new TestProcessInstancesFactory(this.getDataSource(), true);
        BpmnProcess process = AbstractProcessInstancesIT.createProcess(factory, "BPMN2-UserTask.bpmn2");
        ProcessInstance processInstance = process.createInstance(BpmnVariables.create(Collections.singletonMap("test", "test")));
        processInstance.start();
        JDBCProcessInstances processInstances = (JDBCProcessInstances)process.instances();
        Assertions.assertThat((Integer)processInstances.size()).isOne();
        Optional foundOne = processInstances.findById(processInstance.id());
        BpmnProcessInstance instanceOne = (BpmnProcessInstance)foundOne.get();
        foundOne = processInstances.findById(processInstance.id());
        BpmnProcessInstance instanceTwo = (BpmnProcessInstance)foundOne.get();
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)instanceOne.version());
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)instanceTwo.version());
        instanceOne.updateVariables((Model)BpmnVariables.create(Collections.singletonMap("s", "test")));
        try {
            BpmnVariables testvar = BpmnVariables.create(Collections.singletonMap("ss", "test"));
            instanceTwo.updateVariables((Model)testvar);
        }
        catch (RuntimeException e) {
            Assertions.assertThat((String)e.getMessage()).isEqualTo("The process instance with id: " + instanceOne.id() + " was updated or deleted by other request.");
        }
        foundOne = processInstances.findById(processInstance.id());
        instanceOne = (BpmnProcessInstance)foundOne.get();
        org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)instanceOne.version());
        processInstances.remove(processInstance.id());
        Assertions.assertThat((Integer)processInstances.size()).isZero();
        Assertions.assertThat((Collection)process.instances().values()).isEmpty();
    }

    @Test
    public void testRemove() {
        TestProcessInstancesFactory factory = new TestProcessInstancesFactory(this.getDataSource(), true);
        BpmnProcess process = AbstractProcessInstancesIT.createProcess(factory, "BPMN2-UserTask.bpmn2");
        ProcessInstance processInstance = process.createInstance(BpmnVariables.create(Collections.singletonMap("test", "test")));
        processInstance.start();
        JDBCProcessInstances processInstances = (JDBCProcessInstances)process.instances();
        Assertions.assertThat((Integer)processInstances.size()).isOne();
        Optional foundOne = processInstances.findById(processInstance.id());
        BpmnProcessInstance instanceOne = (BpmnProcessInstance)foundOne.get();
        foundOne = processInstances.findById(processInstance.id());
        BpmnProcessInstance instanceTwo = (BpmnProcessInstance)foundOne.get();
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)instanceOne.version());
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)instanceTwo.version());
        processInstances.remove(instanceOne.id());
        try {
            String id = instanceTwo.id();
            processInstances.remove(id);
        }
        catch (RuntimeException e) {
            Assertions.assertThat((String)e.getMessage()).isEqualTo("Process instance with id: " + instanceOne.id() + " was deleted by other request.");
        }
    }
}

