/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.jdbc;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.sql.DataSource;
import org.kie.kogito.persistence.jdbc.DatabaseType;
import org.kie.kogito.persistence.jdbc.FileLoader;
import org.kie.kogito.persistence.jdbc.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericRepository
extends Repository {
    private static final Logger LOGGER = LoggerFactory.getLogger(GenericRepository.class);
    private final DataSource dataSource;

    public GenericRepository(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    boolean tableExists() {
        try (Connection connection = this.dataSource.getConnection();){
            DatabaseType databaseType = DatabaseType.getDataBaseType(connection);
            DatabaseMetaData metaData = connection.getMetaData();
            String[] types = new String[]{"TABLE"};
            ResultSet tables = metaData.getTables(null, null, databaseType.getTableNamePattern(), types);
            if (tables.next()) {
                LOGGER.debug("Found process_instance table");
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (SQLException e) {
            String msg = "Failed to read table metadata";
            throw new RuntimeException(msg);
        }
    }

    @Override
    void createTable() {
        try (Connection connection = this.dataSource.getConnection();){
            DatabaseType databaseType = DatabaseType.getDataBaseType(connection);
            List<String> statements = FileLoader.getQueryFromFile(databaseType.getDbIdentifier(), "create_tables");
            for (String s : statements) {
                PreparedStatement prepareStatement = connection.prepareStatement(s.trim());
                try {
                    prepareStatement.execute();
                }
                finally {
                    if (prepareStatement == null) continue;
                    prepareStatement.close();
                }
            }
            LOGGER.info("DDL successfully done for ProcessInstance");
        }
        catch (SQLException e) {
            String msg = "Error creating process_instances table, the database should be configured properly before starting the application";
            LOGGER.error(msg, (Throwable)e);
            throw new RuntimeException(msg);
        }
    }

    @Override
    void insertInternal(String processId, String processVersion, UUID id, byte[] payload) {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement("INSERT INTO process_instances (id, payload, process_id, process_version, version) VALUES (?, ?, ?, ?, ?)");){
            statement.setString(1, id.toString());
            statement.setBytes(2, payload);
            statement.setString(3, processId);
            statement.setString(4, processVersion);
            statement.setLong(5, 0L);
            statement.executeUpdate();
        }
        catch (Exception e) {
            throw this.uncheckedException(e, "Error inserting process instance %s", id);
        }
    }

    @Override
    void updateInternal(String processId, String processVersion, UUID id, byte[] payload) {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(GenericRepository.sqlIncludingVersion("UPDATE process_instances SET payload = ? WHERE process_id = ? and id = ?", processVersion));){
            statement.setBytes(1, payload);
            statement.setString(2, processId);
            statement.setString(3, id.toString());
            if (processVersion != null) {
                statement.setString(4, processVersion);
            }
            statement.executeUpdate();
        }
        catch (Exception e) {
            throw this.uncheckedException(e, "Error updating process instance %s", id);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    boolean updateWithLock(String processId, String processVersion, UUID id, byte[] payload, long version) {
        try (Connection connection = this.dataSource.getConnection();){
            boolean bl;
            block15: {
                PreparedStatement statement = connection.prepareStatement(GenericRepository.sqlIncludingVersion("UPDATE process_instances SET payload = ?, version = ? WHERE process_id = ? and id = ? and version = ?", processVersion));
                try {
                    int count;
                    statement.setBytes(1, payload);
                    statement.setLong(2, version + 1L);
                    statement.setString(3, processId);
                    statement.setString(4, id.toString());
                    statement.setLong(5, version);
                    if (processVersion != null) {
                        statement.setString(6, processVersion);
                    }
                    boolean bl2 = bl = (count = statement.executeUpdate()) == 1;
                    if (statement == null) break block15;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return bl;
        }
        catch (Exception e) {
            throw this.uncheckedException(e, "Error updating with lock process instance %s", id);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    boolean deleteInternal(String processId, String processVersion, UUID id) {
        try (Connection connection = this.dataSource.getConnection();){
            boolean bl;
            block15: {
                PreparedStatement statement = connection.prepareStatement(GenericRepository.sqlIncludingVersion("DELETE FROM process_instances WHERE process_id = ? and id = ?", processVersion));
                try {
                    int count;
                    statement.setString(1, processId);
                    statement.setString(2, id.toString());
                    if (processVersion != null) {
                        statement.setString(3, processVersion);
                    }
                    boolean bl2 = bl = (count = statement.executeUpdate()) == 1;
                    if (statement == null) break block15;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return bl;
        }
        catch (Exception e) {
            throw this.uncheckedException(e, "Error deleting process instance %s", id);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    Map<String, Object> findByIdInternal(String processId, String processVersion, UUID id) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(GenericRepository.sqlIncludingVersion("SELECT payload, version FROM process_instances WHERE process_id = ? and id = ?", processVersion));){
            statement.setString(1, processId);
            statement.setString(2, id.toString());
            if (processVersion != null) {
                statement.setString(3, processVersion);
            }
            try (ResultSet resultSet = statement.executeQuery();){
                if (!resultSet.next()) return result;
                Optional<byte[]> b = Optional.ofNullable(resultSet.getBytes("payload"));
                if (b.isPresent()) {
                    result.put("payload", b.get());
                }
                result.put("version", resultSet.getLong("version"));
                HashMap<String, Object> hashMap = result;
                return hashMap;
            }
        }
        catch (Exception e) {
            throw this.uncheckedException(e, "Error finding process instance %s", id);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    List<byte[]> findAllInternal(String processId, String processVersion) {
        ArrayList<byte[]> result = new ArrayList<byte[]>();
        try (Connection connection = this.dataSource.getConnection();){
            ArrayList<byte[]> arrayList;
            block23: {
                PreparedStatement statement = connection.prepareStatement(GenericRepository.sqlIncludingVersion("SELECT payload FROM process_instances WHERE process_id = ?", processVersion));
                try {
                    statement.setString(1, processId);
                    if (processVersion != null) {
                        statement.setString(2, processVersion);
                    }
                    try (ResultSet resultSet = statement.executeQuery();){
                        while (resultSet.next()) {
                            result.add(resultSet.getBytes("payload"));
                        }
                    }
                    arrayList = result;
                    if (statement == null) break block23;
                }
                catch (Throwable throwable) {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                statement.close();
            }
            return arrayList;
        }
        catch (Exception e) {
            throw this.uncheckedException(e, "Error finding all process instances, for processId %s", processId);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    Long countInternal(String processId, String processVersion) {
        try (Connection connection = this.dataSource.getConnection();
             PreparedStatement statement = connection.prepareStatement(GenericRepository.sqlIncludingVersion("SELECT COUNT(id) as count FROM process_instances WHERE process_id = ?", processVersion));){
            statement.setString(1, processId);
            if (processVersion != null) {
                statement.setString(2, processVersion);
            }
            try (ResultSet resultSet = statement.executeQuery();){
                if (!resultSet.next()) return 0L;
                Long l = resultSet.getLong("count");
                return l;
            }
        }
        catch (Exception e) {
            throw this.uncheckedException(e, "Error counting process instances, for processId %s", processId);
        }
    }

    private static String sqlIncludingVersion(String statement, String processVersion) {
        return statement + (processVersion == null ? "and process_version is null" : "and process_version = ?");
    }
}

