/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.jdbc;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.kie.kogito.persistence.jdbc.DDLRunner;
import org.kie.kogito.persistence.jdbc.GenericRepository;
import org.kie.kogito.persistence.jdbc.Repository;
import org.kie.kogito.process.MutableProcessInstances;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstanceOptimisticLockingException;
import org.kie.kogito.process.ProcessInstanceReadMode;
import org.kie.kogito.process.impl.AbstractProcessInstance;
import org.kie.kogito.serialization.process.ProcessInstanceMarshallerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCProcessInstances
implements MutableProcessInstances {
    static final String PAYLOAD = "payload";
    static final String VERSION = "version";
    private static final Logger LOGGER = LoggerFactory.getLogger(JDBCProcessInstances.class);
    private final Process<?> process;
    private final ProcessInstanceMarshallerService marshaller;
    private final boolean lock;
    private final Repository repository;

    public JDBCProcessInstances(Process<?> process, DataSource dataSource, boolean autoDDL, boolean lock) {
        this.process = process;
        this.lock = lock;
        this.marshaller = ProcessInstanceMarshallerService.newBuilder().withDefaultObjectMarshallerStrategies().build();
        this.repository = new GenericRepository(dataSource);
        DDLRunner.init(this.repository, autoDDL);
    }

    public boolean exists(String id) {
        return this.findById(id).isPresent();
    }

    public void create(String id, ProcessInstance instance) {
        LOGGER.debug("Creating process instance id: {}, processId: {}, processVersion: {}", new Object[]{id, this.process.id(), this.process.version()});
        if (this.isActive(instance)) {
            this.repository.insertInternal(this.process.id(), this.process.version(), UUID.fromString(id), this.marshaller.marshallProcessInstance(instance));
        } else {
            LOGGER.warn("Skipping create of process instance id: {}, state: {}", (Object)id, (Object)instance.status());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(String id, ProcessInstance instance) {
        LOGGER.debug("Updating process instance id: {}, processId: {}, processVersion: {}", new Object[]{id, this.process.id(), this.process.version()});
        try {
            if (this.isActive(instance)) {
                if (this.lock) {
                    boolean isUpdated = this.repository.updateWithLock(this.process.id(), this.process.version(), UUID.fromString(id), this.marshaller.marshallProcessInstance(instance), instance.version());
                    if (!isUpdated) {
                        throw new ProcessInstanceOptimisticLockingException(id);
                    }
                } else {
                    this.repository.updateInternal(this.process.id(), this.process.version(), UUID.fromString(id), this.marshaller.marshallProcessInstance(instance));
                }
            } else {
                LOGGER.warn("Process instance id: {}, state: {} is not active, skipping update", (Object)id, (Object)instance.status());
            }
        }
        finally {
            this.disconnect(instance);
        }
    }

    public void remove(String id) {
        LOGGER.debug("Removing process instance id: {}, processId: {}", (Object)id, (Object)this.process.id());
        boolean isDeleted = this.repository.deleteInternal(this.process.id(), this.process.version(), UUID.fromString(id));
        LOGGER.debug("Deleted: {}", (Object)isDeleted);
    }

    public Optional<ProcessInstance> findById(String id, ProcessInstanceReadMode mode) {
        LOGGER.debug("Find process instance id: {}, mode: {}", (Object)id, (Object)mode);
        Map<String, Object> map = this.repository.findByIdInternal(this.process.id(), this.process.version(), UUID.fromString(id));
        if (map.containsKey(PAYLOAD)) {
            byte[] b = (byte[])map.get(PAYLOAD);
            ProcessInstance instance = mode == ProcessInstanceReadMode.MUTABLE ? this.marshaller.unmarshallProcessInstance(b, this.process) : this.marshaller.unmarshallReadOnlyProcessInstance(b, this.process);
            ((AbstractProcessInstance)instance).setVersion(((Long)map.get(VERSION)).longValue());
            return Optional.of(instance);
        }
        return Optional.empty();
    }

    public Collection<ProcessInstance> values(ProcessInstanceReadMode mode) {
        LOGGER.debug("Find process instance values using mode: {}", (Object)mode);
        return this.repository.findAllInternal(this.process.id(), this.process.version()).stream().map(b -> mode == ProcessInstanceReadMode.MUTABLE ? this.marshaller.unmarshallProcessInstance(b, this.process) : this.marshaller.unmarshallReadOnlyProcessInstance(b, this.process)).collect(Collectors.toList());
    }

    public Integer size() {
        return this.repository.countInternal(this.process.id(), this.process.version()).intValue();
    }

    public boolean lock() {
        return this.lock;
    }

    private void disconnect(ProcessInstance instance) {
        Supplier<byte[]> supplier = () -> {
            Map<String, Object> map = this.repository.findByIdInternal(this.process.id(), this.process.version(), UUID.fromString(instance.id()));
            ((AbstractProcessInstance)instance).setVersion(((Long)map.get(VERSION)).longValue());
            return (byte[])map.get(PAYLOAD);
        };
        ((AbstractProcessInstance)instance).internalRemoveProcessInstance(this.marshaller.createdReloadFunction(supplier));
    }
}

