/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.jdbc.correlation;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Optional;
import javax.sql.DataSource;
import org.kie.kogito.correlation.Correlation;
import org.kie.kogito.correlation.CorrelationEncoder;
import org.kie.kogito.correlation.CorrelationInstance;
import org.kie.kogito.correlation.CorrelationService;
import org.kie.kogito.persistence.jdbc.DatabaseType;
import org.kie.kogito.persistence.jdbc.correlation.PostgreSQLCorrelationRepository;
import org.kie.kogito.services.event.correlation.MD5CorrelationEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JDBCCorrelationService
implements CorrelationService {
    private static final Logger LOGGER = LoggerFactory.getLogger(JDBCCorrelationService.class);
    private PostgreSQLCorrelationRepository repository;
    private CorrelationEncoder correlationEncoder;

    public JDBCCorrelationService(DataSource dataSource) {
        try (Connection connection = dataSource.getConnection();){
            if (!DatabaseType.POSTGRES.equals((Object)DatabaseType.getDataBaseType(connection))) {
                throw new IllegalArgumentException("Only PostgreSQL is supported for correlation");
            }
        }
        catch (SQLException e) {
            LOGGER.error("Error getting connection for {}", (Object)dataSource);
        }
        this.repository = new PostgreSQLCorrelationRepository(dataSource);
        this.correlationEncoder = new MD5CorrelationEncoder();
    }

    public CorrelationInstance create(Correlation correlation, String correlatedId) {
        String encodedCorrelationId = this.correlationEncoder.encode(correlation);
        return this.repository.insert(encodedCorrelationId, correlatedId, correlation);
    }

    public Optional<CorrelationInstance> find(Correlation correlation) {
        String encoded = this.correlationEncoder.encode(correlation);
        return Optional.ofNullable(this.repository.findByEncodedCorrelationId(encoded));
    }

    public Optional<CorrelationInstance> findByCorrelatedId(String correlatedId) {
        return Optional.ofNullable(this.repository.findByCorrelatedId(correlatedId));
    }

    public void delete(Correlation correlation) {
        String encoded = this.correlationEncoder.encode(correlation);
        this.repository.delete(encoded);
    }
}

