/*
 * Decompiled with CFR 0.152.
 */
package org.kie.persistence.jdbc.correlation;

import java.util.Collections;
import java.util.Optional;
import javax.sql.DataSource;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.kie.kogito.correlation.CompositeCorrelation;
import org.kie.kogito.correlation.Correlation;
import org.kie.kogito.correlation.CorrelationInstance;
import org.kie.kogito.correlation.SimpleCorrelation;
import org.kie.kogito.persistence.jdbc.DDLRunner;
import org.kie.kogito.persistence.jdbc.GenericRepository;
import org.kie.kogito.persistence.jdbc.Repository;
import org.kie.kogito.persistence.jdbc.correlation.JDBCCorrelationService;
import org.kie.kogito.testcontainers.KogitoPostgreSqlContainer;
import org.postgresql.ds.PGSimpleDataSource;
import org.testcontainers.junit.jupiter.Container;
import org.testcontainers.junit.jupiter.Testcontainers;

@Testcontainers
public class JDBCCorrelationServiceIT {
    @Container
    private static final KogitoPostgreSqlContainer PG_CONTAINER = new KogitoPostgreSqlContainer();
    private static PGSimpleDataSource dataSource;
    private static JDBCCorrelationService correlationService;

    @BeforeAll
    public static void setUp() {
        dataSource = new PGSimpleDataSource();
        dataSource.setUrl(PG_CONTAINER.getJdbcUrl());
        dataSource.setUser(PG_CONTAINER.getUsername());
        dataSource.setPassword(PG_CONTAINER.getPassword());
        correlationService = new JDBCCorrelationService((DataSource)dataSource);
        DDLRunner.init((Repository)new GenericRepository((DataSource)dataSource), (boolean)true);
    }

    @Test
    public void testCorrelation() {
        CompositeCorrelation correlation = new CompositeCorrelation(Collections.singleton(new SimpleCorrelation("name", (Object)"Tiago")));
        String correlatedId = "id";
        CorrelationInstance correlationInstance = correlationService.create((Correlation)correlation, correlatedId);
        Assertions.assertThat((String)correlationInstance.getCorrelatedId()).isEqualTo(correlatedId);
        Assertions.assertThat((Comparable)correlationInstance.getCorrelation()).isEqualTo((Object)correlation);
        Optional foundInstance = correlationService.find((Correlation)correlation);
        Assertions.assertThat((Optional)foundInstance).isNotEmpty();
        Assertions.assertThat((String)((CorrelationInstance)foundInstance.get()).getCorrelatedId()).isEqualTo(correlatedId);
        Assertions.assertThat((Comparable)((CorrelationInstance)foundInstance.get()).getCorrelation()).isEqualTo((Object)correlation);
        foundInstance = correlationService.findByCorrelatedId(correlatedId);
        Assertions.assertThat((Optional)foundInstance).isNotEmpty();
        Assertions.assertThat((String)((CorrelationInstance)foundInstance.get()).getCorrelatedId()).isEqualTo(correlatedId);
        Assertions.assertThat((Comparable)((CorrelationInstance)foundInstance.get()).getCorrelation()).isEqualTo((Object)correlation);
        correlationService.delete((Correlation)correlation);
        foundInstance = correlationService.find((Correlation)correlation);
        Assertions.assertThat((Optional)foundInstance).isEmpty();
        foundInstance = correlationService.findByCorrelatedId(correlatedId);
        Assertions.assertThat((Optional)foundInstance).isEmpty();
    }
}

