/*
 * Decompiled with CFR 0.152.
 */
package org.kie.persistence.jdbc;

import java.sql.SQLException;
import javax.sql.DataSource;
import oracle.jdbc.pool.OracleDataSource;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.kie.kogito.testcontainers.KogitoOracleSqlContainer;
import org.kie.persistence.jdbc.AbstractProcessInstancesIT;
import org.testcontainers.containers.JdbcDatabaseContainer;
import org.testcontainers.junit.jupiter.Container;
import org.testcontainers.junit.jupiter.Testcontainers;

@Testcontainers
public class OracleProcessInstancesIT
extends AbstractProcessInstancesIT {
    @Container
    private static final KogitoOracleSqlContainer ORACLE_CONTAINER = new KogitoOracleSqlContainer();
    private static final String ORACLE_TIMEZONE_PROPERTY = "oracle.jdbc.timezoneAsRegion";
    private static OracleDataSource ORACLE_DATA_SOURCE;

    @BeforeAll
    public static void start() {
        try {
            ORACLE_DATA_SOURCE = new OracleDataSource();
            ORACLE_DATA_SOURCE.setURL(ORACLE_CONTAINER.getJdbcUrl());
            ORACLE_DATA_SOURCE.setUser(ORACLE_CONTAINER.getUsername());
            ORACLE_DATA_SOURCE.setPassword(ORACLE_CONTAINER.getPassword());
            System.setProperty(ORACLE_TIMEZONE_PROPERTY, "false");
            OracleProcessInstancesIT.initMigration((JdbcDatabaseContainer)ORACLE_CONTAINER, "oracle");
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to create oracle datasource");
        }
    }

    @AfterAll
    public static void stop() {
        System.clearProperty(ORACLE_TIMEZONE_PROPERTY);
    }

    @Override
    protected DataSource getDataSource() {
        return ORACLE_DATA_SOURCE;
    }
}

