/*
 * Decompiled with CFR 0.152.
 */
package org.kie.persistence.jdbc;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.sql.DataSource;
import org.assertj.core.api.Assertions;
import org.drools.io.ClassPathResource;
import org.flywaydb.core.Flyway;
import org.junit.jupiter.api.Test;
import org.kie.api.io.Resource;
import org.kie.kogito.Model;
import org.kie.kogito.auth.IdentityProvider;
import org.kie.kogito.auth.IdentityProviders;
import org.kie.kogito.auth.SecurityPolicy;
import org.kie.kogito.persistence.jdbc.JDBCProcessInstances;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstances;
import org.kie.kogito.process.ProcessInstancesFactory;
import org.kie.kogito.process.WorkItem;
import org.kie.kogito.process.bpmn2.BpmnProcess;
import org.kie.kogito.process.bpmn2.BpmnProcessInstance;
import org.kie.kogito.process.bpmn2.BpmnVariables;
import org.kie.kogito.process.workitem.Policy;
import org.kie.kogito.test.utils.ProcessInstancesTestUtils;
import org.kie.persistence.jdbc.TestProcessInstancesFactory;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.testcontainers.containers.JdbcDatabaseContainer;

abstract class AbstractProcessInstancesIT {
    public static final String TEST_ID = "02ac3854-46ee-42b7-8b63-5186c9889d96";
    public static SecurityPolicy securityPolicy = SecurityPolicy.of((IdentityProvider)IdentityProviders.of((String)"john"));

    AbstractProcessInstancesIT() {
    }

    public static void initMigration(JdbcDatabaseContainer container, String dbKind) {
        Flyway flyway = Flyway.configure().dataSource(container.getJdbcUrl(), container.getUsername(), container.getPassword()).locations(new String[]{"classpath:db/" + dbKind}).load();
        flyway.migrate();
    }

    public static BpmnProcess createProcess(TestProcessInstancesFactory factory, String fileName) {
        BpmnProcess process = (BpmnProcess)BpmnProcess.from((Resource[])new Resource[]{new ClassPathResource(fileName)}).get(0);
        process.setProcessInstancesFactory((ProcessInstancesFactory)factory);
        process.configure();
        ProcessInstancesTestUtils.abort((ProcessInstances)process.instances());
        return process;
    }

    public static BpmnProcess configure(boolean lock) {
        BpmnProcess process = (BpmnProcess)BpmnProcess.from((Resource[])new Resource[]{new ClassPathResource("BPMN2-UserTask-Script.bpmn2")}).get(0);
        process.setProcessInstancesFactory((ProcessInstancesFactory)new TestProcessInstancesFactory(null, lock));
        process.configure();
        return process;
    }

    boolean lock() {
        return false;
    }

    abstract DataSource getDataSource();

    @Test
    void testBasicTaskFlow() {
        TestProcessInstancesFactory factory = new TestProcessInstancesFactory(this.getDataSource(), this.lock());
        BpmnProcess process = AbstractProcessInstancesIT.createProcess(factory, "BPMN2-UserTask.bpmn2");
        ProcessInstance processInstance = process.createInstance(BpmnVariables.create(Collections.singletonMap("test", "test")));
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        Assertions.assertThat((String)processInstance.description()).isEqualTo("BPMN2-UserTask");
        JDBCProcessInstances processInstances = (JDBCProcessInstances)process.instances();
        Assertions.assertThat((boolean)processInstances.exists(processInstance.id())).isTrue();
        ((JDBCProcessInstances)Mockito.verify((Object)processInstances)).create((String)ArgumentMatchers.any(), (ProcessInstance)ArgumentMatchers.any());
        String testVar = (String)((BpmnVariables)processInstance.variables()).get("test");
        Assertions.assertThat((String)testVar).isEqualTo("test");
        Assertions.assertThat((String)processInstance.description()).isEqualTo("BPMN2-UserTask");
        Assertions.assertThat((List)ProcessInstancesTestUtils.getFirst((ProcessInstances)processInstances).workItems(new Policy[]{securityPolicy})).hasSize(1);
        WorkItem workItem = (WorkItem)processInstance.workItems(new Policy[]{securityPolicy}).get(0);
        Assertions.assertThat((Object)workItem).isNotNull();
        Assertions.assertThat((Map)workItem.getParameters()).containsEntry((Object)"ActorId", (Object)"john");
        processInstance.completeWorkItem(workItem.getId(), null, new Policy[]{securityPolicy});
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        processInstances = (JDBCProcessInstances)process.instances();
        ((JDBCProcessInstances)Mockito.verify((Object)processInstances, (VerificationMode)Mockito.times((int)1))).remove(processInstance.id());
        ProcessInstancesTestUtils.assertEmpty((ProcessInstances)process.instances());
    }

    @Test
    void testMultipleProcesses() {
        TestProcessInstancesFactory factory = new TestProcessInstancesFactory(this.getDataSource(), this.lock());
        BpmnProcess utProcess = AbstractProcessInstancesIT.createProcess(factory, "BPMN2-UserTask.bpmn2");
        ProcessInstance utProcessInstance = utProcess.createInstance(BpmnVariables.create());
        utProcessInstance.start();
        BpmnProcess scriptProcess = AbstractProcessInstancesIT.createProcess(factory, "BPMN2-UserTask-Script.bpmn2");
        ProcessInstance scriptProcessInstance = scriptProcess.createInstance(BpmnVariables.create());
        scriptProcessInstance.start();
        ((JDBCProcessInstances)utProcess.instances()).remove(scriptProcessInstance.id());
        ((JDBCProcessInstances)scriptProcess.instances()).remove(utProcessInstance.id());
        ProcessInstancesTestUtils.assertOne((ProcessInstances)utProcess.instances());
        Assertions.assertThat((Optional)utProcess.instances().findById(utProcessInstance.id())).isPresent();
        Assertions.assertThat((Optional)utProcess.instances().findById(scriptProcessInstance.id())).isEmpty();
        ProcessInstancesTestUtils.assertOne((ProcessInstances)scriptProcess.instances());
        Assertions.assertThat((Optional)scriptProcess.instances().findById(scriptProcessInstance.id())).isPresent();
        Assertions.assertThat((Optional)scriptProcess.instances().findById(utProcessInstance.id())).isEmpty();
        ((JDBCProcessInstances)utProcess.instances()).remove(utProcessInstance.id());
        ProcessInstancesTestUtils.assertEmpty((ProcessInstances)utProcess.instances());
        Assertions.assertThat((Optional)utProcess.instances().findById(utProcessInstance.id())).isEmpty();
        Assertions.assertThat((Optional)utProcess.instances().findById(scriptProcessInstance.id())).isEmpty();
        ((JDBCProcessInstances)scriptProcess.instances()).remove(scriptProcessInstance.id());
        ProcessInstancesTestUtils.assertEmpty((ProcessInstances)scriptProcess.instances());
        Assertions.assertThat((Optional)scriptProcess.instances().findById(scriptProcessInstance.id())).isEmpty();
        Assertions.assertThat((Optional)scriptProcess.instances().findById(utProcessInstance.id())).isEmpty();
    }

    @Test
    void testBasicFlow() {
        TestProcessInstancesFactory factory = new TestProcessInstancesFactory(this.getDataSource(), this.lock());
        BpmnProcess process = AbstractProcessInstancesIT.createProcess(factory, "BPMN2-UserTask.bpmn2");
        ProcessInstance processInstance = process.createInstance(BpmnVariables.create(Collections.singletonMap("test", "test")));
        processInstance.start();
        JDBCProcessInstances processInstances = (JDBCProcessInstances)process.instances();
        Optional foundOne = processInstances.findById(processInstance.id());
        BpmnProcessInstance instanceOne = (BpmnProcessInstance)foundOne.get();
        processInstances.update(processInstance.id(), (ProcessInstance)instanceOne);
        Assertions.assertThat((boolean)processInstances.exists(TEST_ID)).isFalse();
        Optional foundTwo = processInstances.findById(TEST_ID);
        Assertions.assertThat((Optional)foundTwo).isEmpty();
        processInstances.remove(processInstance.id());
        ProcessInstancesTestUtils.assertEmpty((ProcessInstances)process.instances());
    }

    @Test
    void testException() {
        BpmnProcess process = AbstractProcessInstancesIT.configure(this.lock());
        JDBCProcessInstances processInstances = (JDBCProcessInstances)process.instances();
        Assertions.assertThatExceptionOfType(RuntimeException.class).isThrownBy(() -> processInstances.findById(TEST_ID));
        Assertions.assertThatExceptionOfType(RuntimeException.class).isThrownBy(() -> processInstances.remove(TEST_ID));
    }

    @Test
    public void testUpdate() {
        TestProcessInstancesFactory factory = new TestProcessInstancesFactory(this.getDataSource(), this.lock());
        BpmnProcess process = AbstractProcessInstancesIT.createProcess(factory, "BPMN2-UserTask.bpmn2");
        ProcessInstance processInstance = process.createInstance(BpmnVariables.create(Collections.singletonMap("test", "test")));
        processInstance.start();
        JDBCProcessInstances processInstances = (JDBCProcessInstances)process.instances();
        Optional foundOne = processInstances.findById(processInstance.id());
        BpmnProcessInstance instanceOne = (BpmnProcessInstance)foundOne.get();
        foundOne = processInstances.findById(processInstance.id());
        BpmnProcessInstance instanceTwo = (BpmnProcessInstance)foundOne.get();
        Assertions.assertThat((long)instanceOne.version()).isEqualTo(this.lock() ? 1L : 0L);
        Assertions.assertThat((long)instanceTwo.version()).isEqualTo(this.lock() ? 1L : 0L);
        instanceOne.updateVariables((Model)BpmnVariables.create(Collections.singletonMap("s", "test")));
        try {
            BpmnVariables testvar = BpmnVariables.create(Collections.singletonMap("ss", "test"));
            instanceTwo.updateVariables((Model)testvar);
            if (this.lock()) {
                Assertions.fail((String)"Updating process should have failed");
            }
        }
        catch (RuntimeException e) {
            Assertions.assertThat((String)e.getMessage()).isEqualTo("Process instance with id '" + instanceOne.id() + "' updated or deleted by other request");
        }
        foundOne = processInstances.findById(processInstance.id());
        instanceOne = (BpmnProcessInstance)foundOne.get();
        Assertions.assertThat((long)instanceOne.version()).isEqualTo(this.lock() ? 2L : 0L);
        processInstances.remove(processInstance.id());
        ProcessInstancesTestUtils.assertEmpty((ProcessInstances)process.instances());
    }

    @Test
    public void testRemove() {
        TestProcessInstancesFactory factory = new TestProcessInstancesFactory(this.getDataSource(), this.lock());
        BpmnProcess process = AbstractProcessInstancesIT.createProcess(factory, "BPMN2-UserTask.bpmn2");
        ProcessInstance processInstance = process.createInstance(BpmnVariables.create(Collections.singletonMap("test", "test")));
        processInstance.start();
        JDBCProcessInstances processInstances = (JDBCProcessInstances)process.instances();
        ProcessInstancesTestUtils.assertOne((ProcessInstances)processInstances);
        Optional foundOne = processInstances.findById(processInstance.id());
        BpmnProcessInstance instanceOne = (BpmnProcessInstance)foundOne.get();
        foundOne = processInstances.findById(processInstance.id());
        BpmnProcessInstance instanceTwo = (BpmnProcessInstance)foundOne.get();
        Assertions.assertThat((long)instanceOne.version()).isEqualTo(this.lock() ? 1L : 0L);
        Assertions.assertThat((long)instanceTwo.version()).isEqualTo(this.lock() ? 1L : 0L);
        processInstances.remove(instanceOne.id());
        processInstances.remove(instanceTwo.id());
        ProcessInstancesTestUtils.assertEmpty((ProcessInstances)processInstances);
    }

    @Test
    void testProcessWithDifferentVersion() {
        TestProcessInstancesFactory factory = new TestProcessInstancesFactory(this.getDataSource(), this.lock());
        BpmnProcess processV1 = AbstractProcessInstancesIT.createProcess(factory, "BPMN2-UserTask.bpmn2");
        BpmnProcess processV2 = AbstractProcessInstancesIT.createProcess(factory, "BPMN2-UserTask-v2.bpmn2");
        Assertions.assertThat((String)processV1.process().getVersion()).isEqualTo("1.0");
        Assertions.assertThat((String)processV2.process().getVersion()).isEqualTo("2.0");
        ProcessInstance processInstanceV1 = processV1.createInstance(BpmnVariables.create(Collections.singletonMap("test", "test")));
        processInstanceV1.start();
        JDBCProcessInstances processInstancesV1 = (JDBCProcessInstances)processV1.instances();
        JDBCProcessInstances processInstancesV2 = (JDBCProcessInstances)processV2.instances();
        ProcessInstancesTestUtils.assertOne((ProcessInstances)processInstancesV1);
        Assertions.assertThat((Optional)processInstancesV1.findById(processInstanceV1.id())).isPresent();
        ProcessInstancesTestUtils.assertEmpty((ProcessInstances)processInstancesV2);
        ProcessInstance processInstanceV2 = processV2.createInstance(BpmnVariables.create(Collections.singletonMap("test", "test")));
        processInstanceV2.start();
        ProcessInstancesTestUtils.assertOne((ProcessInstances)processInstancesV2);
        Assertions.assertThat((Optional)processInstancesV2.findById(processInstanceV2.id())).isPresent();
        processInstancesV1.remove(processInstanceV1.id());
        ProcessInstancesTestUtils.assertEmpty((ProcessInstances)processInstancesV1);
        ProcessInstancesTestUtils.assertOne((ProcessInstances)processInstancesV2);
        processInstancesV2.remove(processInstanceV2.id());
        ProcessInstancesTestUtils.assertEmpty((ProcessInstances)processInstancesV2);
    }
}

