/*
 * Decompiled with CFR 0.152.
 */
package org.kie.persistence.jdbc;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.persistence.jdbc.JDBCProcessInstances;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.WorkItem;
import org.kie.kogito.process.bpmn2.BpmnProcess;
import org.kie.kogito.process.bpmn2.BpmnProcessInstance;
import org.kie.kogito.process.bpmn2.BpmnVariables;
import org.kie.kogito.process.workitem.Policy;
import org.kie.persistence.jdbc.TestHelper;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class JdbcProcessInstancesIT
extends TestHelper {
    JdbcProcessInstancesIT() {
    }

    @Test
    void testBasicTaskFlow() {
        BpmnProcess process = JdbcProcessInstancesIT.createProcess(null, "BPMN2-UserTask.bpmn2", false);
        ProcessInstance processInstance = process.createInstance(BpmnVariables.create(Collections.singletonMap("test", "test")));
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        Assertions.assertThat((String)processInstance.description()).isEqualTo("User Task");
        JDBCProcessInstances processInstances = (JDBCProcessInstances)process.instances();
        Assertions.assertThat((Integer)processInstances.size()).isOne();
        Assertions.assertThat((boolean)processInstances.exists(processInstance.id())).isTrue();
        ((JDBCProcessInstances)Mockito.verify((Object)processInstances)).create((String)ArgumentMatchers.any(), (ProcessInstance)ArgumentMatchers.any());
        String testVar = (String)((BpmnVariables)processInstance.variables()).get("test");
        Assertions.assertThat((String)testVar).isEqualTo("test");
        Assertions.assertThat((String)processInstance.description()).isEqualTo("User Task");
        Assertions.assertThat((List)((ProcessInstance)process.instances().values().iterator().next()).workItems(new Policy[]{securityPolicy})).hasSize(1);
        WorkItem workItem = (WorkItem)processInstance.workItems(new Policy[]{securityPolicy}).get(0);
        Assertions.assertThat((Object)workItem).isNotNull();
        Assertions.assertThat((Map)workItem.getParameters()).containsEntry((Object)"ActorId", (Object)"john");
        processInstance.completeWorkItem(workItem.getId(), null, new Policy[]{securityPolicy});
        Assertions.assertThat((int)processInstance.status()).isEqualTo(2);
        processInstances = (JDBCProcessInstances)process.instances();
        ((JDBCProcessInstances)Mockito.verify((Object)processInstances, (VerificationMode)Mockito.times((int)2))).remove(processInstance.id());
        Assertions.assertThat((Integer)processInstances.size()).isZero();
        Assertions.assertThat((Iterable)process.instances().values()).isEmpty();
    }

    @Test
    void testBasicFlow() {
        BpmnProcess process = JdbcProcessInstancesIT.createProcess(null, "BPMN2-UserTask.bpmn2", false);
        ProcessInstance processInstance = process.createInstance(BpmnVariables.create(Collections.singletonMap("test", "test")));
        processInstance.start();
        JDBCProcessInstances processInstances = (JDBCProcessInstances)process.instances();
        Assertions.assertThat((Integer)processInstances.size()).isOne();
        Optional foundOne = processInstances.findById(processInstance.id());
        BpmnProcessInstance instanceOne = (BpmnProcessInstance)foundOne.get();
        processInstances.update(processInstance.id(), (ProcessInstance)instanceOne);
        Assertions.assertThat((Integer)processInstances.size()).isOne();
        Assertions.assertThat((boolean)processInstances.exists("02ac3854-46ee-42b7-8b63-5186c9889d96")).isFalse();
        Optional foundTwo = processInstances.findById("02ac3854-46ee-42b7-8b63-5186c9889d96");
        Assertions.assertThat((Optional)foundTwo).isEmpty();
        processInstances.remove(processInstance.id());
        Assertions.assertThat((Integer)processInstances.size()).isZero();
        Assertions.assertThat((Iterable)process.instances().values()).isEmpty();
    }

    @Test
    void testException() {
        BpmnProcess process = JdbcProcessInstancesIT.configure(false);
        JDBCProcessInstances processInstances = (JDBCProcessInstances)process.instances();
        Assertions.assertThatExceptionOfType(RuntimeException.class).isThrownBy(() -> processInstances.findById("02ac3854-46ee-42b7-8b63-5186c9889d96"));
        Assertions.assertThatExceptionOfType(RuntimeException.class).isThrownBy(() -> processInstances.remove("02ac3854-46ee-42b7-8b63-5186c9889d96"));
    }
}

