/*
 * Decompiled with CFR 0.152.
 */
package org.kie.persistence.jdbc;

import java.util.Collections;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.Model;
import org.kie.kogito.persistence.jdbc.JDBCProcessInstances;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.bpmn2.BpmnProcess;
import org.kie.kogito.process.bpmn2.BpmnProcessInstance;
import org.kie.kogito.process.bpmn2.BpmnVariables;
import org.kie.persistence.jdbc.TestHelper;

class JdbcProcessInstancesWithLockIT
extends TestHelper {
    JdbcProcessInstancesWithLockIT() {
    }

    @Test
    public void testUpdate() {
        BpmnProcess process = JdbcProcessInstancesWithLockIT.createProcess(null, "BPMN2-UserTask.bpmn2", true);
        ProcessInstance processInstance = process.createInstance(BpmnVariables.create(Collections.singletonMap("test", "test")));
        processInstance.start();
        JDBCProcessInstances processInstances = (JDBCProcessInstances)process.instances();
        Assertions.assertThat((Integer)processInstances.size()).isOne();
        Optional foundOne = processInstances.findById(processInstance.id());
        BpmnProcessInstance instanceOne = (BpmnProcessInstance)foundOne.get();
        foundOne = processInstances.findById(processInstance.id());
        BpmnProcessInstance instanceTwo = (BpmnProcessInstance)foundOne.get();
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (Long)instanceOne.version());
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (Long)instanceTwo.version());
        instanceOne.updateVariables((Model)BpmnVariables.create(Collections.singletonMap("s", "test")));
        try {
            BpmnVariables testvar = BpmnVariables.create(Collections.singletonMap("ss", "test"));
            instanceTwo.updateVariables((Model)testvar);
        }
        catch (RuntimeException e) {
            Assertions.assertThat((String)e.getMessage()).isEqualTo("The document with ID: " + instanceOne.id() + " was updated or deleted by other request.");
        }
        foundOne = processInstances.findById(processInstance.id());
        instanceOne = (BpmnProcessInstance)foundOne.get();
        org.junit.jupiter.api.Assertions.assertEquals((long)2L, (Long)instanceOne.version());
        processInstances.remove(processInstance.id());
        Assertions.assertThat((Integer)processInstances.size()).isZero();
        Assertions.assertThat((Iterable)process.instances().values()).isEmpty();
    }

    @Test
    public void testRemove() {
        BpmnProcess process = JdbcProcessInstancesWithLockIT.createProcess(null, "BPMN2-UserTask.bpmn2", true);
        ProcessInstance processInstance = process.createInstance(BpmnVariables.create(Collections.singletonMap("test", "test")));
        processInstance.start();
        JDBCProcessInstances processInstances = (JDBCProcessInstances)process.instances();
        Assertions.assertThat((Integer)processInstances.size()).isOne();
        Optional foundOne = processInstances.findById(processInstance.id());
        BpmnProcessInstance instanceOne = (BpmnProcessInstance)foundOne.get();
        foundOne = processInstances.findById(processInstance.id());
        BpmnProcessInstance instanceTwo = (BpmnProcessInstance)foundOne.get();
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (Long)instanceOne.version());
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (Long)instanceTwo.version());
        processInstances.remove(instanceOne.id());
        try {
            String id = instanceTwo.id();
            processInstances.remove(id);
        }
        catch (RuntimeException e) {
            Assertions.assertThat((String)e.getMessage()).isEqualTo("The document with ID: " + instanceOne.id() + " was deleted by other request.");
        }
    }
}

