/*
 * Decompiled with CFR 0.152.
 */
package org.kie.persistence.jdbc;

import java.util.Objects;
import javax.sql.DataSource;
import org.drools.core.io.impl.ClassPathResource;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.kie.api.io.Resource;
import org.kie.kogito.auth.IdentityProvider;
import org.kie.kogito.auth.IdentityProviders;
import org.kie.kogito.auth.SecurityPolicy;
import org.kie.kogito.persistence.KogitoProcessInstancesFactory;
import org.kie.kogito.persistence.jdbc.JDBCProcessInstances;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessConfig;
import org.kie.kogito.process.ProcessInstanceReadMode;
import org.kie.kogito.process.ProcessInstancesFactory;
import org.kie.kogito.process.bpmn2.BpmnProcess;
import org.kie.kogito.testcontainers.KogitoPostgreSqlContainer;
import org.mockito.Mockito;
import org.postgresql.ds.PGSimpleDataSource;
import org.testcontainers.containers.PostgreSQLContainer;
import org.testcontainers.junit.jupiter.Container;
import org.testcontainers.junit.jupiter.Testcontainers;

@Testcontainers
public class TestHelper {
    @Container
    static final KogitoPostgreSqlContainer container = new KogitoPostgreSqlContainer();
    private static DataSource ds;
    public static SecurityPolicy securityPolicy;
    public static final String TEST_ID = "02ac3854-46ee-42b7-8b63-5186c9889d96";
    private boolean enableLock;

    @BeforeAll
    public static void startContainerAndPublicPortIsAvailable() {
        container.start();
        ds = TestHelper.getDataSource((PostgreSQLContainer)container);
    }

    @AfterAll
    public static void close() {
        container.stop();
    }

    public static BpmnProcess createProcess(ProcessConfig config, String fileName, boolean lock) {
        BpmnProcess process = (BpmnProcess)BpmnProcess.from((ProcessConfig)config, (Resource[])new Resource[]{new ClassPathResource(fileName)}).get(0);
        process.setProcessInstancesFactory((ProcessInstancesFactory)TestHelper.getFactory(lock));
        process.configure();
        process.instances().values(ProcessInstanceReadMode.MUTABLE).forEach(p -> p.abort());
        return process;
    }

    private static JDBCProcessInstancesFactory getFactory(boolean lock) {
        TestHelper t = new TestHelper();
        t.setEnableLock(lock);
        TestHelper testHelper = t;
        Objects.requireNonNull(testHelper);
        return testHelper.new JDBCProcessInstancesFactory(ds);
    }

    private static DataSource getDataSource(PostgreSQLContainer postgreSQLContainer) {
        PGSimpleDataSource ds = new PGSimpleDataSource();
        ds.setUrl(postgreSQLContainer.getJdbcUrl());
        ds.setUser(postgreSQLContainer.getUsername());
        ds.setPassword(postgreSQLContainer.getPassword());
        return ds;
    }

    public static BpmnProcess configure(boolean lock) {
        BpmnProcess process = (BpmnProcess)BpmnProcess.from((Resource[])new Resource[]{new ClassPathResource("BPMN2-UserTask-Script.bpmn2")}).get(0);
        TestHelper t = new TestHelper();
        t.setEnableLock(lock);
        TestHelper testHelper = t;
        Objects.requireNonNull(testHelper);
        process.setProcessInstancesFactory((ProcessInstancesFactory)testHelper.new JDBCProcessInstancesFactory(null));
        process.configure();
        return process;
    }

    public void setEnableLock(boolean enableLock) {
        this.enableLock = enableLock;
    }

    static {
        securityPolicy = SecurityPolicy.of((IdentityProvider)IdentityProviders.of((String)"john"));
    }

    private class JDBCProcessInstancesFactory
    extends KogitoProcessInstancesFactory {
        public JDBCProcessInstancesFactory(DataSource dataSource) {
            super(dataSource, Boolean.valueOf(true));
        }

        public JDBCProcessInstances createProcessInstances(Process<?> process) {
            JDBCProcessInstances instances = (JDBCProcessInstances)Mockito.spy((Object)super.createProcessInstances(process));
            return instances;
        }

        public boolean lock() {
            return TestHelper.this.enableLock;
        }
    }
}

