/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.mongodb;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.bson.Document;
import org.drools.core.io.impl.ClassPathResource;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.kie.api.io.Resource;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.bpmn2.BpmnProcess;
import org.kie.kogito.process.bpmn2.BpmnVariables;
import org.kie.kogito.serialization.process.MarshallerContextName;
import org.kie.kogito.serialization.process.ProcessInstanceMarshallerService;

class DocumentProcessInstanceMarshallerTest {
    ProcessInstanceMarshallerService marshaller = ProcessInstanceMarshallerService.newBuilder().withDefaultObjectMarshallerStrategies().withContextEntries(Collections.singletonMap(MarshallerContextName.MARSHALLER_FORMAT, "json")).build();
    static BpmnProcess process;
    static Document doc;

    DocumentProcessInstanceMarshallerTest() {
    }

    @BeforeAll
    static void setup() throws URISyntaxException, IOException {
        process = (BpmnProcess)BpmnProcess.from((Resource[])new Resource[]{new ClassPathResource("BPMN2-UserTask.bpmn2")}).get(0);
        process.configure();
    }

    @Test
    void testMarshalProcessInstance() {
        ProcessInstance processInstance = process.createInstance(BpmnVariables.create(Collections.singletonMap("test", "testValue")));
        processInstance.start();
        doc = Document.parse((String)new String(this.marshaller.marshallProcessInstance(processInstance)));
        org.junit.jupiter.api.Assertions.assertNotNull((Object)doc, (String)"Marshalled value should not be null");
        Assertions.assertThat((Object)doc.get((Object)"id")).isEqualTo((Object)processInstance.id());
        Assertions.assertThat((Object)doc.get((Object)"description")).isEqualTo((Object)processInstance.description());
        Assertions.assertThat((int)((Document)doc.get((Object)"context", Document.class)).getList((Object)"variable", Document.class).size()).isEqualTo(1);
        Assertions.assertThat((Object)((Document)((Document)doc.get((Object)"context", Document.class)).getList((Object)"variable", Document.class).get(0)).get((Object)"name")).isEqualTo((Object)"test");
        Assertions.assertThat((Object)((Document)((Document)((Document)doc.get((Object)"context", Document.class)).getList((Object)"variable", Document.class).get(0)).get((Object)"value", Document.class)).get((Object)"value")).isEqualTo((Object)"testValue");
    }

    @Test
    void testUnmarshalProcessInstance() {
        ProcessInstance processInstance = this.marshaller.unmarshallProcessInstance(doc.toJson().getBytes(), (Process)process);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)processInstance, (String)"Unmarshalled value should not be null");
        Assertions.assertThat((String)processInstance.id()).isEqualTo(doc.get((Object)"id"));
        Assertions.assertThat((String)processInstance.description()).isEqualTo(doc.get((Object)"description"));
        Assertions.assertThat((String)processInstance.description()).isEqualTo("User Task");
        Collection values = process.instances().values();
        Assertions.assertThat((Collection)values).isNotEmpty();
        BpmnVariables variables = (BpmnVariables)processInstance.variables();
        String testVar = (String)variables.get("test");
        Assertions.assertThat((String)testVar).isEqualTo("testValue");
    }

    @Test
    void testProcessInstanceReadOnly() {
        ProcessInstance processInstance = process.createInstance(BpmnVariables.create(Collections.singletonMap("test", "testValue")));
        processInstance.start();
        doc = Document.parse((String)new String(this.marshaller.marshallProcessInstance(processInstance)));
        ProcessInstance processInstanceReadOnly = this.marshaller.unmarshallProcessInstance(doc.toJson().getBytes(), (Process)process);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)processInstanceReadOnly, (String)"Unmarshalled value should not be null");
        ProcessInstance pi = this.marshaller.unmarshallReadOnlyProcessInstance(doc.toJson().getBytes(), (Process)process);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)pi, (String)"Unmarshalled value should not be null");
    }
}

