/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.mongodb;

import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.mongodb.MongoDBProcessInstances;
import org.kie.kogito.mongodb.TestHelper;
import org.kie.kogito.mongodb.transaction.MongoDBTransactionManager;
import org.kie.kogito.persistence.KogitoProcessInstancesFactory;
import org.kie.kogito.process.Process;
import org.mockito.Mockito;

class KogitoProcessInstancesFactoryIT
extends TestHelper {
    KogitoProcessInstancesFactoryIT() {
    }

    @Test
    void test() {
        final MongoDBTransactionManager transactionManager = (MongoDBTransactionManager)Mockito.mock(MongoDBTransactionManager.class);
        KogitoProcessInstancesFactory factory = new KogitoProcessInstancesFactory(KogitoProcessInstancesFactoryIT.getMongoClient()){

            public String dbName() {
                return "testdb";
            }

            public MongoDBTransactionManager transactionManager() {
                return transactionManager;
            }

            public boolean lock() {
                return false;
            }
        };
        org.junit.jupiter.api.Assertions.assertNotNull((Object)factory);
        Assertions.assertThat((String)factory.dbName()).isEqualTo("testdb");
        Process process = (Process)Mockito.mock(Process.class);
        Mockito.lenient().when((Object)process.id()).thenReturn((Object)"test");
        Mockito.lenient().when((Object)process.name()).thenReturn((Object)"test");
        MongoDBProcessInstances instance = factory.createProcessInstances(process);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)instance);
        org.junit.jupiter.api.Assertions.assertEquals((Object)transactionManager, (Object)factory.transactionManager());
    }
}

