/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.mongodb;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.drools.util.io.ClassPathResource;
import org.junit.jupiter.api.Test;
import org.kie.api.io.Resource;
import org.kie.kogito.Model;
import org.kie.kogito.mongodb.AbstractProcessInstancesFactory;
import org.kie.kogito.mongodb.MongoDBProcessInstances;
import org.kie.kogito.mongodb.TestHelper;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstancesFactory;
import org.kie.kogito.process.bpmn2.BpmnProcess;
import org.kie.kogito.process.bpmn2.BpmnProcessInstance;
import org.kie.kogito.process.bpmn2.BpmnVariables;

class PersistentProcessInstancesWithLockIT
extends TestHelper {
    PersistentProcessInstancesWithLockIT() {
    }

    private BpmnProcess createProcess(MongoDBProcessInstancesFactory factory) {
        BpmnProcess process = (BpmnProcess)BpmnProcess.from((Resource[])new Resource[]{new ClassPathResource("BPMN2-UserTask.bpmn2")}).get(0);
        process.setProcessInstancesFactory((ProcessInstancesFactory)factory);
        process.configure();
        return process;
    }

    @Test
    public void testUpdate() {
        MongoDBProcessInstancesFactory factory = new MongoDBProcessInstancesFactory();
        BpmnProcess process = this.createProcess(factory);
        ProcessInstance processInstance = process.createInstance(BpmnVariables.create(Collections.singletonMap("test", "test")));
        processInstance.start();
        MongoDBProcessInstances processInstances = new MongoDBProcessInstances(PersistentProcessInstancesWithLockIT.getMongoClient(), (Process)process, "testdb", PersistentProcessInstancesWithLockIT.getDisabledMongoDBTransactionManager(), true);
        Assertions.assertThat((Integer)processInstances.size()).isOne();
        Optional foundOne = processInstances.findById(processInstance.id());
        BpmnProcessInstance instanceOne = (BpmnProcessInstance)foundOne.get();
        foundOne = processInstances.findById(processInstance.id());
        BpmnProcessInstance instanceTwo = (BpmnProcessInstance)foundOne.get();
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)instanceOne.version());
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)instanceTwo.version());
        instanceOne.updateVariables((Model)BpmnVariables.create(Collections.singletonMap("s", "test")));
        try {
            BpmnVariables testvar = BpmnVariables.create(Collections.singletonMap("ss", "test"));
            instanceTwo.updateVariables((Model)testvar);
        }
        catch (RuntimeException e) {
            Assertions.assertThat((String)e.getMessage()).isEqualTo("The document with ID: " + instanceOne.id() + " was updated or deleted by other request.");
        }
        foundOne = processInstances.findById(processInstance.id());
        instanceOne = (BpmnProcessInstance)foundOne.get();
        org.junit.jupiter.api.Assertions.assertEquals((long)2L, (long)instanceOne.version());
        processInstances.remove(processInstance.id());
        Assertions.assertThat((Integer)processInstances.size()).isZero();
        Assertions.assertThat((Collection)process.instances().values()).isEmpty();
    }

    @Test
    public void testRemove() {
        MongoDBProcessInstancesFactory factory = new MongoDBProcessInstancesFactory();
        BpmnProcess process = this.createProcess(factory);
        ProcessInstance processInstance = process.createInstance(BpmnVariables.create(Collections.singletonMap("test", "test")));
        processInstance.start();
        MongoDBProcessInstances processInstances = new MongoDBProcessInstances(PersistentProcessInstancesWithLockIT.getMongoClient(), (Process)process, "testdb", PersistentProcessInstancesWithLockIT.getDisabledMongoDBTransactionManager(), true);
        Assertions.assertThat((Integer)processInstances.size()).isOne();
        Optional foundOne = processInstances.findById(processInstance.id());
        BpmnProcessInstance instanceOne = (BpmnProcessInstance)foundOne.get();
        foundOne = processInstances.findById(processInstance.id());
        BpmnProcessInstance instanceTwo = (BpmnProcessInstance)foundOne.get();
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)instanceOne.version());
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (long)instanceTwo.version());
        processInstances.remove(instanceOne.id());
        try {
            String id = instanceTwo.id();
            processInstances.remove(id);
        }
        catch (RuntimeException e) {
            Assertions.assertThat((String)e.getMessage()).isEqualTo("The document with ID: " + instanceOne.id() + " was deleted by other request.");
        }
    }

    private class MongoDBProcessInstancesFactory
    extends AbstractProcessInstancesFactory {
        public MongoDBProcessInstancesFactory() {
            super(TestHelper.getMongoClient(), "testdb", Boolean.valueOf(true), TestHelper.getDisabledMongoDBTransactionManager());
        }
    }
}

