/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.mongodb;

import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoClients;
import com.mongodb.client.MongoCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.StreamSupport;
import org.assertj.core.api.Assertions;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.drools.util.io.ClassPathResource;
import org.jbpm.workflow.core.DroolsAction;
import org.jbpm.workflow.core.WorkflowProcess;
import org.jbpm.workflow.core.node.ActionNode;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.kie.api.definition.process.Node;
import org.kie.api.io.Resource;
import org.kie.kogito.auth.IdentityProvider;
import org.kie.kogito.auth.SecurityPolicy;
import org.kie.kogito.mongodb.AbstractProcessInstancesFactory;
import org.kie.kogito.mongodb.Address;
import org.kie.kogito.mongodb.MongoDBProcessInstances;
import org.kie.kogito.mongodb.PersonWithAddresses;
import org.kie.kogito.mongodb.transaction.AbstractTransactionManager;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstanceReadMode;
import org.kie.kogito.process.ProcessInstances;
import org.kie.kogito.process.ProcessInstancesFactory;
import org.kie.kogito.process.WorkItem;
import org.kie.kogito.process.bpmn2.BpmnProcess;
import org.kie.kogito.process.bpmn2.BpmnVariables;
import org.kie.kogito.process.workitem.Policy;
import org.kie.kogito.services.identity.StaticIdentityProvider;
import org.kie.kogito.testcontainers.KogitoMongoDBContainer;
import org.kie.kogito.uow.events.UnitOfWorkEndEvent;
import org.kie.kogito.uow.events.UnitOfWorkStartEvent;
import org.testcontainers.junit.jupiter.Container;
import org.testcontainers.junit.jupiter.Testcontainers;

@Testcontainers
class MongoDBProcessInstancesIT {
    private SecurityPolicy securityPolicy = SecurityPolicy.of((IdentityProvider)new StaticIdentityProvider("john"));
    @Container
    static final KogitoMongoDBContainer mongoDBContainer = new KogitoMongoDBContainer();
    static final String DB_NAME = "testdb";
    static final String COLLECTION_NAME = "UserTask";
    static final String TEST_ID = "test";
    private static MongoClient mongoClient;

    MongoDBProcessInstancesIT() {
    }

    @BeforeAll
    public static void startContainerAndPublicPortIsAvailable() {
        mongoDBContainer.start();
        mongoClient = MongoClients.create((String)mongoDBContainer.getReplicaSetUrl());
        MongoCollection collection = mongoClient.getDatabase(DB_NAME).getCollection(COLLECTION_NAME);
        collection.insertOne((Object)new Document().append("_id", (Object)TEST_ID));
        collection.deleteOne((Bson)new Document().append("_id", (Object)TEST_ID));
    }

    @AfterAll
    public static void close() {
        mongoDBContainer.stop();
    }

    @Test
    void test() {
        AbstractTransactionManager transactionManager = new AbstractTransactionManager(mongoClient, false){};
        this.test(transactionManager);
    }

    @Test
    void testWithTransaction() {
        AbstractTransactionManager transactionManager = new AbstractTransactionManager(mongoClient, true){};
        transactionManager.onBeforeStartEvent(new UnitOfWorkStartEvent(null));
        this.test(transactionManager);
        transactionManager.onAfterEndEvent(new UnitOfWorkEndEvent(null));
    }

    private void test(AbstractTransactionManager transactionManager) {
        BpmnProcess process = (BpmnProcess)BpmnProcess.from((Resource[])new Resource[]{new ClassPathResource("BPMN2-UserTask.bpmn2")}).get(0);
        process.setProcessInstancesFactory((ProcessInstancesFactory)new MongoDBProcessInstancesFactory(mongoClient, transactionManager));
        process.configure();
        this.testIndexCreation(process);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put(TEST_ID, TEST_ID);
        parameters.put("integerVar", 10);
        parameters.put("booleanVar", true);
        parameters.put("doubleVar", 10.11);
        parameters.put("floatVar", Float.valueOf(3.5f));
        parameters.put("address", new Address("main street", "Boston", "10005", "US"));
        PersonWithAddresses pa = new PersonWithAddresses("bob", 16);
        ArrayList<Address> list = new ArrayList<Address>();
        list.add(new Address("main street", "Boston", "10005", "US"));
        list.add(new Address("new Street", "Charlotte", "28200", "US"));
        pa.setAddresses(list);
        parameters.put("pa", pa);
        parameters.put("addresslist", list);
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        map.put("addresslist", list);
        map.put(1, "ss");
        map.put("2", "kk");
        HashMap<Object, Object> testMap = new HashMap<Object, Object>();
        testMap.put("addresslist", list);
        testMap.put(1, "integer");
        testMap.put("2", "string");
        testMap.put("map", map);
        parameters.put("testMap", testMap);
        ProcessInstance processInstance = process.createInstance(BpmnVariables.create(parameters));
        processInstance.start();
        Assertions.assertThat((int)processInstance.status()).isEqualTo(1);
        Assertions.assertThat((String)processInstance.description()).isEqualTo("User Task");
        Collection values = process.instances().values();
        Assertions.assertThat((Collection)values).hasSize(1);
        String testVar = (String)((BpmnVariables)processInstance.variables()).get(TEST_ID);
        Assertions.assertThat((String)testVar).isEqualTo(TEST_ID);
        Object addr = ((BpmnVariables)processInstance.variables()).get("address");
        Assertions.assertThat((String)addr.getClass().getName()).isEqualTo("org.kie.kogito.mongodb.Address");
        Object flt = ((BpmnVariables)processInstance.variables()).get("floatVar");
        Assertions.assertThat((String)flt.getClass().getName()).isEqualTo("java.lang.Float");
        Assertions.assertThat((String)processInstance.description()).isEqualTo("User Task");
        List workItems = processInstance.workItems(new Policy[]{this.securityPolicy});
        Assertions.assertThat((List)workItems).hasSize(1);
        WorkItem workItem = (WorkItem)workItems.get(0);
        org.junit.jupiter.api.Assertions.assertEquals((Object)"john", workItem.getParameters().get("ActorId"));
        processInstance.completeWorkItem(workItem.getId(), null, new Policy[]{this.securityPolicy});
        org.junit.jupiter.api.Assertions.assertEquals((int)2, (int)processInstance.status());
        Assertions.assertThat((Integer)process.instances().size()).isZero();
    }

    private void testIndexCreation(BpmnProcess process) {
        Assertions.assertThat((Object)process.instances()).isInstanceOf(MongoDBProcessInstances.class);
        MongoDBProcessInstances mongoDBProcessInstances = (MongoDBProcessInstances)process.instances();
        Assertions.assertThat((Object)mongoDBProcessInstances.getCollection()).isNotNull();
        Assertions.assertThat(StreamSupport.stream(mongoDBProcessInstances.getCollection().listIndexes().spliterator(), false).map(Document.class::cast).filter(index -> ((Document)index).get((Object)"name").equals("index_process_instance_id")).findFirst()).isPresent();
    }

    @Test
    void testFindByIdReadMode() {
        AbstractTransactionManager transactionManager = new AbstractTransactionManager(mongoClient, false){};
        this.testFindByIdReadMode(transactionManager);
    }

    @Test
    void testFindByIdReadModeWithTransaction() {
        AbstractTransactionManager transactionManager = new AbstractTransactionManager(mongoClient, true){};
        transactionManager.onBeforeStartEvent(new UnitOfWorkStartEvent(null));
        this.testFindByIdReadMode(transactionManager);
        transactionManager.onAfterEndEvent(new UnitOfWorkEndEvent(null));
    }

    void testFindByIdReadMode(AbstractTransactionManager transactionManager) {
        BpmnProcess process = (BpmnProcess)BpmnProcess.from((Resource[])new Resource[]{new ClassPathResource("BPMN2-UserTask-Script.bpmn2")}).get(0);
        for (Node node : ((WorkflowProcess)process.get()).getNodes()) {
            if (!(node instanceof ActionNode)) continue;
            DroolsAction a = ((ActionNode)node).getAction();
            a.setMetaData("Action", kcontext -> {
                System.out.println("The variable value is " + kcontext.getVariable("s") + " about to call toString on it");
                kcontext.getVariable("s").toString();
            });
        }
        process.setProcessInstancesFactory((ProcessInstancesFactory)new MongoDBProcessInstancesFactory(mongoClient, transactionManager));
        process.configure();
        ProcessInstance mutablePi = process.createInstance(BpmnVariables.create(Collections.singletonMap("var", "value")));
        mutablePi.start();
        Assertions.assertThat((int)mutablePi.status()).isEqualTo(5);
        Assertions.assertThat((Optional)mutablePi.error()).hasValueSatisfying(error -> {
            Assertions.assertThat((String)error.errorMessage()).contains(new CharSequence[]{"java.lang.NullPointerException"});
            Assertions.assertThat((String)error.failedNodeId()).isEqualTo("ScriptTask_1");
        });
        Assertions.assertThat((Map)((BpmnVariables)mutablePi.variables()).toMap()).containsExactly(new Map.Entry[]{Assertions.entry((Object)"var", (Object)"value")});
        ProcessInstances instances = process.instances();
        Assertions.assertThat((Integer)instances.size()).isOne();
        ProcessInstance pi = (ProcessInstance)instances.findById(mutablePi.id(), ProcessInstanceReadMode.READ_ONLY).get();
        Assertions.assertThatExceptionOfType(UnsupportedOperationException.class).isThrownBy(() -> pi.abort());
        ProcessInstance readOnlyPi = (ProcessInstance)instances.findById(mutablePi.id(), ProcessInstanceReadMode.READ_ONLY).get();
        Assertions.assertThat((int)readOnlyPi.status()).isEqualTo(5);
        Assertions.assertThat((Optional)readOnlyPi.error()).hasValueSatisfying(error -> {
            Assertions.assertThat((String)error.errorMessage()).contains(new CharSequence[]{"java.lang.NullPointerException"});
            Assertions.assertThat((String)error.failedNodeId()).isEqualTo("ScriptTask_1");
        });
        Assertions.assertThat((Map)((BpmnVariables)readOnlyPi.variables()).toMap()).containsExactly(new Map.Entry[]{Assertions.entry((Object)"var", (Object)"value")});
        Assertions.assertThatExceptionOfType(UnsupportedOperationException.class).isThrownBy(() -> readOnlyPi.abort());
        ((ProcessInstance)instances.findById(mutablePi.id()).get()).abort();
        Assertions.assertThat((Integer)instances.size()).isZero();
    }

    @Test
    void testValuesReadMode() {
        AbstractTransactionManager transactionManager = new AbstractTransactionManager(mongoClient, false){};
        this.testValuesReadMode(transactionManager);
    }

    @Test
    void testValuesReadModeWithTransaction() {
        AbstractTransactionManager transactionManager = new AbstractTransactionManager(mongoClient, true){};
        transactionManager.onBeforeStartEvent(new UnitOfWorkStartEvent(null));
        this.testValuesReadMode(transactionManager);
        transactionManager.onAfterEndEvent(new UnitOfWorkEndEvent(null));
    }

    void testValuesReadMode(AbstractTransactionManager transactionManager) {
        BpmnProcess process = (BpmnProcess)BpmnProcess.from((Resource[])new Resource[]{new ClassPathResource("BPMN2-UserTask.bpmn2")}).get(0);
        process.setProcessInstancesFactory((ProcessInstancesFactory)new MongoDBProcessInstancesFactory(mongoClient, transactionManager));
        process.configure();
        ProcessInstance processInstance = process.createInstance(BpmnVariables.create(Collections.singletonMap(TEST_ID, TEST_ID)));
        processInstance.start();
        ProcessInstances instances = process.instances();
        Assertions.assertThat((Integer)instances.size()).isOne();
        ProcessInstance pi = (ProcessInstance)instances.values().stream().findFirst().get();
        Assertions.assertThatExceptionOfType(UnsupportedOperationException.class).isThrownBy(() -> pi.abort());
        ((ProcessInstance)instances.values(ProcessInstanceReadMode.MUTABLE).stream().findFirst().get()).abort();
        Assertions.assertThat((Integer)instances.size()).isZero();
    }

    private class MongoDBProcessInstancesFactory
    extends AbstractProcessInstancesFactory {
        public MongoDBProcessInstancesFactory(MongoClient mongoClient, AbstractTransactionManager transactionManager) {
            super(mongoClient, MongoDBProcessInstancesIT.DB_NAME, Boolean.valueOf(false), transactionManager);
        }
    }
}

