/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.mongodb.transaction;

import com.mongodb.TransactionOptions;
import com.mongodb.client.ClientSession;
import com.mongodb.client.MongoClient;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.mongodb.transaction.AbstractTransactionManager;
import org.kie.kogito.uow.events.UnitOfWorkAbortEvent;
import org.kie.kogito.uow.events.UnitOfWorkEndEvent;
import org.kie.kogito.uow.events.UnitOfWorkStartEvent;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class AbstractTransactionManagerTest {
    private static final int TEST_THREADS = 10;
    private MongoClient mongoClient;
    private ClientSession clientSession;
    private AbstractTransactionManager manager;

    AbstractTransactionManagerTest() {
    }

    @BeforeEach
    void setUp() {
        this.mongoClient = (MongoClient)Mockito.mock(MongoClient.class);
        this.clientSession = (ClientSession)Mockito.mock(ClientSession.class);
        Mockito.when((Object)this.mongoClient.startSession()).thenReturn((Object)this.clientSession);
        this.manager = new AbstractTransactionManager(this.mongoClient, true){};
    }

    @Test
    void test() throws InterruptedException, ExecutionException, TimeoutException {
        ExecutorService service = Executors.newFixedThreadPool(10);
        ArrayList results = new ArrayList();
        for (int i = 0; i < 10; ++i) {
            results.add(service.submit(() -> {
                this.manager.onBeforeStartEvent(new UnitOfWorkStartEvent(null));
                this.manager.onAfterEndEvent(new UnitOfWorkEndEvent(null));
            }));
        }
        for (Future future : results) {
            future.get(2L, TimeUnit.SECONDS);
        }
        ((MongoClient)Mockito.verify((Object)this.mongoClient, (VerificationMode)Mockito.times((int)10))).startSession();
        ((ClientSession)Mockito.verify((Object)this.clientSession, (VerificationMode)Mockito.times((int)10))).startTransaction((TransactionOptions)Mockito.any());
        ((ClientSession)Mockito.verify((Object)this.clientSession, (VerificationMode)Mockito.times((int)10))).commitTransaction();
        ((ClientSession)Mockito.verify((Object)this.clientSession, (VerificationMode)Mockito.times((int)10))).close();
    }

    @Test
    void enabled() {
        AbstractTransactionManager manager = new AbstractTransactionManager(this.mongoClient, false){};
        manager.onBeforeStartEvent(new UnitOfWorkStartEvent(null));
        manager.onAfterAbortEvent(new UnitOfWorkAbortEvent(null));
        ((MongoClient)Mockito.verify((Object)this.mongoClient, (VerificationMode)Mockito.never())).startSession();
    }

    @Test
    void onBeforeStartEvent() {
        this.manager.onBeforeStartEvent(new UnitOfWorkStartEvent(null));
        ((ClientSession)Mockito.verify((Object)this.clientSession, (VerificationMode)Mockito.times((int)1))).startTransaction((TransactionOptions)Mockito.any());
    }

    @Test
    void onAfterEndEvent() {
        this.manager.onBeforeStartEvent(new UnitOfWorkStartEvent(null));
        this.manager.onAfterEndEvent(new UnitOfWorkEndEvent(null));
        ((ClientSession)Mockito.verify((Object)this.clientSession, (VerificationMode)Mockito.times((int)1))).commitTransaction();
        ((ClientSession)Mockito.verify((Object)this.clientSession, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    void onAfterAbortEvent() {
        this.manager.onBeforeStartEvent(new UnitOfWorkStartEvent(null));
        this.manager.onAfterAbortEvent(new UnitOfWorkAbortEvent(null));
        ((ClientSession)Mockito.verify((Object)this.clientSession, (VerificationMode)Mockito.times((int)1))).abortTransaction();
        ((ClientSession)Mockito.verify((Object)this.clientSession, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    void getClientSession() {
        Assertions.assertNull((Object)this.manager.getClientSession());
        this.manager.onBeforeStartEvent(new UnitOfWorkStartEvent(null));
        Assertions.assertEquals((Object)this.clientSession, (Object)this.manager.getClientSession());
    }
}

