/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.mongodb;

import com.mongodb.MongoClientSettings;
import com.mongodb.client.ClientSession;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.IndexOptions;
import com.mongodb.client.model.Indexes;
import com.mongodb.client.result.UpdateResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.bson.Document;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.bson.conversions.Bson;
import org.kie.kogito.Model;
import org.kie.kogito.mongodb.transaction.AbstractTransactionManager;
import org.kie.kogito.process.MutableProcessInstances;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstanceDuplicatedException;
import org.kie.kogito.process.ProcessInstanceOptimisticLockingException;
import org.kie.kogito.process.ProcessInstanceReadMode;
import org.kie.kogito.process.impl.AbstractProcessInstance;
import org.kie.kogito.serialization.process.MarshallerContextName;
import org.kie.kogito.serialization.process.ProcessInstanceMarshallerService;

public class MongoDBProcessInstances<T extends Model>
implements MutableProcessInstances<T> {
    private static final String VERSION = "version";
    private Process<?> process;
    private ProcessInstanceMarshallerService marshaller;
    private final MongoCollection<Document> collection;
    private AbstractTransactionManager transactionManager;
    private final boolean lock;

    public MongoDBProcessInstances(MongoClient mongoClient, Process<?> process, String dbName, AbstractTransactionManager transactionManager, boolean lock) {
        this.process = process;
        this.collection = this.getCollection(mongoClient, process.id(), dbName);
        this.marshaller = ProcessInstanceMarshallerService.newBuilder().withDefaultObjectMarshallerStrategies().withContextEntries(Collections.singletonMap(MarshallerContextName.MARSHALLER_FORMAT, "json")).build();
        this.transactionManager = transactionManager;
        this.lock = lock;
    }

    public Optional<ProcessInstance<T>> findById(String id, ProcessInstanceReadMode mode) {
        Document piDoc = this.find(id);
        if (piDoc != null) {
            ProcessInstance<T> instance = this.unmarshall(piDoc, mode);
            MongoDBProcessInstances.setVersion(instance, piDoc.getLong((Object)VERSION));
            return Optional.of(instance);
        }
        return Optional.empty();
    }

    public Collection<ProcessInstance<T>> values(ProcessInstanceReadMode mode) {
        FindIterable docs = Optional.ofNullable(this.transactionManager.getClientSession()).map(arg_0 -> this.collection.find(arg_0)).orElseGet(() -> this.collection.find());
        ArrayList<ProcessInstance<T>> list = new ArrayList<ProcessInstance<T>>();
        try (MongoCursor cursor = docs.iterator();){
            while (cursor.hasNext()) {
                list.add(this.unmarshall((Document)cursor.next(), mode));
            }
        }
        return list;
    }

    private ProcessInstance<T> unmarshall(Document document, ProcessInstanceReadMode mode) {
        byte[] content = document.toJson().getBytes();
        return mode == ProcessInstanceReadMode.MUTABLE ? this.marshaller.unmarshallProcessInstance(content, this.process) : this.marshaller.unmarshallReadOnlyProcessInstance(content, this.process);
    }

    public void create(String id, ProcessInstance<T> instance) {
        this.updateStorage(id, instance, true);
    }

    public void update(String id, ProcessInstance<T> instance) {
        if (this.isActive(instance)) {
            this.updateStorage(id, instance, false);
        }
        this.reloadProcessInstance(instance, id);
    }

    protected void updateStorage(String id, ProcessInstance<T> instance, boolean checkDuplicates) {
        ClientSession clientSession = this.transactionManager.getClientSession();
        Document doc = Document.parse((String)new String(this.marshaller.marshallProcessInstance(instance)));
        if (checkDuplicates) {
            this.createInternal(id, clientSession, doc);
        } else {
            this.updateInternal(id, instance, clientSession, doc);
        }
    }

    private void createInternal(String id, ClientSession clientSession, Document doc) {
        if (this.exists(id)) {
            throw new ProcessInstanceDuplicatedException(id);
        }
        doc.put(VERSION, (Object)0L);
        if (clientSession != null) {
            this.collection.insertOne(clientSession, (Object)doc);
        } else {
            this.collection.insertOne((Object)doc);
        }
    }

    private void updateInternal(String id, ProcessInstance<T> instance, ClientSession clientSession, Document doc) {
        Bson filters = Filters.eq((String)"id", (Object)id);
        if (this.lock) {
            doc.put(VERSION, (Object)(instance.version() + 1L));
            filters = Filters.and((Bson[])new Bson[]{Filters.eq((String)"id", (Object)id), Filters.eq((String)VERSION, (Object)instance.version())});
        }
        UpdateResult result = clientSession != null ? this.collection.replaceOne(clientSession, filters, (Object)doc) : this.collection.replaceOne(filters, (Object)doc);
        if (this.lock && result.getModifiedCount() != 1L) {
            throw new ProcessInstanceOptimisticLockingException(id);
        }
    }

    private Document find(String id) {
        if (this.transactionManager == null || this.collection == null) {
            throw new IllegalArgumentException("Transaction manager is null");
        }
        return Optional.ofNullable(this.transactionManager.getClientSession()).map(r -> (Document)this.collection.find(r, Filters.eq((String)"id", (Object)id)).first()).orElseGet(() -> (Document)this.collection.find(Filters.eq((String)"id", (Object)id)).first());
    }

    public boolean exists(String id) {
        return this.find(id) != null;
    }

    public void remove(String id) {
        ClientSession clientSession = this.transactionManager.getClientSession();
        if (clientSession != null) {
            this.collection.deleteOne(clientSession, Filters.eq((String)"id", (Object)id));
        } else {
            this.collection.deleteOne(Filters.eq((String)"id", (Object)id));
        }
    }

    private void reloadProcessInstance(ProcessInstance<T> instance, String id) {
        ((AbstractProcessInstance)instance).internalRemoveProcessInstance(this.marshaller.createdReloadFunction(() -> {
            Document reloaded = this.find(id);
            if (reloaded != null) {
                MongoDBProcessInstances.setVersion(instance, reloaded.getLong((Object)VERSION));
                return reloaded.toJson().getBytes();
            }
            throw new IllegalArgumentException("process instance id " + id + " does not exists in mongodb");
        }));
    }

    private static void setVersion(ProcessInstance<?> instance, Long version) {
        ((AbstractProcessInstance)instance).setVersion(version == null ? 0L : version);
    }

    public Integer size() {
        return Optional.ofNullable(this.transactionManager.getClientSession()).map(r -> (int)this.collection.countDocuments(r)).orElseGet(() -> (int)this.collection.countDocuments());
    }

    public boolean lock() {
        return this.lock;
    }

    protected MongoCollection<Document> getCollection() {
        return this.collection;
    }

    private MongoCollection<Document> getCollection(MongoClient mongoClient, String processId, String dbName) {
        CodecRegistry registry = CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{MongoClientSettings.getDefaultCodecRegistry()});
        MongoDatabase mongoDatabase = mongoClient.getDatabase(dbName).withCodecRegistry(registry);
        MongoCollection collection = mongoDatabase.getCollection(processId, Document.class).withCodecRegistry(registry);
        collection.createIndex(Indexes.ascending((String[])new String[]{"id"}), new IndexOptions().unique(true).name("index_process_instance_id").background(true));
        return collection;
    }
}

