/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.mongodb;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.mongodb.client.MongoClient;
import com.mongodb.client.MongoCollection;
import org.assertj.core.api.Assertions;
import org.bson.Document;
import org.junit.jupiter.api.Test;
import org.kie.kogito.mongodb.DocumentUnmarshallingException;
import org.kie.kogito.mongodb.TestHelper;
import org.kie.kogito.mongodb.utils.DocumentUtils;

class DocumentUtilsIT
extends TestHelper {
    DocumentUtilsIT() {
    }

    @Test
    void testGetCollection() {
        MongoCollection collection = DocumentUtils.getCollection((MongoClient)DocumentUtilsIT.getMongoClient(), (String)"testCollection", (String)"testdb");
        Assertions.assertThat((String)collection.getDocumentClass().getSimpleName()).isEqualTo(Document.class.getSimpleName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"testdb", (Object)collection.getNamespace().getDatabaseName());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"testCollection", (Object)collection.getNamespace().getCollectionName());
    }

    @Test
    void testToByteArray() throws JsonProcessingException {
        org.junit.jupiter.api.Assertions.assertArrayEquals((byte[])DocumentUtilsIT.getTestByteArrays(), (byte[])DocumentUtils.toByteArray((Object)DocumentUtilsIT.getTestObject()));
    }

    @Test
    void testFromByteArray() throws JsonProcessingException {
        Object value = DocumentUtils.fromByteArray((String)DocumentUtilsIT.getTestObject().getClass().getCanonicalName(), (byte[])DocumentUtilsIT.getTestByteArrays());
        org.junit.jupiter.api.Assertions.assertNotNull((Object)value, (String)"Unmarshalled value should not be null");
        org.junit.jupiter.api.Assertions.assertEquals((Object)DocumentUtilsIT.getTestObject().getClass().getCanonicalName(), (Object)value.getClass().getCanonicalName(), (String)"Object should be same.");
    }

    @Test
    void testFromByteArrayException() throws JsonProcessingException {
        byte[] data = DocumentUtilsIT.getTestByteArrays();
        org.junit.jupiter.api.Assertions.assertThrows(DocumentUnmarshallingException.class, () -> DocumentUtils.fromByteArray((String)"test", (byte[])data));
    }
}

