/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.mongodb;

import com.mongodb.client.MongoClient;
import java.util.Collections;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.drools.core.io.impl.ClassPathResource;
import org.junit.jupiter.api.Test;
import org.kie.api.io.Resource;
import org.kie.kogito.Model;
import org.kie.kogito.mongodb.MongoDBProcessInstances;
import org.kie.kogito.mongodb.TestHelper;
import org.kie.kogito.mongodb.transaction.MongoDBTransactionManager;
import org.kie.kogito.persistence.KogitoProcessInstancesFactory;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstancesFactory;
import org.kie.kogito.process.bpmn2.BpmnProcess;
import org.kie.kogito.process.bpmn2.BpmnProcessInstance;
import org.kie.kogito.process.bpmn2.BpmnVariables;

class PersistentProcessInstancesWithLockIT
extends TestHelper {
    PersistentProcessInstancesWithLockIT() {
    }

    private BpmnProcess createProcess(MongoDBProcessInstancesFactory factory) {
        BpmnProcess process = (BpmnProcess)BpmnProcess.from((Resource[])new Resource[]{new ClassPathResource("BPMN2-UserTask.bpmn2")}).get(0);
        process.setProcessInstancesFactory((ProcessInstancesFactory)factory);
        process.configure();
        return process;
    }

    @Test
    public void testUpdate() {
        MongoDBProcessInstancesFactory factory = new MongoDBProcessInstancesFactory(PersistentProcessInstancesWithLockIT.getMongoClient());
        BpmnProcess process = this.createProcess(factory);
        ProcessInstance processInstance = process.createInstance(BpmnVariables.create(Collections.singletonMap("test", "test")));
        processInstance.start();
        MongoDBProcessInstances processInstances = new MongoDBProcessInstances(PersistentProcessInstancesWithLockIT.getMongoClient(), (Process)process, "testdb", factory.transactionManager(), true);
        Assertions.assertThat((Integer)processInstances.size()).isOne();
        Optional foundOne = processInstances.findById(processInstance.id());
        BpmnProcessInstance instanceOne = (BpmnProcessInstance)foundOne.get();
        foundOne = processInstances.findById(processInstance.id());
        BpmnProcessInstance instanceTwo = (BpmnProcessInstance)foundOne.get();
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (Long)instanceOne.version());
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (Long)instanceTwo.version());
        instanceOne.updateVariables((Model)BpmnVariables.create(Collections.singletonMap("s", "test")));
        try {
            BpmnVariables testvar = BpmnVariables.create(Collections.singletonMap("ss", "test"));
            instanceTwo.updateVariables((Model)testvar);
        }
        catch (RuntimeException e) {
            Assertions.assertThat((String)e.getMessage()).isEqualTo("The document with ID: " + instanceOne.id() + " was updated or deleted by other request.");
        }
        foundOne = processInstances.findById(processInstance.id());
        instanceOne = (BpmnProcessInstance)foundOne.get();
        org.junit.jupiter.api.Assertions.assertEquals((long)2L, (Long)instanceOne.version());
        processInstances.remove(processInstance.id());
        Assertions.assertThat((Integer)processInstances.size()).isZero();
        Assertions.assertThat((Iterable)process.instances().values()).isEmpty();
    }

    @Test
    public void testRemove() {
        MongoDBProcessInstancesFactory factory = new MongoDBProcessInstancesFactory(PersistentProcessInstancesWithLockIT.getMongoClient());
        BpmnProcess process = this.createProcess(factory);
        ProcessInstance processInstance = process.createInstance(BpmnVariables.create(Collections.singletonMap("test", "test")));
        processInstance.start();
        MongoDBProcessInstances processInstances = new MongoDBProcessInstances(PersistentProcessInstancesWithLockIT.getMongoClient(), (Process)process, "testdb", factory.transactionManager(), true);
        Assertions.assertThat((Integer)processInstances.size()).isOne();
        Optional foundOne = processInstances.findById(processInstance.id());
        BpmnProcessInstance instanceOne = (BpmnProcessInstance)foundOne.get();
        foundOne = processInstances.findById(processInstance.id());
        BpmnProcessInstance instanceTwo = (BpmnProcessInstance)foundOne.get();
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (Long)instanceOne.version());
        org.junit.jupiter.api.Assertions.assertEquals((long)1L, (Long)instanceTwo.version());
        processInstances.remove(instanceOne.id());
        try {
            String id = instanceTwo.id();
            processInstances.remove(id);
        }
        catch (RuntimeException e) {
            Assertions.assertThat((String)e.getMessage()).isEqualTo("The document with ID: " + instanceOne.id() + " was deleted by other request.");
        }
    }

    private class MongoDBProcessInstancesFactory
    extends KogitoProcessInstancesFactory {
        MongoDBTransactionManager transactionManager;

        public MongoDBProcessInstancesFactory(MongoClient mongoClient) {
            super(mongoClient);
            this.transactionManager = new MongoDBTransactionManager(mongoClient){

                public boolean enabled() {
                    return false;
                }
            };
        }

        public String dbName() {
            return "testdb";
        }

        public MongoDBTransactionManager transactionManager() {
            return this.transactionManager;
        }

        public boolean lock() {
            return true;
        }
    }
}

