/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.rocksdb;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.assertj.core.api.Assertions;
import org.drools.io.ClassPathResource;
import org.jbpm.workflow.instance.WorkflowProcessInstance;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.kie.api.io.Resource;
import org.kie.kogito.persistence.rocksdb.RocksDBProcessInstancesFactory;
import org.kie.kogito.process.MutableProcessInstances;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstancesFactory;
import org.kie.kogito.process.bpmn2.BpmnProcess;
import org.kie.kogito.process.bpmn2.BpmnVariables;
import org.kie.kogito.process.impl.AbstractProcessInstance;
import org.mockito.Mockito;
import org.rocksdb.Options;
import org.rocksdb.RocksDBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RockDBProcessInstancesTest {
    private static Options options;
    private static final Logger logger;
    @TempDir
    Path tempDir;
    private RocksDBProcessInstancesFactory factory;
    private BpmnProcess process;
    private MutableProcessInstances pi;

    RockDBProcessInstancesTest() {
    }

    @BeforeAll
    static void init() {
        options = new Options().setCreateIfMissing(true);
    }

    @BeforeEach
    void setup() throws RocksDBException {
        this.factory = new RocksDBProcessInstancesFactory(options, this.tempDir.toString());
        this.process = this.createProcess("BPMN2-UserTask.bpmn2");
        this.pi = this.factory.createProcessInstances((Process)this.process);
    }

    @AfterEach
    void close() {
        this.factory.close();
    }

    @AfterAll
    static void cleanUp() {
        options.close();
    }

    private BpmnProcess createProcess(String fileName) {
        BpmnProcess process = (BpmnProcess)BpmnProcess.from((Resource[])new Resource[]{new ClassPathResource(fileName)}).get(0);
        process.setProcessInstancesFactory((ProcessInstancesFactory)this.factory);
        process.configure();
        return process;
    }

    @Test
    void testBasic() {
        Assertions.assertThat((Object)this.pi).isNotNull();
        WorkflowProcessInstance createPi = this.createProcessInstance();
        try (Stream stream = this.pi.stream();){
            Assertions.assertThat((long)stream.count()).isOne();
        }
        this.removeProcessInstance(createPi);
        stream = this.pi.stream();
        try {
            Assertions.assertThat((long)stream.count()).isZero();
        }
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    @Test
    void testMultiThread() throws InterruptedException, ExecutionException {
        int numConcurrent = 10;
        ExecutorService service = Executors.newFixedThreadPool(numConcurrent);
        ArrayList<Future<WorkflowProcessInstance>> futures = new ArrayList<Future<WorkflowProcessInstance>>();
        while (--numConcurrent > 0) {
            futures.add(service.submit(() -> this.createProcessInstance()));
        }
        ArrayList<WorkflowProcessInstance> instances = new ArrayList<WorkflowProcessInstance>();
        for (Future future : futures) {
            instances.add((WorkflowProcessInstance)future.get());
        }
        instances.forEach(instance -> service.submit(() -> this.removeProcessInstance((WorkflowProcessInstance)instance)));
        service.shutdown();
        Assertions.assertThat((boolean)service.awaitTermination(2L, TimeUnit.SECONDS)).isTrue();
        try (Stream stream = this.pi.stream();){
            Assertions.assertThat((long)stream.count()).isZero();
        }
    }

    WorkflowProcessInstance createProcessInstance() {
        WorkflowProcessInstance instance = ((AbstractProcessInstance)this.process.createInstance(BpmnVariables.create(Collections.singletonMap("test", "test")))).internalGetProcessInstance();
        logger.debug("Created instance {}", (Object)instance.getId());
        instance.setStartDate(new Date());
        this.pi.create(instance.getId(), RockDBProcessInstancesTest.mockProcessInstance(instance));
        Assertions.assertThat((boolean)this.pi.exists(instance.getId())).isTrue();
        Assertions.assertThat((Optional)this.pi.findById(instance.getId())).isNotEmpty();
        Assertions.assertThat((Optional)this.pi.findById("non_existant")).isEmpty();
        return instance;
    }

    void removeProcessInstance(WorkflowProcessInstance instance) {
        this.pi.remove(instance.getId());
        logger.debug("Removed instance {}", (Object)instance.getId());
        Assertions.assertThat((boolean)this.pi.exists(instance.getId())).isFalse();
        logger.debug("About to check instance {}", (Object)instance.getId());
        Assertions.assertThat((Optional)this.pi.findById(instance.getId())).isNotPresent();
        logger.debug("Checked removed instance {}", (Object)instance.getId());
    }

    private static AbstractProcessInstance<?> mockProcessInstance(WorkflowProcessInstance pi) {
        AbstractProcessInstance mockPi = (AbstractProcessInstance)Mockito.mock(AbstractProcessInstance.class);
        mockPi.setVersion(1L);
        Mockito.when((Object)mockPi.status()).thenReturn((Object)1);
        Mockito.when((Object)mockPi.internalGetProcessInstance()).thenReturn((Object)pi);
        Mockito.when((Object)mockPi.id()).thenReturn((Object)pi.getId());
        return mockPi;
    }

    static {
        logger = LoggerFactory.getLogger(RockDBProcessInstancesTest.class);
    }
}

