/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.persistence.rocksdb;

import java.io.Closeable;
import java.util.Optional;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.kie.kogito.process.MutableProcessInstances;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstanceReadMode;
import org.kie.kogito.serialization.process.ProcessInstanceMarshallerService;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;
import org.rocksdb.RocksIterator;

public class RocksDBProcessInstances<T>
implements MutableProcessInstances<T> {
    private final Process<T> process;
    private final ProcessInstanceMarshallerService marshaller;
    private final RocksDB db;

    public RocksDBProcessInstances(Process<T> process, RocksDB db) {
        this.process = process;
        this.marshaller = ProcessInstanceMarshallerService.newBuilder().withDefaultObjectMarshallerStrategies().build();
        this.db = db;
    }

    public Optional<ProcessInstance<T>> findById(String id, ProcessInstanceReadMode mode) {
        try {
            byte[] data = this.db.get(id.getBytes());
            return data == null ? Optional.empty() : Optional.of(this.unmarshall(data));
        }
        catch (RocksDBException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public Stream<ProcessInstance<T>> stream(ProcessInstanceReadMode mode) {
        RockSplitIterator iterator = new RockSplitIterator(this.db.newIterator());
        return (Stream)StreamSupport.stream(iterator, false).onClose(iterator::close);
    }

    public boolean exists(String id) {
        try {
            return this.db.get(id.getBytes()) != null;
        }
        catch (RocksDBException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public void create(String id, ProcessInstance<T> instance) {
        this.update(id, instance);
    }

    public void update(String id, ProcessInstance<T> instance) {
        try {
            this.db.put(id.getBytes(), this.marshaller.marshallProcessInstance(instance));
        }
        catch (RocksDBException ex) {
            throw new IllegalStateException(ex);
        }
    }

    public void remove(String id) {
        try {
            this.db.delete(id.getBytes());
        }
        catch (RocksDBException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private ProcessInstance<T> unmarshall(byte[] data) {
        return this.marshaller.unmarshallProcessInstance(data, this.process);
    }

    private class RockSplitIterator
    extends Spliterators.AbstractSpliterator<ProcessInstance<T>>
    implements Closeable {
        private final RocksIterator iterator;

        protected RockSplitIterator(RocksIterator iterator) {
            super(Integer.MAX_VALUE, 0);
            this.iterator = iterator;
            iterator.seekToFirst();
        }

        @Override
        public boolean tryAdvance(Consumer<? super ProcessInstance<T>> action) {
            boolean hasNext = this.iterator.isValid();
            if (hasNext) {
                action.accept(RocksDBProcessInstances.this.unmarshall(this.iterator.value()));
                this.iterator.next();
                hasNext = this.iterator.isValid();
            }
            return hasNext;
        }

        @Override
        public void close() {
            this.iterator.close();
        }
    }
}

