/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.process.management;

import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jbpm.workflow.core.Node;
import org.kie.kogito.Application;
import org.kie.kogito.auth.SecurityPolicy;
import org.kie.kogito.internal.process.runtime.KogitoWorkflowProcess;
import org.kie.kogito.process.Process;
import org.kie.kogito.process.ProcessError;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstanceExecutionException;
import org.kie.kogito.process.Processes;
import org.kie.kogito.process.impl.AbstractProcess;
import org.kie.kogito.process.management.ProcessInstanceManagement;
import org.kie.kogito.process.workitem.Policy;
import org.kie.kogito.services.uow.UnitOfWorkExecutor;
import org.kie.kogito.uow.UnitOfWorkManager;

public abstract class BaseProcessInstanceManagementResource<T>
implements ProcessInstanceManagement<T> {
    private static final String PROCESS_REQUIRED = "Process id must be given";
    private static final String PROCESS_AND_INSTANCE_REQUIRED = "Process id and Process instance id must be given";
    private static final String PROCESS_NOT_FOUND = "Process with id %s not found";
    private static final String PROCESS_INSTANCE_NOT_FOUND = "Process instance with id %s not found";
    private static final String PROCESS_INSTANCE_NOT_IN_ERROR = "Process instance with id %s is not in error state";
    private Processes processes;
    private Application application;

    public BaseProcessInstanceManagementResource(Processes processes, Application application) {
        this.processes = processes;
        this.application = application;
    }

    public T doGetProcessNodes(String processId) {
        return (T)this.executeOnProcess(processId, process -> {
            List nodes = ((KogitoWorkflowProcess)((AbstractProcess)process).process()).getNodesRecursively();
            List list = nodes.stream().map(n -> {
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("id", n.getId());
                data.put("uniqueId", ((Node)n).getUniqueId());
                data.put("nodeDefinitionId", n.getMetaData().get("UniqueId"));
                data.put("type", n.getClass().getSimpleName());
                data.put("name", n.getName());
                return data;
            }).collect(Collectors.toList());
            return this.buildOkResponse(list);
        });
    }

    public T doGetInstanceInError(String processId, String processInstanceId) {
        return (T)this.executeOnInstanceInError(processId, processInstanceId, processInstance -> {
            ProcessError error = (ProcessError)processInstance.error().get();
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("id", processInstance.id());
            data.put("failedNodeId", error.failedNodeId());
            data.put("message", error.errorMessage());
            return this.buildOkResponse(data);
        });
    }

    public T doGetWorkItemsInProcessInstance(String processId, String processInstanceId) {
        return (T)this.executeOnProcessInstance(processId, processInstanceId, processInstance -> {
            List workItems = processInstance.workItems(new Policy[]{new SecurityPolicy(null){}});
            return this.buildOkResponse(workItems);
        });
    }

    public T doRetriggerInstanceInError(String processId, String processInstanceId) {
        return (T)this.executeOnInstanceInError(processId, processInstanceId, processInstance -> {
            ((ProcessError)processInstance.error().get()).retrigger();
            if (processInstance.status() == 5) {
                throw new ProcessInstanceExecutionException(processInstance.id(), ((ProcessError)processInstance.error().get()).failedNodeId(), ((ProcessError)processInstance.error().get()).errorMessage());
            }
            return this.buildOkResponse(processInstance.variables());
        });
    }

    public T doSkipInstanceInError(String processId, String processInstanceId) {
        return (T)this.executeOnInstanceInError(processId, processInstanceId, processInstance -> {
            ((ProcessError)processInstance.error().get()).skip();
            if (processInstance.status() == 5) {
                throw new ProcessInstanceExecutionException(processInstance.id(), ((ProcessError)processInstance.error().get()).failedNodeId(), ((ProcessError)processInstance.error().get()).errorMessage());
            }
            return this.buildOkResponse(processInstance.variables());
        });
    }

    public T doTriggerNodeInstanceId(String processId, String processInstanceId, String nodeId) {
        return (T)this.executeOnProcessInstance(processId, processInstanceId, processInstance -> {
            processInstance.triggerNode(nodeId);
            if (processInstance.status() == 5) {
                throw new ProcessInstanceExecutionException(processInstance.id(), ((ProcessError)processInstance.error().get()).failedNodeId(), ((ProcessError)processInstance.error().get()).errorMessage());
            }
            return this.buildOkResponse(processInstance.variables());
        });
    }

    public T doRetriggerNodeInstanceId(String processId, String processInstanceId, String nodeInstanceId) {
        return (T)this.executeOnProcessInstance(processId, processInstanceId, processInstance -> {
            processInstance.retriggerNodeInstance(nodeInstanceId);
            if (processInstance.status() == 5) {
                throw new ProcessInstanceExecutionException(processInstance.id(), ((ProcessError)processInstance.error().get()).failedNodeId(), ((ProcessError)processInstance.error().get()).errorMessage());
            }
            return this.buildOkResponse(processInstance.variables());
        });
    }

    public T doCancelNodeInstanceId(String processId, String processInstanceId, String nodeInstanceId) {
        return (T)this.executeOnProcessInstance(processId, processInstanceId, processInstance -> {
            processInstance.cancelNodeInstance(nodeInstanceId);
            if (processInstance.status() == 5) {
                throw new ProcessInstanceExecutionException(processInstance.id(), ((ProcessError)processInstance.error().get()).failedNodeId(), ((ProcessError)processInstance.error().get()).errorMessage());
            }
            return this.buildOkResponse(processInstance.variables());
        });
    }

    public T doCancelProcessInstanceId(String processId, String processInstanceId) {
        return (T)this.executeOnProcessInstance(processId, processInstanceId, processInstance -> {
            processInstance.abort();
            if (processInstance.status() == 5) {
                throw new ProcessInstanceExecutionException(processInstance.id(), ((ProcessError)processInstance.error().get()).failedNodeId(), ((ProcessError)processInstance.error().get()).errorMessage());
            }
            return this.buildOkResponse(processInstance.variables());
        });
    }

    private T executeOnInstanceInError(String processId, String processInstanceId, Function<ProcessInstance<?>, T> supplier) {
        if (processId == null || processInstanceId == null) {
            return this.badRequestResponse(PROCESS_AND_INSTANCE_REQUIRED);
        }
        Process process = this.processes.processById(processId);
        if (process == null) {
            return this.notFoundResponse(String.format(PROCESS_NOT_FOUND, processId));
        }
        return (T)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
            Optional processInstanceFound = process.instances().findById(processInstanceId);
            if (processInstanceFound.isPresent()) {
                ProcessInstance processInstance = (ProcessInstance)processInstanceFound.get();
                if (processInstance.error().isPresent()) {
                    return supplier.apply(processInstance);
                }
                return this.badRequestResponse(String.format(PROCESS_INSTANCE_NOT_IN_ERROR, processInstanceId));
            }
            return this.notFoundResponse(String.format(PROCESS_INSTANCE_NOT_FOUND, processInstanceId));
        });
    }

    private T executeOnProcessInstance(String processId, String processInstanceId, Function<ProcessInstance<?>, T> supplier) {
        if (processId == null || processInstanceId == null) {
            return this.badRequestResponse(PROCESS_AND_INSTANCE_REQUIRED);
        }
        Process process = this.processes.processById(processId);
        if (process == null) {
            return this.notFoundResponse(String.format(PROCESS_NOT_FOUND, processId));
        }
        return (T)UnitOfWorkExecutor.executeInUnitOfWork((UnitOfWorkManager)this.application.unitOfWorkManager(), () -> {
            Optional processInstanceFound = process.instances().findById(processInstanceId);
            if (processInstanceFound.isPresent()) {
                ProcessInstance processInstance = (ProcessInstance)processInstanceFound.get();
                return supplier.apply(processInstance);
            }
            return this.notFoundResponse(String.format(PROCESS_INSTANCE_NOT_FOUND, processInstanceId));
        });
    }

    private T executeOnProcess(String processId, Function<Process<?>, T> supplier) {
        if (processId == null) {
            return this.badRequestResponse(PROCESS_REQUIRED);
        }
        Process process = this.processes.processById(processId);
        if (process == null) {
            return this.notFoundResponse(String.format(PROCESS_NOT_FOUND, processId));
        }
        return supplier.apply(process);
    }

    protected abstract <R> T buildOkResponse(R var1);

    protected abstract T badRequestResponse(String var1);

    protected abstract T notFoundResponse(String var1);
}

