/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.process.management;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.jbpm.workflow.core.Node;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kie.kogito.Application;
import org.kie.kogito.auth.SecurityPolicy;
import org.kie.kogito.internal.process.runtime.KogitoWorkflowProcess;
import org.kie.kogito.process.ProcessError;
import org.kie.kogito.process.ProcessInstance;
import org.kie.kogito.process.ProcessInstances;
import org.kie.kogito.process.Processes;
import org.kie.kogito.process.WorkItem;
import org.kie.kogito.process.impl.AbstractProcess;
import org.kie.kogito.process.management.BaseProcessInstanceManagementResource;
import org.kie.kogito.process.workitem.Policy;
import org.kie.kogito.services.uow.CollectingUnitOfWorkFactory;
import org.kie.kogito.services.uow.DefaultUnitOfWorkManager;
import org.kie.kogito.uow.UnitOfWorkFactory;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
class BaseProcessInstanceManagementResourceTest {
    public static final String PROCESS_ID = "processId";
    public static final String PROCESS_INSTANCE_ID = "processInstanceId";
    public static final String NODE_ID_ERROR = "processInstanceIdError";
    public static final String NODE_ID = "nodeId";
    public static final String NODE_INSTANCE_ID = "nodeInstanceId";
    public static final String NODE_UNIQUE_ID = "nodeUniqueId";
    private BaseProcessInstanceManagementResource tested;
    @Mock
    private Processes processes;
    @Mock
    private Application application;
    @Mock
    private ProcessInstance processInstance;
    @Mock
    private ProcessError error;
    @Mock
    private ProcessInstances instances;
    @Mock
    private AbstractProcess process;
    @Mock
    private KogitoWorkflowProcess wp;
    @Mock
    private Node node;
    @Mock
    private Object variables;

    BaseProcessInstanceManagementResourceTest() {
    }

    @BeforeEach
    void setUp() {
        Mockito.lenient().when((Object)this.node.getId()).thenReturn((Object)1L);
        Mockito.lenient().when((Object)this.node.getName()).thenReturn((Object)"node");
        Mockito.lenient().when((Object)this.node.getUniqueId()).thenReturn((Object)NODE_ID);
        Mockito.lenient().when((Object)this.node.getMetaData()).thenReturn(Collections.singletonMap("UniqueId", NODE_UNIQUE_ID));
        Mockito.lenient().when((Object)this.wp.getNodesRecursively()).thenReturn(Collections.singletonList(this.node));
        Mockito.lenient().when((Object)this.process.process()).thenReturn((Object)this.wp);
        Mockito.lenient().when((Object)this.processes.processById(ArgumentMatchers.anyString())).thenReturn((Object)this.process);
        Mockito.lenient().when((Object)this.process.instances()).thenReturn((Object)this.instances);
        Mockito.lenient().when((Object)this.instances.findById(ArgumentMatchers.anyString())).thenReturn(Optional.of(this.processInstance));
        Mockito.lenient().when((Object)this.processInstance.error()).thenReturn(Optional.of(this.error));
        Mockito.lenient().when(this.processInstance.variables()).thenReturn(this.variables);
        Mockito.lenient().when((Object)this.processInstance.id()).thenReturn((Object)PROCESS_INSTANCE_ID);
        Mockito.lenient().when((Object)this.processInstance.status()).thenReturn((Object)5);
        Mockito.lenient().when((Object)this.error.failedNodeId()).thenReturn((Object)NODE_ID_ERROR);
        Mockito.lenient().when((Object)this.error.errorMessage()).thenReturn((Object)"Test error message");
        Mockito.lenient().when((Object)this.application.unitOfWorkManager()).thenReturn((Object)new DefaultUnitOfWorkManager((UnitOfWorkFactory)new CollectingUnitOfWorkFactory()));
        this.tested = (BaseProcessInstanceManagementResource)Mockito.spy((Object)new BaseProcessInstanceManagementResource(this.processes, this.application){

            protected Object buildOkResponse(Object body) {
                return body;
            }

            protected Object badRequestResponse(String message) {
                return message;
            }

            protected Object notFoundResponse(String message) {
                return message;
            }

            public Object getProcessNodes(String processId) {
                return null;
            }

            public Object getInstanceInError(String processId, String processInstanceId) {
                return null;
            }

            public Object getWorkItemsInProcessInstance(String processId, String processInstanceId) {
                return null;
            }

            public Object retriggerInstanceInError(String processId, String processInstanceId) {
                return null;
            }

            public Object skipInstanceInError(String processId, String processInstanceId) {
                return null;
            }

            public Object triggerNodeInstanceId(String processId, String processInstanceId, String nodeId) {
                return null;
            }

            public Object retriggerNodeInstanceId(String processId, String processInstanceId, String nodeInstanceId) {
                return null;
            }

            public Object cancelNodeInstanceId(String processId, String processInstanceId, String nodeInstanceId) {
                return null;
            }

            public Object cancelProcessInstanceId(String processId, String processInstanceId) {
                return null;
            }
        });
    }

    @Test
    void testDoGetProcessNodes() {
        Object response = this.tested.doGetProcessNodes(PROCESS_ID);
        ((Processes)Mockito.verify((Object)this.processes)).processById(PROCESS_ID);
        ((AbstractProcess)Mockito.verify((Object)this.process)).process();
        ((KogitoWorkflowProcess)Mockito.verify((Object)this.wp)).getNodesRecursively();
        ((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((ObjectAssert)((AbstractListAssert)((ObjectAssert)Assertions.assertThat((Object)response).isInstanceOf(List.class)).asList().hasSize(1)).element(0)).hasFieldOrPropertyWithValue("id", (Object)this.node.getId())).hasFieldOrPropertyWithValue("name", (Object)this.node.getName())).hasFieldOrPropertyWithValue("uniqueId", (Object)this.node.getUniqueId())).hasFieldOrPropertyWithValue("nodeDefinitionId", (Object)NODE_UNIQUE_ID)).hasFieldOrPropertyWithValue("type", (Object)this.node.getClass().getSimpleName());
    }

    @Test
    void testDoGetInstanceInError() {
        Object response = this.tested.doGetInstanceInError(PROCESS_ID, PROCESS_INSTANCE_ID);
        ((ProcessInstance)Mockito.verify((Object)this.processInstance, (VerificationMode)Mockito.times((int)2))).error();
        ((ProcessError)Mockito.verify((Object)this.error, (VerificationMode)Mockito.times((int)0))).retrigger();
        ((ProcessError)Mockito.verify((Object)this.error, (VerificationMode)Mockito.times((int)0))).skip();
        ((BaseProcessInstanceManagementResource)Mockito.verify((Object)this.tested)).buildOkResponse(ArgumentMatchers.any());
        Assertions.assertThat((Object)response).isInstanceOf(Map.class);
        Map responseMap = (Map)response;
        Assertions.assertThat(responseMap.get("id")).isEqualTo((Object)PROCESS_INSTANCE_ID);
        Assertions.assertThat(responseMap.get("failedNodeId")).isEqualTo((Object)NODE_ID_ERROR);
    }

    @Test
    void testDoGetWorkItemsInProcessInstance(@Mock WorkItem workItem) {
        Mockito.when((Object)this.processInstance.workItems(new Policy[]{(Policy)ArgumentMatchers.any(SecurityPolicy.class)})).thenReturn(Collections.singletonList(workItem));
        Object response = this.tested.doGetWorkItemsInProcessInstance(PROCESS_ID, PROCESS_INSTANCE_ID);
        Assertions.assertThat((Object)response).isInstanceOf(List.class);
        Assertions.assertThat(((List)response).get(0)).isEqualTo((Object)workItem);
    }

    @Test
    void testDoRetriggerInstanceInError() {
        this.mockProcessInstanceStatusActiveOnError().retrigger();
        Object response = this.tested.doRetriggerInstanceInError(PROCESS_ID, PROCESS_INSTANCE_ID);
        ((ProcessInstance)Mockito.verify((Object)this.processInstance, (VerificationMode)Mockito.times((int)2))).error();
        ((ProcessError)Mockito.verify((Object)this.error, (VerificationMode)Mockito.times((int)1))).retrigger();
        ((ProcessError)Mockito.verify((Object)this.error, (VerificationMode)Mockito.times((int)0))).skip();
        this.assertResultOk(response);
    }

    @Test
    void testDoSkipInstanceInError() {
        this.mockProcessInstanceStatusActiveOnError().skip();
        Object response = this.tested.doSkipInstanceInError(PROCESS_ID, PROCESS_INSTANCE_ID);
        ((ProcessInstance)Mockito.verify((Object)this.processInstance, (VerificationMode)Mockito.times((int)2))).error();
        ((ProcessError)Mockito.verify((Object)this.error, (VerificationMode)Mockito.times((int)0))).retrigger();
        ((ProcessError)Mockito.verify((Object)this.error, (VerificationMode)Mockito.times((int)1))).skip();
        this.assertResultOk(response);
    }

    @Test
    void testDoTriggerNodeInstanceId() {
        this.mockProcessInstanceStatusActive().triggerNode(NODE_ID);
        Object response = this.tested.doTriggerNodeInstanceId(PROCESS_ID, PROCESS_INSTANCE_ID, NODE_ID);
        ((ProcessInstance)Mockito.verify((Object)this.processInstance, (VerificationMode)Mockito.times((int)0))).error();
        ((ProcessInstance)Mockito.verify((Object)this.processInstance, (VerificationMode)Mockito.times((int)1))).triggerNode(NODE_ID);
        this.assertResultOk(response);
    }

    @Test
    void testDoRetriggerNodeInstanceId() {
        this.mockProcessInstanceStatusActive().retriggerNodeInstance(NODE_INSTANCE_ID);
        Object response = this.tested.doRetriggerNodeInstanceId(PROCESS_ID, PROCESS_INSTANCE_ID, NODE_INSTANCE_ID);
        ((ProcessInstance)Mockito.verify((Object)this.processInstance, (VerificationMode)Mockito.times((int)0))).error();
        ((ProcessInstance)Mockito.verify((Object)this.processInstance, (VerificationMode)Mockito.times((int)1))).retriggerNodeInstance(NODE_INSTANCE_ID);
        this.assertResultOk(response);
    }

    @Test
    void testDoCancelNodeInstanceId() {
        this.mockProcessInstanceStatusActive().cancelNodeInstance(ArgumentMatchers.anyString());
        Object response = this.tested.doCancelNodeInstanceId(PROCESS_ID, PROCESS_INSTANCE_ID, NODE_INSTANCE_ID);
        ((ProcessInstance)Mockito.verify((Object)this.processInstance, (VerificationMode)Mockito.times((int)0))).error();
        ((ProcessInstance)Mockito.verify((Object)this.processInstance, (VerificationMode)Mockito.times((int)1))).cancelNodeInstance(NODE_INSTANCE_ID);
        this.assertResultOk(response);
    }

    private void assertResultOk(Object response) {
        ((BaseProcessInstanceManagementResource)Mockito.verify((Object)this.tested)).buildOkResponse(ArgumentMatchers.any());
        Assertions.assertThat((Object)response).isEqualTo(this.variables);
    }

    private ProcessInstance mockProcessInstanceStatusActive() {
        return (ProcessInstance)Mockito.doAnswer(v -> {
            Mockito.when((Object)this.processInstance.status()).thenReturn((Object)1);
            return null;
        }).when((Object)this.processInstance);
    }

    private ProcessError mockProcessInstanceStatusActiveOnError() {
        return (ProcessError)Mockito.doAnswer(v -> {
            Mockito.when((Object)this.processInstance.status()).thenReturn((Object)1);
            return null;
        }).when((Object)this.error);
    }

    @Test
    void testDoCancelProcessInstanceId() {
        this.mockProcessInstanceStatusActive().abort();
        Object response = this.tested.doCancelProcessInstanceId(PROCESS_ID, PROCESS_INSTANCE_ID);
        ((ProcessInstance)Mockito.verify((Object)this.processInstance, (VerificationMode)Mockito.times((int)0))).error();
        ((ProcessInstance)Mockito.verify((Object)this.processInstance, (VerificationMode)Mockito.times((int)1))).abort();
        this.assertResultOk(response);
    }
}

