/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.svg;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.kie.kogito.svg.ProcessSVGException;
import org.kie.kogito.svg.ProcessSvgService;
import org.kie.kogito.svg.SVGImageProcessor;
import org.kie.kogito.svg.dataindex.DataIndexClient;
import org.kie.kogito.svg.dataindex.NodeInstance;
import org.kie.kogito.svg.processor.SVGProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProcessSvgService
implements ProcessSvgService {
    public static final String DEFAULT_COMPLETED_COLOR = "#C0C0C0";
    public static final String DEFAULT_COMPLETED_BORDER_COLOR = "#030303";
    public static final String DEFAULT_ACTIVE_BORDER_COLOR = "#FF0000";
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractProcessSvgService.class);
    private static final String SVG_RELATIVE_PATH = "META-INF/processSVG/";
    protected DataIndexClient dataIndexClient;
    protected Optional<String> svgResourcesPath;
    protected String completedColor;
    protected String completedBorderColor;
    protected String activeBorderColor;

    public AbstractProcessSvgService() {
    }

    public AbstractProcessSvgService(DataIndexClient dataIndexClient, Optional<String> svgResourcesPath, String completedColor, String completedBorderColor, String activeBorderColor) {
        this.dataIndexClient = dataIndexClient;
        this.svgResourcesPath = svgResourcesPath;
        this.completedColor = completedColor;
        this.completedBorderColor = completedBorderColor;
        this.activeBorderColor = activeBorderColor;
    }

    public void setSvgResourcesPath(Optional<String> svgResourcesPath) {
        this.svgResourcesPath = svgResourcesPath;
    }

    @Override
    public Optional<String> getProcessSvg(String processId) {
        if (this.svgResourcesPath.isPresent()) {
            Path path = Paths.get(this.svgResourcesPath.get(), processId + ".svg");
            if (Files.exists(path, new LinkOption[0])) {
                try {
                    return Optional.of(new String(Files.readAllBytes(path.toRealPath(new LinkOption[0]))));
                }
                catch (IOException e) {
                    throw new ProcessSVGException("Exception trying to read SVG file", e);
                }
            }
            LOGGER.debug("Could not find {}.svg file in folder {}", (Object)processId, (Object)this.svgResourcesPath.get());
            return Optional.empty();
        }
        return this.readFileContentFromClassPath(processId + ".svg");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Optional<String> readFileContentFromClassPath(String fileName) {
        try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(SVG_RELATIVE_PATH + fileName);){
            if (is == null) {
                Optional<String> optional2 = Optional.empty();
                return optional2;
            }
            Optional<String> optional = Optional.of(IOUtils.toString((InputStream)is, (String)StandardCharsets.UTF_8.name()));
            return optional;
        }
        catch (Exception ex) {
            throw new ProcessSVGException("Exception trying to read file from classpath", ex);
        }
    }

    protected Optional<String> annotateExecutedPath(String svg, List<String> completedNodes, List<String> activeNodes) {
        Optional<String> optional;
        if (svg == null || svg.isEmpty()) {
            return Optional.empty();
        }
        if (completedNodes.isEmpty() && activeNodes.isEmpty()) {
            return Optional.of(svg);
        }
        ByteArrayInputStream svgStream = new ByteArrayInputStream(svg.getBytes());
        try {
            SVGProcessor processor = new SVGImageProcessor(svgStream).getProcessor();
            completedNodes.forEach(nodeId -> processor.defaultCompletedTransformation((String)nodeId, this.completedColor, this.completedBorderColor));
            activeNodes.forEach(nodeId -> processor.defaultActiveTransformation((String)nodeId, this.activeBorderColor));
            optional = Optional.of(processor.getSVG());
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)svgStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new ProcessSVGException("Failed to annotated SVG for process instance", e);
            }
        }
        ((InputStream)svgStream).close();
        return optional;
    }

    @Override
    public Optional<String> getProcessInstanceSvg(String processId, String processInstanceId, String authHeader) {
        Optional<String> processSvg = this.getProcessSvg(processId);
        if (processSvg.isPresent()) {
            List<NodeInstance> nodes = this.dataIndexClient.getNodeInstancesFromProcessInstance(processInstanceId, authHeader);
            List<String> completedNodes = nodes.stream().filter(NodeInstance::isCompleted).map(NodeInstance::getDefinitionId).collect(Collectors.toList());
            List<String> activeNodes = nodes.stream().filter(n -> n.isCompleted() == false).map(NodeInstance::getDefinitionId).collect(Collectors.toList());
            return this.annotateExecutedPath(processSvg.get(), completedNodes, activeNodes);
        }
        return Optional.empty();
    }
}

