/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.svg;

import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.junit.jupiter.api.Test;
import org.kie.kogito.svg.AbstractProcessSvgService;
import org.kie.kogito.svg.ProcessSVGException;
import org.kie.kogito.test.utils.CustomSVGDiffer;
import org.xmlunit.builder.Input;
import org.xmlunit.diff.Diff;

public abstract class ProcessSvgServiceTest {
    private static final String PROCESS_ID = "travels";

    public static String readFileContent(String file) throws URISyntaxException, IOException {
        Path path = Paths.get(Thread.currentThread().getContextClassLoader().getResource(file).toURI());
        return new String(Files.readAllBytes(path));
    }

    @Test
    public void getProcessSvgWithoutSvgResourcePathTest() throws Exception {
        String fileContent = this.getTravelsSVGFile();
        Optional svgContent = this.getTestedProcessSvgService().getProcessSvg(PROCESS_ID);
        ((OptionalAssert)Assertions.assertThat((Optional)svgContent).isPresent()).hasValue((Object)fileContent);
    }

    @Test
    public void getProcessSvgFromFileSystemSuccessTest() throws Exception {
        String fileContent = this.getTravelsSVGFile();
        this.getTestedProcessSvgService().setSvgResourcesPath(Optional.of("./src/test/resources/META-INF/processSVG/"));
        Optional svgContent = this.getTestedProcessSvgService().getProcessSvg(PROCESS_ID);
        ((OptionalAssert)Assertions.assertThat((Optional)svgContent).isPresent()).hasValue((Object)fileContent);
    }

    @Test
    public void getProcessSvgFromFileSystemFailTest() throws Exception {
        this.getTestedProcessSvgService().setSvgResourcesPath(Optional.of("./src/test/resources/META-INF/processSVG/"));
        Assertions.assertThat((Optional)this.getTestedProcessSvgService().getProcessSvg("UnexistingProcessId")).isEmpty();
    }

    @Test
    public void annotateExecutedPathTest() throws Exception {
        String content = (String)this.getTestedProcessSvgService().annotateExecutedPath(this.getTravelsSVGFile(), Arrays.asList("_1A708F87-11C0-42A0-A464-0B7E259C426F"), Collections.emptyList()).get();
        Diff myDiff = new CustomSVGDiffer(content).withTest((Object)Input.fromString((String)ProcessSvgServiceTest.readFileContent("travels-expected.svg")));
        Assertions.assertThat((boolean)myDiff.hasDifferences()).isFalse();
        Assertions.assertThat((Optional)this.getTestedProcessSvgService().annotateExecutedPath(null, Arrays.asList("_1A708F87-11C0-42A0-A464-0B7E259C426F"), Collections.emptyList())).isEmpty();
        Assertions.assertThat((Optional)this.getTestedProcessSvgService().annotateExecutedPath(this.getTravelsSVGFile(), Collections.emptyList(), Collections.emptyList())).hasValue((Object)this.getTravelsSVGFile());
    }

    @Test
    public void readFileFromClassPathTest() throws Exception {
        Assertions.assertThat((Optional)this.getTestedProcessSvgService().readFileContentFromClassPath("undefined")).isEmpty();
        Assertions.assertThat((String)this.getTravelsSVGFile()).isEqualTo((String)this.getTestedProcessSvgService().readFileContentFromClassPath("travels.svg").get());
    }

    @Test
    public void testWrongSVGContentThrowsException() {
        AbstractProcessSvgService testedProcessSvgService = this.getTestedProcessSvgService();
        List<String> completedNodes = Arrays.asList("_1A708F87-11C0-42A0-A464-0B7E259C426F");
        List activeNodes = Collections.emptyList();
        try {
            testedProcessSvgService.annotateExecutedPath("wrongSVGContent", completedNodes, activeNodes);
            Assertions.fail((String)"Expected an ProcessSVGException to be thrown");
        }
        catch (ProcessSVGException e) {
            Assertions.assertThat((String)e.getMessage()).isEqualTo("Failed to annotated SVG for process instance");
        }
    }

    public String getTravelsSVGFile() throws Exception {
        return ProcessSvgServiceTest.readFileContent("META-INF/processSVG/travels.svg");
    }

    protected abstract AbstractProcessSvgService getTestedProcessSvgService();
}

