/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.svg;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.svg.SVGImageProcessor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class SvgTransformationTest {
    private XPath xpath = XPathFactory.newInstance().newXPath();

    public static InputStream readTestFileContent() {
        return SvgTransformationTest.class.getResourceAsStream("/META-INF/processSVG/travels.svg");
    }

    @Test
    public void transformTest() throws Exception {
        ArrayList<String> completed = new ArrayList<String>();
        completed.add("_1A708F87-11C0-42A0-A464-0B7E259C426F");
        ArrayList<String> active = new ArrayList<String>();
        active.add("_24FBB8D6-EF2D-4DCC-846D-D8C5E21849D2");
        String svg = SVGImageProcessor.transform((InputStream)SvgTransformationTest.readTestFileContent(), completed, active);
        Document svgDocument = this.readSVG(svg);
        this.validateNodesMarkedAsActive(svgDocument, active, "#FF0000");
        this.validateNodesMarkedAsCompleted(svgDocument, completed, "#C0C0C0");
    }

    @Test
    public void testCompletedAndActive() throws Exception {
        ArrayList<String> completed = new ArrayList<String>();
        completed.add("_1A708F87-11C0-42A0-A464-0B7E259C426F");
        completed.add("_24FBB8D6-EF2D-4DCC-846D-D8C5E21849D2");
        ArrayList<String> active = new ArrayList<String>();
        active.add("_24FBB8D6-EF2D-4DCC-846D-D8C5E21849D2");
        String svg = SVGImageProcessor.transform((InputStream)SvgTransformationTest.readTestFileContent(), completed, active);
        Document svgDocument = this.readSVG(svg);
        this.validateNodesMarkedAsActive(svgDocument, active, "#FF0000");
        completed.remove("_24FBB8D6-EF2D-4DCC-846D-D8C5E21849D2");
        this.validateNodesMarkedAsCompleted(svgDocument, completed, "#C0C0C0");
    }

    @Test
    public void testCustomColor() throws Exception {
        String completedNodeColor = "#888888";
        String completedNodeBorderColor = "#888887";
        String activeNodeBorderColor = "#888886";
        ArrayList<String> completed = new ArrayList<String>();
        completed.add("_1A708F87-11C0-42A0-A464-0B7E259C426F");
        ArrayList<String> active = new ArrayList<String>();
        active.add("_24FBB8D6-EF2D-4DCC-846D-D8C5E21849D2");
        String svg = SVGImageProcessor.transform((InputStream)SvgTransformationTest.readTestFileContent(), completed, active, null, (String)completedNodeColor, (String)completedNodeBorderColor, (String)activeNodeBorderColor);
        Document svgDocument = this.readSVG(svg);
        this.validateNodesMarkedAsActive(svgDocument, active, activeNodeBorderColor);
        this.validateNodesMarkedAsCompleted(svgDocument, completed, completedNodeColor);
    }

    @Test
    public void testViewBoxAttributeAddition() throws Exception {
        ArrayList<String> completed = new ArrayList<String>();
        completed.add("_1A708F87-11C0-42A0-A464-0B7E259C426F");
        ArrayList<String> active = new ArrayList<String>();
        active.add("_24FBB8D6-EF2D-4DCC-846D-D8C5E21849D2");
        HashMap<String, String> links = new HashMap<String, String>();
        links.put("_1A708F87-11C0-42A0-A464-0B7E259C426F", "http://localhost/svg/processes/1");
        String svg = SVGImageProcessor.transform((InputStream)SvgTransformationTest.readTestFileContent(), completed, active, links, (String)"#888888", (String)"#888887", (String)"#888886");
        Document svgDocument = this.readSVG(svg);
        Assertions.assertThat((String)((Element)svgDocument.getFirstChild()).getAttribute("width")).isEmpty();
        Assertions.assertThat((String)((Element)svgDocument.getFirstChild()).getAttribute("height")).isEmpty();
        Assertions.assertThat((String)svgDocument.getFirstChild().getAttributes().getNamedItem("viewBox").getNodeValue()).isEqualTo("0 0 1748 632");
    }

    private void validateNodesMarkedAsActive(Document svgDocument, List<String> activeNodes, String activeNodeBorderColor) throws XPathExpressionException {
        for (String activeNode : activeNodes) {
            XPathExpression expr = this.xpath.compile("//*[@bpmn2nodeid='" + activeNode + "']");
            Element element = (Element)expr.evaluate(svgDocument, XPathConstants.NODE);
            if (element == null) {
                Assertions.fail((String)"", (Object[])new Object[]{"Active element " + activeNode + " not found in the document"});
            }
            String svgId = element.getAttribute("id") + "?shapeType=BORDER&renderType=STROKE";
            XPathExpression expr2 = this.xpath.compile("//*[@id='" + svgId + "']");
            Element border = (Element)expr2.evaluate(svgDocument, XPathConstants.NODE);
            String marker = border.getAttribute("stroke");
            ((AbstractStringAssert)Assertions.assertThat((String)marker).isNotNull()).isEqualTo(activeNodeBorderColor);
            String markerWidth = border.getAttribute("stroke-width");
            ((AbstractStringAssert)Assertions.assertThat((String)markerWidth).isNotNull()).isEqualTo("2");
        }
    }

    private void validateNodesMarkedAsCompleted(Document svgDocument, List<String> completedNodes, String completedNodeColor) throws XPathExpressionException {
        for (String completedNode : completedNodes) {
            XPathExpression expr = this.xpath.compile("//*[@bpmn2nodeid='" + completedNode + "']");
            Element element = (Element)expr.evaluate(svgDocument, XPathConstants.NODE);
            if (element == null) {
                Assertions.fail((String)"", (Object[])new Object[]{"Completed element " + completedNode + " not found in the document"});
            }
            String svgId = element.getAttribute("id") + "?shapeType=BACKGROUND";
            XPathExpression expr2 = this.xpath.compile("//*[@id='" + svgId + "']");
            Element background = (Element)expr2.evaluate(svgDocument, XPathConstants.NODE);
            String marker = background.getAttribute("fill");
            ((AbstractStringAssert)Assertions.assertThat((String)marker).isNotNull()).isEqualTo(completedNodeColor);
        }
    }

    private Document readSVG(String svgContent) throws IOException, ParserConfigurationException, SAXException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document svgDocument = builder.parse(new ByteArrayInputStream(svgContent.getBytes()));
        return svgDocument;
    }
}

