/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addons.quarkus.camel.deployment;

import com.fasterxml.jackson.databind.JsonNode;
import io.serverlessworkflow.api.functions.FunctionRef;

public final class CamelFunctionStaticValidator {
    private CamelFunctionStaticValidator() {
    }

    public static void validateFunctionRef(FunctionRef ref) {
        if (ref.getArguments() == null) {
            return;
        }
        switch (ref.getArguments().size()) {
            case 0: {
                return;
            }
            case 1: {
                CamelFunctionStaticValidator.verifyBodyArguments(ref);
                break;
            }
            case 2: {
                CamelFunctionStaticValidator.verifyBodyArguments(ref);
                CamelFunctionStaticValidator.verifyHeaderArguments(ref);
                break;
            }
            default: {
                throw new IllegalArgumentException("Camel functions only support 'body', 'header', or no arguments. Please review the function '" + ref.getRefName() + "' arguments: \n" + ref.getArguments().asText());
            }
        }
    }

    private static void verifyHeaderArguments(FunctionRef ref) {
        JsonNode headers = ref.getArguments().get("headers");
        if (headers == null) {
            throw new IllegalArgumentException("Camel functions only support 'body', 'header', or no arguments. Please review the arguments for the function '" + ref.getRefName() + "': \n" + ref.getArguments().asText());
        }
        if (!headers.isObject() && !headers.isTextual()) {
            throw new IllegalArgumentException("Camel functions headers arguments must be a valid expression or a key/value object. Please review the arguments for the function '" + ref.getRefName() + "': \n" + headers.asText());
        }
    }

    private static void verifyBodyArguments(FunctionRef ref) {
        if (ref.getArguments().get("body") == null) {
            throw new IllegalArgumentException("No body arguments found in the function reference. Please review the function '" + ref.getRefName() + "' arguments to include a '\"body\": {}' argument.");
        }
    }
}

