/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addons.quarkus.camel.deployment;

import io.serverlessworkflow.api.Workflow;
import io.serverlessworkflow.api.actions.Action;
import io.serverlessworkflow.api.functions.FunctionRef;
import io.serverlessworkflow.api.states.CallbackState;
import io.serverlessworkflow.api.states.ForEachState;
import io.serverlessworkflow.api.states.OperationState;
import java.net.URISyntaxException;
import java.nio.file.Paths;
import java.util.Objects;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.CsvSource;
import org.kie.kogito.addons.quarkus.camel.deployment.CamelFunctionStaticValidator;
import org.kie.kogito.quarkus.serverless.workflow.WorkflowCodeGenUtils;

public class CamelFunctionStaticValidatorTest {
    @ParameterizedTest
    @CsvSource(value={"valid-camel-soap.sw.json,callSoap", "valid-newsletter-subscription.sw.json,subscribeToNewsletter", "valid-camel-soap-no-args.sw.json,callSoap", "valid-camel-soap-expression-args.sw.json,callSoap", "valid-camel-soap-headers.sw.json,callSoap"})
    public void verifyValidWorkflowsWithCamelFunctions(String workflowFile, String functionDefName) throws URISyntaxException {
        WorkflowCodeGenUtils.getWorkflows(Stream.of(Paths.get(Objects.requireNonNull(CamelFunctionStaticValidatorTest.class.getResource("/" + workflowFile)).toURI()))).forEach(w -> this.verifyWorkflow((Workflow)w, functionDefName));
    }

    @ParameterizedTest
    @CsvSource(value={"invalid-camel-soap.sw.json,callSoap", "invalid-camel-soap-headers-array.sw.json,callSoap", "invalid-camel-soap-headers-primitive.sw.json,callSoap"})
    public void verifyInvalidWorkflowsWithCamelFunctions(String workflowFile, String functionDefName) throws URISyntaxException {
        WorkflowCodeGenUtils.getWorkflows(Stream.of(Paths.get(Objects.requireNonNull(CamelFunctionStaticValidatorTest.class.getResource("/" + workflowFile)).toURI()))).forEach(w -> Assertions.assertThrows(IllegalArgumentException.class, () -> this.verifyWorkflow((Workflow)w, functionDefName)));
    }

    private void verifyWorkflow(Workflow workflow, String functionDefName) {
        workflow.getStates().forEach(s -> {
            switch (s.getType()) {
                case OPERATION: {
                    ((OperationState)s).getActions().forEach(a -> this.verifyAction((Action)a, functionDefName));
                    break;
                }
                case FOREACH: {
                    ((ForEachState)s).getActions().forEach(a -> this.verifyAction((Action)a, functionDefName));
                    break;
                }
                case CALLBACK: {
                    this.verifyAction(((CallbackState)s).getAction(), functionDefName);
                    break;
                }
            }
        });
    }

    private void verifyAction(Action action, String functionDefName) {
        if (functionDefName.equals(action.getFunctionRef().getRefName())) {
            CamelFunctionStaticValidator.validateFunctionRef((FunctionRef)action.getFunctionRef());
        }
    }
}

