/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.integrationtests;

import io.quarkus.test.junit.QuarkusTest;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import io.restassured.response.ValidatableResponse;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.assertj.core.api.Assertions;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Test;

@QuarkusTest
class QuarkusCloudEventResourceTest {
    @ConfigProperty(name="quarkus.http.test-port")
    public int port;

    QuarkusCloudEventResourceTest() {
    }

    @Test
    void verifyHttpRequestUnsupportedMediaType() {
        ((ValidatableResponse)((Response)RestAssured.given().when().header("ce-type", (Object)"myevent", new Object[0]).header("ce-source", (Object)"/from/unit/test", new Object[0]).header("ce-specversion", (Object)"1.0", new Object[0]).header("ce-id", (Object)UUID.randomUUID().toString(), new Object[0]).header("ce-kogitoprocrefid", (Object)"12345", new Object[0]).header("Content-Type", (Object)"text/plain", new Object[0]).post("/", new Object[0])).then()).statusCode(Response.Status.BAD_REQUEST.getStatusCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void verifyHttpRequestNoMediaType() throws IOException {
        URL url = new URL("http://localhost:" + this.port);
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        try {
            con.setRequestProperty("ce-type", "myevent");
            con.setRequestProperty("ce-source", "/from/unit/test");
            con.setRequestProperty("ce-specversion", "1.0");
            con.setRequestProperty("ce-id", UUID.randomUUID().toString());
            con.setRequestProperty("ce-kogitoprocrefid", "12345");
            con.setRequestMethod("POST");
            con.setDoOutput(true);
            try (DataOutputStream out = new DataOutputStream(con.getOutputStream());){
                out.writeBytes("{ \"message\": \"Hola Mundo!\" }");
                out.flush();
            }
            Assertions.assertThat((int)con.getResponseCode()).isEqualTo(200);
        }
        finally {
            con.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void verifyHttpRequestNoMediaTypeCrazyContent() throws IOException {
        URL url = new URL("http://localhost:" + this.port);
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        try {
            con.setRequestProperty("ce-type", "myevent");
            con.setRequestProperty("ce-source", "/from/unit/test");
            con.setRequestProperty("ce-specversion", "1.0");
            con.setRequestProperty("ce-id", UUID.randomUUID().toString());
            con.setRequestProperty("ce-kogitoprocrefid", "12345");
            con.setRequestMethod("POST");
            con.setDoOutput(true);
            try (DataOutputStream out = new DataOutputStream(con.getOutputStream());){
                out.writeBytes("I'm just trying to hack this nonsense");
                out.flush();
            }
            Assertions.assertThat((int)con.getResponseCode()).isEqualTo(400);
        }
        finally {
            con.disconnect();
        }
    }

    @Test
    void verifyHttpRequestWithJSONPayloadExpectsString() {
        String source = "/from/unit/test";
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().body("{ \"message\": \"Hola Mundo!\" }").header("ce-type", (Object)"myevent", new Object[0]).header("ce-source", (Object)"/from/unit/test", new Object[0]).header("ce-specversion", (Object)"1.0", new Object[0]).header("ce-id", (Object)UUID.randomUUID().toString(), new Object[0]).header("ce-kogitoprocrefid", (Object)"12345", new Object[0]).header("Content-Type", (Object)"application/json", new Object[0]).post("/", new Object[0])).then()).statusCode(Response.Status.OK.getStatusCode())).body("data.message", Matchers.equalTo((Object)"Hola Mundo!"), new Object[0])).body("kogitoprocrefid", Matchers.equalTo((Object)"12345"), new Object[0]);
    }

    @Test
    void verifyHttpRequestWithJSONPayloadExpectsPOJO() {
        String source = "/from/unit/test";
        Message msg = (Message)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().body("{ \"message\": \"Hola Mundo!\" }").header("ce-type", (Object)"myevent", new Object[0]).header("ce-source", (Object)"/from/unit/test", new Object[0]).header("ce-specversion", (Object)"1.0", new Object[0]).header("ce-id", (Object)UUID.randomUUID().toString(), new Object[0]).header("ce-kogitoprocrefid", (Object)"12345", new Object[0]).header("Content-Type", (Object)"application/json", new Object[0]).post("/", new Object[0])).then()).statusCode(Response.Status.OK.getStatusCode())).body("data.message", Matchers.equalTo((Object)"Hola Mundo!"), new Object[0])).body("source", Matchers.equalTo((Object)"/from/unit/test"), new Object[0])).extract().body().jsonPath().getObject("data", Message.class);
        Assertions.assertThat((String)msg.getMessage()).isEqualTo("Hola Mundo!");
    }

    @Test
    void verifyHttpRequestWithCEPayloadExpectsPOJO() {
        String source = "/from/unit/test";
        ((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().body("{\"kogitoprocrefid\":\"12345!\", \"data\":{\"message\":\"Hi World!\"},\"id\":\"x10\",\"source\":\"/from/unit/test\",\"specversion\":\"1.0\",\"type\":\"myevent\",\"datacontenttype\":\"application/json\"}").contentType(MediaType.valueOf((String)"application/cloudevents+json").withCharset(StandardCharsets.UTF_8.name()).toString()).post("/", new Object[0])).then()).statusCode(Response.Status.OK.getStatusCode())).body("source", Matchers.equalTo((Object)"/from/unit/test"), new Object[0])).body("kogitoprocrefid", Matchers.equalTo((Object)"12345!"), new Object[0]);
    }

    @Test
    void verifyHttpRequestWithCEPayloadExpectsString() {
        String source = "/from/unit/test";
        Message msg = (Message)((ValidatableResponse)((ValidatableResponse)((ValidatableResponse)((Response)RestAssured.given().when().body("{\"data\":{\"message\":\"Hi World!\"},\"id\":\"x10\",\"source\":\"/from/unit/test\",\"specversion\":\"1.0\",\"type\":\"myevent\",\"datacontenttype\":\"application/json\"}").contentType("application/cloudevents+json").post("", new Object[0])).then()).statusCode(Response.Status.OK.getStatusCode())).body(Matchers.isA(String.class), new Matcher[0])).extract().body().jsonPath().getObject("data", Message.class);
        Assertions.assertThat((Object)msg).isNotNull();
        Assertions.assertThat((String)msg.getMessage()).isEqualTo("Hi World!");
    }

    static {
        RestAssured.enableLoggingOfRequestAndResponseIfValidationFails();
    }

    public static class Message {
        private String message;

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }
}

