/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addon.cloudevents.quarkus;

import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.eclipse.microprofile.reactive.messaging.Channel;
import org.eclipse.microprofile.reactive.messaging.Emitter;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.kie.kogito.addon.cloudevents.quarkus.decorators.MessageDecorator;
import org.kie.kogito.addon.cloudevents.quarkus.decorators.MessageDecoratorFactory;
import org.kie.kogito.conf.ConfigBean;
import org.kie.kogito.event.EventEmitter;
import org.kie.kogito.event.EventMarshaller;
import org.kie.kogito.services.event.impl.DefaultEventMarshaller;

@ApplicationScoped
public class QuarkusCloudEventEmitter
implements EventEmitter {
    private MessageDecorator messageDecorator;
    @Inject
    @Channel(value="kogito_outgoing_stream")
    Emitter<String> emitter;
    @Inject
    ConfigBean configBean;
    @Inject
    Instance<EventMarshaller> marshallerInstance;
    EventMarshaller marshaller;

    @PostConstruct
    private void init() {
        this.marshaller = this.marshallerInstance.isResolvable() ? (EventMarshaller)this.marshallerInstance.get() : new DefaultEventMarshaller();
        this.messageDecorator = MessageDecoratorFactory.newInstance((boolean)this.configBean.useCloudEvents());
    }

    public <T> CompletionStage<Void> emit(T e, String type, Optional<Function<T, Object>> processDecorator) {
        Message message = this.messageDecorator.decorate((Object)this.marshaller.marshall(this.configBean.useCloudEvents() ? processDecorator.map(d -> d.apply(e)).orElse(e) : e));
        this.emitter.send(message);
        return (CompletionStage)message.getAck().get();
    }
}

