/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.quarkus.addons.common.deployment;

import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.annotations.BuildStep;
import org.kie.kogito.quarkus.addons.common.deployment.KogitoCapability;

public abstract class AnyEngineKogitoAddOnProcessor {
    @BuildStep
    void verifyCapabilities(Capabilities capabilities) {
        if (KogitoCapability.ENGINES.stream().noneMatch(kc -> capabilities.isPresent(kc.getCapability()))) {
            throw this.exceptionForEngineNotPresent();
        }
    }

    private IllegalStateException exceptionForEngineNotPresent() {
        StringBuilder sb = new StringBuilder();
        sb.append("This Kogito Quarkus Add-on requires at least one of the following Kogito Extensions: \n");
        KogitoCapability.ENGINES.forEach(c -> {
            sb.append("\t - ").append(c.getCapability()).append("\n");
            sb.append("\t\t offered by the artifact ").append("org.kie.kogito").append(":").append(c.getOfferedBy()).append("\n");
        });
        sb.append("Add one of the above artifacts in your project's pom.xml file");
        return new IllegalStateException(sb.toString());
    }
}

