/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.events.mongodb;

import com.mongodb.client.MongoClient;
import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.junit.mockito.InjectSpy;
import javax.inject.Inject;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.events.mongodb.QuarkusMongoDBEventPublisher;
import org.kie.kogito.mongodb.transaction.MongoDBTransactionManager;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@QuarkusTest
class QuarkusMongoDBEventPublisherTest {
    @Inject
    QuarkusMongoDBEventPublisher publisher;
    @InjectSpy
    MongoClient mongoClient;
    @Inject
    MongoDBTransactionManager transactionManager;

    QuarkusMongoDBEventPublisherTest() {
    }

    @Test
    void setup() {
        this.publisher.setupQuarkusMongoDBEventPublisher();
        ((MongoClient)Mockito.verify((Object)this.mongoClient, (VerificationMode)Mockito.atLeastOnce())).getDatabase((String)ArgumentMatchers.eq((Object)"testDB"));
    }

    @Test
    void mongoClient() {
        Assertions.assertEquals((Object)this.mongoClient.getDatabase("testDB"), (Object)this.publisher.mongoClient().getDatabase("testDB"));
    }

    @Test
    void transactionManager() {
        Assertions.assertEquals((Object)this.transactionManager, (Object)this.publisher.transactionManager());
    }

    @Test
    void processInstancesEvents() {
        Assertions.assertFalse((boolean)this.publisher.processInstancesEvents());
    }

    @Test
    void userTasksEvents() {
        Assertions.assertFalse((boolean)this.publisher.userTasksEvents());
    }

    @Test
    void variablesEvents() {
        Assertions.assertFalse((boolean)this.publisher.variablesEvents());
    }

    @Test
    void eventsDatabaseName() {
        Assertions.assertEquals((Object)"testDB", (Object)this.publisher.eventsDatabaseName());
    }

    @Test
    void processInstancesEventsCollection() {
        Assertions.assertEquals((Object)"testPICollection", (Object)this.publisher.processInstancesEventsCollection());
    }

    @Test
    void userTasksEventsCollection() {
        Assertions.assertEquals((Object)"testUTCollection", (Object)this.publisher.userTasksEventsCollection());
    }

    @Test
    void variablesEventsCollection() {
        Assertions.assertEquals((Object)"testVCollection", (Object)this.publisher.variablesEventsCollection());
    }
}

