/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.events.mongodb;

import com.mongodb.client.MongoClient;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.kie.kogito.events.mongodb.MongoDBEventPublisher;
import org.kie.kogito.mongodb.transaction.AbstractTransactionManager;

@Singleton
public class QuarkusMongoDBEventPublisher
extends MongoDBEventPublisher {
    @Inject
    MongoClient quarkusMongoClient;
    @Inject
    AbstractTransactionManager quarkusTransactionManager;
    @Inject
    @ConfigProperty(name="kogito.events.processinstances.enabled", defaultValue="true")
    boolean quarkusEnableProcessInstancesEvents;
    @Inject
    @ConfigProperty(name="kogito.events.usertasks.enabled", defaultValue="true")
    boolean quarkusEnableUserTasksEvents;
    @Inject
    @ConfigProperty(name="kogito.events.variables.enabled", defaultValue="true")
    boolean quarkusEnableVariablesEvents;
    @Inject
    @ConfigProperty(name="kogito.events.database", defaultValue="kogito-events")
    String quarkusEventsDatabaseName;
    @Inject
    @ConfigProperty(name="kogito.events.processinstances.collection", defaultValue="kogitoprocessinstancesevents")
    String quarkusProcessInstancesEventsCollectionName;
    @Inject
    @ConfigProperty(name="kogito.events.usertasks.collection", defaultValue="kogitousertaskinstancesevents")
    String quarkusUserTasksEventsCollectionName;
    @Inject
    @ConfigProperty(name="kogito.events.variables.collection", defaultValue="kogitovariablesevents")
    String quarkusVariablesEventsCollectionName;

    @PostConstruct
    public void setupQuarkusMongoDBEventPublisher() {
        super.configure();
    }

    protected MongoClient mongoClient() {
        return this.quarkusMongoClient;
    }

    protected AbstractTransactionManager transactionManager() {
        return this.quarkusTransactionManager;
    }

    protected boolean processInstancesEvents() {
        return this.quarkusEnableProcessInstancesEvents;
    }

    protected boolean userTasksEvents() {
        return this.quarkusEnableUserTasksEvents;
    }

    protected boolean variablesEvents() {
        return this.quarkusEnableVariablesEvents;
    }

    protected String eventsDatabaseName() {
        return this.quarkusEventsDatabaseName;
    }

    protected String processInstancesEventsCollection() {
        return this.quarkusProcessInstancesEventsCollectionName;
    }

    protected String userTasksEventsCollection() {
        return this.quarkusUserTasksEventsCollectionName;
    }

    protected String variablesEventsCollection() {
        return this.quarkusVariablesEventsCollectionName;
    }
}

