/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.jobs.management.quarkus;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.ext.web.client.HttpRequest;
import io.vertx.ext.web.client.WebClient;
import java.time.ZonedDateTime;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.enterprise.inject.Instance;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.ExtendWith;
import org.kie.kogito.jobs.ExactExpirationTime;
import org.kie.kogito.jobs.ExpirationTime;
import org.kie.kogito.jobs.JobId;
import org.kie.kogito.jobs.ProcessInstanceJobDescription;
import org.kie.kogito.jobs.ProcessJobDescription;
import org.kie.kogito.jobs.TimerJobId;
import org.kie.kogito.jobs.api.Job;
import org.kie.kogito.jobs.management.quarkus.VertxJobsService;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@TestInstance(value=TestInstance.Lifecycle.PER_CLASS)
@ExtendWith(value={MockitoExtension.class})
class VertxJobsServiceTest {
    public static final String CALLBACK_URL = "http://localhost";
    public static final String JOB_SERVICE_URL = "http://localhost:8085";
    private VertxJobsService tested;
    private ExecutorService executor = Executors.newSingleThreadExecutor();
    @Mock
    private Vertx vertx;
    @Mock
    private WebClient webClient;
    @Mock
    private Instance instance;

    VertxJobsServiceTest() {
    }

    @BeforeEach
    public void setUp() {
        Mockito.when((Object)this.instance.isResolvable()).thenReturn((Object)true);
        Mockito.when((Object)this.instance.get()).thenReturn((Object)this.webClient);
        this.tested = new VertxJobsService(JOB_SERVICE_URL, CALLBACK_URL, this.vertx, this.instance);
        this.tested.initialize();
    }

    @AfterAll
    public void cleanup() {
        this.executor.shutdownNow();
    }

    @Test
    void testInitialize() {
        Mockito.reset((Object[])new Instance[]{this.instance});
        Mockito.when((Object)this.instance.isResolvable()).thenReturn((Object)false);
        this.tested = new VertxJobsService(JOB_SERVICE_URL, CALLBACK_URL, this.vertx, this.instance);
        this.tested.initialize();
        ((Instance)Mockito.verify((Object)this.instance, (VerificationMode)Mockito.never())).get();
    }

    @Test
    void testScheduleProcessJob() {
        ProcessJobDescription processJobDescription = ProcessJobDescription.of((ExpirationTime)ExactExpirationTime.now(), (Integer)1, (String)"processId");
        Assertions.assertThatThrownBy(() -> this.tested.scheduleProcessJob(processJobDescription)).isInstanceOf(UnsupportedOperationException.class);
    }

    @Test
    void testScheduleProcessInstanceJob(@Mock HttpRequest<Buffer> request) {
        Mockito.when((Object)this.webClient.post(ArgumentMatchers.anyString())).thenReturn(request);
        ProcessInstanceJobDescription processInstanceJobDescription = ProcessInstanceJobDescription.of((JobId)new TimerJobId(Long.valueOf(123L)), (ExpirationTime)ExactExpirationTime.now(), (String)"processInstanceId", (String)"processId");
        this.tested.scheduleProcessInstanceJob(processInstanceJobDescription);
        ((WebClient)Mockito.verify((Object)this.webClient)).post("/jobs");
        ArgumentCaptor jobArgumentCaptor = ArgumentCaptor.forClass(Job.class);
        ((HttpRequest)Mockito.verify(request)).sendJson(jobArgumentCaptor.capture(), (Handler)ArgumentMatchers.any(Handler.class));
        Job job = (Job)jobArgumentCaptor.getValue();
        Assertions.assertThat((String)job.getId()).isEqualTo(processInstanceJobDescription.id());
        Assertions.assertThat((ZonedDateTime)job.getExpirationTime()).isEqualTo((Object)processInstanceJobDescription.expirationTime().get());
        Assertions.assertThat((String)job.getProcessInstanceId()).isEqualTo(processInstanceJobDescription.processInstanceId());
        Assertions.assertThat((String)job.getProcessId()).isEqualTo(processInstanceJobDescription.processId());
    }

    @Test
    void testCancelJob(@Mock HttpRequest<Buffer> request) {
        Mockito.when((Object)this.webClient.delete(ArgumentMatchers.anyString())).thenReturn(request);
        this.tested.cancelJob("123");
        ((WebClient)Mockito.verify((Object)this.webClient)).delete("/jobs/123");
    }
}

