/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addons.quarkus.knative.eventing.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsTest;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.kubernetes.spi.KubernetesDeploymentTargetBuildItem;
import io.quarkus.kubernetes.spi.KubernetesResourceMetadataBuildItem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.kie.kogito.addons.quarkus.knative.eventing.deployment.KogitoKnativeResourcesMetadataBuildItem;
import org.kie.kogito.addons.quarkus.knative.eventing.deployment.KogitoServiceDeploymentTarget;
import org.kie.kogito.codegen.process.events.ProcessCloudEventMetaBuilder;
import org.kie.kogito.quarkus.extensions.spi.deployment.KogitoProcessContainerGeneratorBuildItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KogitoProcessKnativeEventingProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(KogitoProcessKnativeEventingProcessor.class);

    @BuildStep(onlyIfNot={IsTest.class})
    void buildMetadata(KogitoProcessContainerGeneratorBuildItem processContainerBuildItem, List<KubernetesDeploymentTargetBuildItem> allDeploymentTargets, List<KubernetesResourceMetadataBuildItem> kubernetesMetaBuildItems, BuildProducer<KogitoKnativeResourcesMetadataBuildItem> metadataProducer) {
        Set cloudEvents = this.getCloudEventMetaBuilder().build(processContainerBuildItem.getProcessContainerGenerators());
        if (cloudEvents != null && !cloudEvents.isEmpty()) {
            Optional<KogitoServiceDeploymentTarget> target = this.selectDeploymentTarget(allDeploymentTargets, kubernetesMetaBuildItems);
            if (target.isEmpty()) {
                LOGGER.warn("Impossible to get the Kubernetes deployment target for this Kogito service. Skipping generation.");
            } else {
                metadataProducer.produce((BuildItem)new KogitoKnativeResourcesMetadataBuildItem(cloudEvents, target.get()));
            }
        }
    }

    Optional<KogitoServiceDeploymentTarget> selectDeploymentTarget(List<KubernetesDeploymentTargetBuildItem> allDeploymentTargets, List<KubernetesResourceMetadataBuildItem> kubernetesMetaBuildItems) {
        if (kubernetesMetaBuildItems == null || kubernetesMetaBuildItems.isEmpty()) {
            return Optional.empty();
        }
        List mergedDeploymentTargets = new ArrayList();
        if (allDeploymentTargets != null) {
            mergedDeploymentTargets = KubernetesDeploymentTargetBuildItem.mergeList(allDeploymentTargets);
            Collections.sort(mergedDeploymentTargets);
        }
        Optional targetBuildItem = mergedDeploymentTargets.stream().filter(KubernetesDeploymentTargetBuildItem::isEnabled).collect(Collectors.toList()).stream().findFirst();
        return kubernetesMetaBuildItems.stream().filter(r -> targetBuildItem.isEmpty() || ((KubernetesDeploymentTargetBuildItem)targetBuildItem.get()).getName().equals(r.getTarget()) && ((KubernetesDeploymentTargetBuildItem)targetBuildItem.get()).getKind().equals(r.getKind())).map(r -> new KogitoServiceDeploymentTarget(r.getGroup(), r.getVersion(), r.getKind(), r.getName())).findFirst();
    }

    ProcessCloudEventMetaBuilder getCloudEventMetaBuilder() {
        return new ProcessCloudEventMetaBuilder();
    }
}

