/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addons.quarkus.knative.eventing.deployment;

import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.kubernetes.spi.KubernetesDeploymentTargetBuildItem;
import io.quarkus.kubernetes.spi.KubernetesResourceMetadataBuildItem;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jbpm.compiler.canonical.TriggerMetaData;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.kie.api.definition.process.Node;
import org.kie.kogito.addons.quarkus.knative.eventing.deployment.KogitoKnativeResourcesMetadataBuildItem;
import org.kie.kogito.addons.quarkus.knative.eventing.deployment.KogitoProcessKnativeEventingProcessor;
import org.kie.kogito.codegen.process.events.ProcessCloudEventMeta;
import org.kie.kogito.codegen.process.events.ProcessCloudEventMetaBuilder;
import org.kie.kogito.quarkus.extensions.spi.deployment.KogitoProcessContainerGeneratorBuildItem;
import org.mockito.Mockito;

public class KogitoProcessKnativeEventingProcessorTest {
    private static TriggerMetaData triggerMetadata;

    @BeforeAll
    static void setupClass() {
        Node node = (Node)Mockito.mock(Node.class);
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("TriggerRef", "myType");
        metadata.put("MappingVariable", "myVar");
        metadata.put("TriggerType", "ProduceMessage");
        metadata.put("MessageType", "myDataType");
        Mockito.when((Object)node.getMetaData()).thenReturn(metadata);
        triggerMetadata = TriggerMetaData.of((Node)node);
    }

    @Test
    void checkNotBuiltMetadataIfNoCEs() {
        KogitoProcessContainerGeneratorBuildItem containerGeneratorBuildItem = new KogitoProcessContainerGeneratorBuildItem(Collections.emptySet());
        KogitoProcessKnativeEventingProcessor processor = new KogitoProcessKnativeEventingProcessor();
        MockKogitoKnativeMetadataProducer metadata = new MockKogitoKnativeMetadataProducer();
        processor.buildMetadata(containerGeneratorBuildItem, null, null, (BuildProducer)metadata);
        Assertions.assertNull((Object)metadata.getItem());
    }

    @Test
    void checkBuiltMetadataWithCEsNullSelectedItem() {
        KogitoProcessContainerGeneratorBuildItem containerGeneratorBuildItem = new KogitoProcessContainerGeneratorBuildItem(Collections.emptySet());
        ProcessCloudEventMetaBuilder mockedCEBuilder = (ProcessCloudEventMetaBuilder)Mockito.mock(ProcessCloudEventMetaBuilder.class);
        KogitoProcessKnativeEventingProcessor processor = (KogitoProcessKnativeEventingProcessor)Mockito.mock(KogitoProcessKnativeEventingProcessor.class);
        MockKogitoKnativeMetadataProducer metadata = new MockKogitoKnativeMetadataProducer();
        KubernetesResourceMetadataBuildItem kubernetesResourceMetadataBuildItem = new KubernetesResourceMetadataBuildItem("kubernetes", "apps", "v1", "Deployment", "name");
        List<KubernetesResourceMetadataBuildItem> kubernetesMetaBuildItems = Collections.singletonList(kubernetesResourceMetadataBuildItem);
        ((KogitoProcessKnativeEventingProcessor)Mockito.doCallRealMethod().when((Object)processor)).buildMetadata(containerGeneratorBuildItem, null, kubernetesMetaBuildItems, (BuildProducer)metadata);
        Mockito.when((Object)processor.selectDeploymentTarget(null, kubernetesMetaBuildItems)).thenCallRealMethod();
        Mockito.when((Object)processor.getCloudEventMetaBuilder()).thenReturn((Object)mockedCEBuilder);
        Mockito.when((Object)mockedCEBuilder.build(containerGeneratorBuildItem.getProcessContainerGenerators())).thenReturn(Collections.singleton(new ProcessCloudEventMeta("123", triggerMetadata)));
        processor.buildMetadata(containerGeneratorBuildItem, null, kubernetesMetaBuildItems, (BuildProducer)metadata);
        Assertions.assertNotNull((Object)metadata.getItem());
    }

    @Test
    void checkBuiltMetadataWithCEsNotNullSelectedItem() {
        KogitoProcessContainerGeneratorBuildItem containerGeneratorBuildItem = new KogitoProcessContainerGeneratorBuildItem(Collections.emptySet());
        ProcessCloudEventMetaBuilder mockedCEBuilder = (ProcessCloudEventMetaBuilder)Mockito.mock(ProcessCloudEventMetaBuilder.class);
        KogitoProcessKnativeEventingProcessor processor = (KogitoProcessKnativeEventingProcessor)Mockito.mock(KogitoProcessKnativeEventingProcessor.class);
        MockKogitoKnativeMetadataProducer metadata = new MockKogitoKnativeMetadataProducer();
        KubernetesResourceMetadataBuildItem kubernetesResourceMetadataBuildItem = new KubernetesResourceMetadataBuildItem("kubernetes", "apps", "v1", "Deployment", "name");
        List<KubernetesResourceMetadataBuildItem> kubernetesMetaBuildItems = Collections.singletonList(kubernetesResourceMetadataBuildItem);
        List<KubernetesDeploymentTargetBuildItem> deploymentTargets = Collections.singletonList(new KubernetesDeploymentTargetBuildItem("kubernetes", "Deployment", "apps", "v1"));
        ((KogitoProcessKnativeEventingProcessor)Mockito.doCallRealMethod().when((Object)processor)).buildMetadata(containerGeneratorBuildItem, deploymentTargets, kubernetesMetaBuildItems, (BuildProducer)metadata);
        Mockito.when((Object)processor.selectDeploymentTarget(deploymentTargets, kubernetesMetaBuildItems)).thenCallRealMethod();
        Mockito.when((Object)processor.getCloudEventMetaBuilder()).thenReturn((Object)mockedCEBuilder);
        Mockito.when((Object)mockedCEBuilder.build(containerGeneratorBuildItem.getProcessContainerGenerators())).thenReturn(Collections.singleton(new ProcessCloudEventMeta("123", triggerMetadata)));
        processor.buildMetadata(containerGeneratorBuildItem, deploymentTargets, kubernetesMetaBuildItems, (BuildProducer)metadata);
        Assertions.assertNotNull((Object)metadata.getItem());
    }

    private static final class MockKogitoKnativeMetadataProducer
    implements BuildProducer<KogitoKnativeResourcesMetadataBuildItem> {
        private KogitoKnativeResourcesMetadataBuildItem item;

        private MockKogitoKnativeMetadataProducer() {
        }

        public void produce(KogitoKnativeResourcesMetadataBuildItem item) {
            this.item = item;
        }

        public KogitoKnativeResourcesMetadataBuildItem getItem() {
            return this.item;
        }
    }
}

