/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addons.quarkus.knative.eventing.deployment;

import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.builditem.GeneratedFileSystemResourceBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.Optional;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.kie.kogito.addons.quarkus.knative.eventing.deployment.EventingConfiguration;
import org.kie.kogito.addons.quarkus.knative.eventing.deployment.KogitoAddOnKnativeEventingProcessor;
import org.kie.kogito.addons.quarkus.knative.eventing.deployment.KogitoKnativeResourcesMetadataBuildItem;
import org.kie.kogito.addons.quarkus.knative.eventing.deployment.KogitoServiceDeploymentTarget;
import org.kie.kogito.addons.quarkus.knative.eventing.deployment.SinkConfiguration;
import org.kie.kogito.event.EventKind;
import org.kie.kogito.event.cloudevents.CloudEventMeta;

class KogitoAddOnKnativeEventingProcessorTest {
    KogitoAddOnKnativeEventingProcessorTest() {
    }

    @Test
    void checkKogitoFileIsGeneratedWithDefaultConfig() {
        OutputTargetBuildItem outputTargetBuildItem = new OutputTargetBuildItem(Paths.get("/", new String[0]), "", false, null, Optional.empty());
        HashSet<CloudEventMeta> ces = new HashSet<CloudEventMeta>();
        ces.add(new CloudEventMeta("myProducedEvent", "/local/test", EventKind.PRODUCED));
        ces.add(new CloudEventMeta("myConsumedEvent", "/local/test", EventKind.CONSUMED));
        KogitoServiceDeploymentTarget deploymentTarget = new KogitoServiceDeploymentTarget("apps", "v1", "Deployment", "kogito-service");
        KogitoKnativeResourcesMetadataBuildItem resourcesMetadataBuildItem = new KogitoKnativeResourcesMetadataBuildItem(ces, deploymentTarget);
        KogitoAddOnKnativeEventingProcessor eventingProcessor = this.buildTestProcessorWithDefaultConfig();
        MockGeneratedFSProducer producer = new MockGeneratedFSProducer();
        eventingProcessor.generate(outputTargetBuildItem, Optional.of(resourcesMetadataBuildItem), (BuildProducer)producer);
        Assertions.assertNotNull((Object)producer.getItem().getData());
        Assertions.assertTrue((producer.getItem().getData().length > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)new String(producer.getItem().getData()).contains("SinkBinding"));
        Assertions.assertFalse((boolean)new String(producer.getItem().getData()).contains("KogitoSource"));
        Assertions.assertTrue((boolean)new String(producer.getItem().getData()).contains("Trigger"));
        Assertions.assertTrue((boolean)new String(producer.getItem().getData()).contains("Broker"));
    }

    @Test
    void checkKogitoFileIsGeneratedOnlyProduced() {
        OutputTargetBuildItem outputTargetBuildItem = new OutputTargetBuildItem(Paths.get("/", new String[0]), "", false, null, Optional.empty());
        HashSet<CloudEventMeta> ces = new HashSet<CloudEventMeta>();
        ces.add(new CloudEventMeta("myProducedEvent", "/local/test", EventKind.PRODUCED));
        KogitoServiceDeploymentTarget deploymentTarget = new KogitoServiceDeploymentTarget("apps", "v1", "Deployment", "kogito-service");
        KogitoKnativeResourcesMetadataBuildItem resourcesMetadataBuildItem = new KogitoKnativeResourcesMetadataBuildItem(ces, deploymentTarget);
        KogitoAddOnKnativeEventingProcessor eventingProcessor = this.buildTestProcessorWithDefaultConfig();
        MockGeneratedFSProducer producer = new MockGeneratedFSProducer();
        eventingProcessor.generate(outputTargetBuildItem, Optional.of(resourcesMetadataBuildItem), (BuildProducer)producer);
        Assertions.assertNotNull((Object)producer.getItem().getData());
        Assertions.assertTrue((producer.getItem().getData().length > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)new String(producer.getItem().getData()).contains("SinkBinding"));
        Assertions.assertFalse((boolean)new String(producer.getItem().getData()).contains("KogitoSource"));
        Assertions.assertFalse((boolean)new String(producer.getItem().getData()).contains("Trigger"));
        Assertions.assertTrue((boolean)new String(producer.getItem().getData()).contains("Broker"));
    }

    @Test
    void checkKogitoFileIsGeneratedWithKogitoSource() {
        OutputTargetBuildItem outputTargetBuildItem = new OutputTargetBuildItem(Paths.get("/", new String[0]), "", false, null, Optional.empty());
        HashSet<CloudEventMeta> ces = new HashSet<CloudEventMeta>();
        ces.add(new CloudEventMeta("myProducedEvent", "/local/test", EventKind.PRODUCED));
        KogitoServiceDeploymentTarget deploymentTarget = new KogitoServiceDeploymentTarget("apps", "v1", "Deployment", "kogito-service");
        KogitoKnativeResourcesMetadataBuildItem resourcesMetadataBuildItem = new KogitoKnativeResourcesMetadataBuildItem(ces, deploymentTarget);
        KogitoAddOnKnativeEventingProcessor eventingProcessor = this.buildTestProcessorWithDefaultConfig();
        eventingProcessor.config.generateKogitoSource = true;
        MockGeneratedFSProducer producer = new MockGeneratedFSProducer();
        eventingProcessor.generate(outputTargetBuildItem, Optional.of(resourcesMetadataBuildItem), (BuildProducer)producer);
        Assertions.assertNotNull((Object)producer.getItem().getData());
        Assertions.assertTrue((producer.getItem().getData().length > 0 ? 1 : 0) != 0);
        Assertions.assertFalse((boolean)new String(producer.getItem().getData()).contains("SinkBinding"));
        Assertions.assertTrue((boolean)new String(producer.getItem().getData()).contains("KogitoSource"));
        Assertions.assertFalse((boolean)new String(producer.getItem().getData()).contains("Trigger"));
        Assertions.assertTrue((boolean)new String(producer.getItem().getData()).contains("Broker"));
    }

    @Test
    void checkKogitoFileIsGeneratedOnlyConsumed() {
        OutputTargetBuildItem outputTargetBuildItem = new OutputTargetBuildItem(Paths.get("/", new String[0]), "", false, null, Optional.empty());
        HashSet<CloudEventMeta> ces = new HashSet<CloudEventMeta>();
        ces.add(new CloudEventMeta("myConsumedEvent", "/local/test", EventKind.CONSUMED));
        KogitoServiceDeploymentTarget deploymentTarget = new KogitoServiceDeploymentTarget("apps", "v1", "Deployment", "kogito-service");
        KogitoKnativeResourcesMetadataBuildItem resourcesMetadataBuildItem = new KogitoKnativeResourcesMetadataBuildItem(ces, deploymentTarget);
        KogitoAddOnKnativeEventingProcessor eventingProcessor = this.buildTestProcessorWithDefaultConfig();
        MockGeneratedFSProducer producer = new MockGeneratedFSProducer();
        eventingProcessor.generate(outputTargetBuildItem, Optional.of(resourcesMetadataBuildItem), (BuildProducer)producer);
        Assertions.assertNotNull((Object)producer.getItem().getData());
        Assertions.assertTrue((producer.getItem().getData().length > 0 ? 1 : 0) != 0);
        Assertions.assertFalse((boolean)new String(producer.getItem().getData()).contains("SinkBinding"));
        Assertions.assertFalse((boolean)new String(producer.getItem().getData()).contains("KogitoSource"));
        Assertions.assertTrue((boolean)new String(producer.getItem().getData()).contains("Trigger"));
        Assertions.assertTrue((boolean)new String(producer.getItem().getData()).contains("Broker"));
    }

    @Test
    void checkNotProducedIfNoCEs() {
        OutputTargetBuildItem outputTargetBuildItem = new OutputTargetBuildItem(Paths.get("/", new String[0]), "", false, null, Optional.empty());
        HashSet ces = new HashSet();
        KogitoServiceDeploymentTarget deploymentTarget = new KogitoServiceDeploymentTarget("apps", "v1", "Deployment", "kogito-service");
        KogitoKnativeResourcesMetadataBuildItem resourcesMetadataBuildItem = new KogitoKnativeResourcesMetadataBuildItem(ces, deploymentTarget);
        KogitoAddOnKnativeEventingProcessor eventingProcessor = this.buildTestProcessorWithDefaultConfig();
        MockGeneratedFSProducer producer = new MockGeneratedFSProducer();
        eventingProcessor.generate(outputTargetBuildItem, Optional.of(resourcesMetadataBuildItem), (BuildProducer)producer);
        Assertions.assertNull((Object)producer.getItem());
    }

    private KogitoAddOnKnativeEventingProcessor buildTestProcessorWithDefaultConfig() {
        KogitoAddOnKnativeEventingProcessor eventingProcessor = new KogitoAddOnKnativeEventingProcessor();
        SinkConfiguration sinkConfiguration = new SinkConfiguration();
        sinkConfiguration.apiVersion = "eventing.knative.dev/v1";
        sinkConfiguration.kind = "Broker";
        sinkConfiguration.name = "default";
        sinkConfiguration.namespace = Optional.empty();
        eventingProcessor.config = new EventingConfiguration();
        eventingProcessor.config.autoGenerateBroker = true;
        eventingProcessor.config.generateKogitoSource = false;
        eventingProcessor.config.broker = "default";
        eventingProcessor.config.sink = sinkConfiguration;
        return eventingProcessor;
    }

    private static final class MockGeneratedFSProducer
    implements BuildProducer<GeneratedFileSystemResourceBuildItem> {
        private GeneratedFileSystemResourceBuildItem item;

        private MockGeneratedFSProducer() {
        }

        public void produce(GeneratedFileSystemResourceBuildItem item) {
            this.item = item;
        }

        public GeneratedFileSystemResourceBuildItem getItem() {
            return this.item;
        }
    }
}

