/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addons.quarkus.knative.eventing.deployment;

import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.kubernetes.spi.KubernetesDeploymentTargetBuildItem;
import io.quarkus.kubernetes.spi.KubernetesResourceMetadataBuildItem;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.jbpm.compiler.canonical.TriggerMetaData;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.kie.api.definition.process.Node;
import org.kie.kogito.addons.quarkus.knative.eventing.deployment.KogitoCloudEventsBuildItem;
import org.kie.kogito.addons.quarkus.knative.eventing.deployment.KogitoKnativeResourcesMetadataBuildItem;
import org.kie.kogito.addons.quarkus.knative.eventing.deployment.KogitoProcessKnativeEventingProcessor;
import org.kie.kogito.codegen.process.events.ProcessCloudEventMeta;
import org.kie.kogito.codegen.process.events.ProcessCloudEventMetaBuilder;
import org.kie.kogito.event.EventKind;
import org.kie.kogito.event.cloudevents.CloudEventMeta;
import org.kie.kogito.quarkus.extensions.spi.deployment.KogitoProcessContainerGeneratorBuildItem;
import org.mockito.Mockito;

class KogitoProcessKnativeEventingProcessorTest {
    private static TriggerMetaData triggerMetadata;
    private static final CloudEventMeta EXTENDED_CLOUD_EVENT1;
    private static final CloudEventMeta EXTENDED_CLOUD_EVENT2;

    KogitoProcessKnativeEventingProcessorTest() {
    }

    @BeforeAll
    static void setupClass() {
        Node node = (Node)Mockito.mock(Node.class);
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("TriggerRef", "myType");
        metadata.put("MappingVariable", "myVar");
        metadata.put("TriggerType", "ProduceMessage");
        metadata.put("MessageType", "myDataType");
        Mockito.when((Object)node.getMetaData()).thenReturn(metadata);
        triggerMetadata = TriggerMetaData.of((Node)node);
    }

    @Test
    void checkNotBuiltMetadataIfNoCEs() {
        KogitoProcessContainerGeneratorBuildItem containerGeneratorBuildItem = new KogitoProcessContainerGeneratorBuildItem(Collections.emptySet());
        KogitoProcessKnativeEventingProcessor processor = new KogitoProcessKnativeEventingProcessor();
        MockKogitoKnativeMetadataProducer metadata = new MockKogitoKnativeMetadataProducer();
        processor.buildMetadata(containerGeneratorBuildItem, Collections.emptyList(), null, null, (BuildProducer)metadata);
        Assertions.assertNull((Object)metadata.getItem());
    }

    @Test
    void checkBuiltMetadataWithCEsNullSelectedItem() {
        KogitoProcessContainerGeneratorBuildItem containerGeneratorBuildItem = new KogitoProcessContainerGeneratorBuildItem(Collections.emptySet());
        ProcessCloudEventMetaBuilder mockedCEBuilder = (ProcessCloudEventMetaBuilder)Mockito.mock(ProcessCloudEventMetaBuilder.class);
        KogitoProcessKnativeEventingProcessor processor = (KogitoProcessKnativeEventingProcessor)Mockito.mock(KogitoProcessKnativeEventingProcessor.class);
        MockKogitoKnativeMetadataProducer metadata = new MockKogitoKnativeMetadataProducer();
        KubernetesResourceMetadataBuildItem kubernetesResourceMetadataBuildItem = new KubernetesResourceMetadataBuildItem("kubernetes", "apps", "v1", "Deployment", "name");
        List<KubernetesResourceMetadataBuildItem> kubernetesMetaBuildItems = Collections.singletonList(kubernetesResourceMetadataBuildItem);
        List<KogitoCloudEventsBuildItem> extendedCloudEventsBuildItems = Collections.singletonList(new KogitoCloudEventsBuildItem(Set.of(EXTENDED_CLOUD_EVENT1, EXTENDED_CLOUD_EVENT2)));
        ((KogitoProcessKnativeEventingProcessor)Mockito.doCallRealMethod().when((Object)processor)).buildMetadata(containerGeneratorBuildItem, extendedCloudEventsBuildItems, null, kubernetesMetaBuildItems, (BuildProducer)metadata);
        Mockito.when((Object)processor.selectDeploymentTarget(null, kubernetesMetaBuildItems)).thenCallRealMethod();
        Mockito.when((Object)processor.getCloudEventMetaBuilder()).thenReturn((Object)mockedCEBuilder);
        Mockito.when((Object)mockedCEBuilder.build(containerGeneratorBuildItem.getProcessContainerGenerators())).thenReturn(Collections.singleton(new ProcessCloudEventMeta("123", triggerMetadata)));
        processor.buildMetadata(containerGeneratorBuildItem, extendedCloudEventsBuildItems, null, kubernetesMetaBuildItems, (BuildProducer)metadata);
        Assertions.assertNotNull((Object)metadata.getItem());
        Set cloudEvents = metadata.getItem().getCloudEvents();
        Assertions.assertTrue((boolean)cloudEvents.contains(EXTENDED_CLOUD_EVENT1));
        Assertions.assertTrue((boolean)cloudEvents.contains(EXTENDED_CLOUD_EVENT2));
    }

    @Test
    void checkBuiltMetadataWithCEsNotNullSelectedItem() {
        KogitoProcessContainerGeneratorBuildItem containerGeneratorBuildItem = new KogitoProcessContainerGeneratorBuildItem(Collections.emptySet());
        ProcessCloudEventMetaBuilder mockedCEBuilder = (ProcessCloudEventMetaBuilder)Mockito.mock(ProcessCloudEventMetaBuilder.class);
        KogitoProcessKnativeEventingProcessor processor = (KogitoProcessKnativeEventingProcessor)Mockito.mock(KogitoProcessKnativeEventingProcessor.class);
        MockKogitoKnativeMetadataProducer metadata = new MockKogitoKnativeMetadataProducer();
        KubernetesResourceMetadataBuildItem kubernetesResourceMetadataBuildItem = new KubernetesResourceMetadataBuildItem("kubernetes", "apps", "v1", "Deployment", "name");
        List<KubernetesResourceMetadataBuildItem> kubernetesMetaBuildItems = Collections.singletonList(kubernetesResourceMetadataBuildItem);
        List<KubernetesDeploymentTargetBuildItem> deploymentTargets = Collections.singletonList(new KubernetesDeploymentTargetBuildItem("kubernetes", "Deployment", "apps", "v1"));
        List<KogitoCloudEventsBuildItem> extendedCloudEventsBuildItems = Collections.singletonList(new KogitoCloudEventsBuildItem(Set.of(EXTENDED_CLOUD_EVENT1, EXTENDED_CLOUD_EVENT2)));
        ((KogitoProcessKnativeEventingProcessor)Mockito.doCallRealMethod().when((Object)processor)).buildMetadata(containerGeneratorBuildItem, extendedCloudEventsBuildItems, deploymentTargets, kubernetesMetaBuildItems, (BuildProducer)metadata);
        Mockito.when((Object)processor.selectDeploymentTarget(deploymentTargets, kubernetesMetaBuildItems)).thenCallRealMethod();
        Mockito.when((Object)processor.getCloudEventMetaBuilder()).thenReturn((Object)mockedCEBuilder);
        Mockito.when((Object)mockedCEBuilder.build(containerGeneratorBuildItem.getProcessContainerGenerators())).thenReturn(Collections.singleton(new ProcessCloudEventMeta("123", triggerMetadata)));
        processor.buildMetadata(containerGeneratorBuildItem, extendedCloudEventsBuildItems, deploymentTargets, kubernetesMetaBuildItems, (BuildProducer)metadata);
        Assertions.assertNotNull((Object)metadata.getItem());
        Set cloudEvents = metadata.getItem().getCloudEvents();
        Assertions.assertTrue((boolean)cloudEvents.contains(EXTENDED_CLOUD_EVENT1));
        Assertions.assertTrue((boolean)cloudEvents.contains(EXTENDED_CLOUD_EVENT2));
    }

    static {
        EXTENDED_CLOUD_EVENT1 = new CloudEventMeta("extendedEvent1", "source1", EventKind.PRODUCED);
        EXTENDED_CLOUD_EVENT2 = new CloudEventMeta("extendedEvent2", "source2", EventKind.CONSUMED);
    }

    private static final class MockKogitoKnativeMetadataProducer
    implements BuildProducer<KogitoKnativeResourcesMetadataBuildItem> {
        private KogitoKnativeResourcesMetadataBuildItem item;

        private MockKogitoKnativeMetadataProducer() {
        }

        public void produce(KogitoKnativeResourcesMetadataBuildItem item) {
            this.item = item;
        }

        public KogitoKnativeResourcesMetadataBuildItem getItem() {
            return this.item;
        }
    }
}

