/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addons.quarkus.knative.eventing.deployment;

import io.fabric8.knative.eventing.v1.Broker;
import io.fabric8.knative.eventing.v1.BrokerBuilder;
import io.fabric8.knative.eventing.v1.BrokerFluent;
import io.fabric8.knative.eventing.v1.Trigger;
import io.fabric8.knative.eventing.v1.TriggerBuilder;
import io.fabric8.knative.eventing.v1.TriggerFluent;
import io.fabric8.knative.eventing.v1.TriggerSpecFluent;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationBuilder;
import io.fabric8.knative.internal.pkg.apis.duck.v1.DestinationFluent;
import io.fabric8.knative.internal.pkg.tracker.ReferenceBuilder;
import io.fabric8.knative.sources.v1.SinkBinding;
import io.fabric8.knative.sources.v1.SinkBindingBuilder;
import io.fabric8.knative.sources.v1.SinkBindingFluent;
import io.fabric8.knative.sources.v1.SinkBindingSpecFluent;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.IsTest;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedFileSystemResourceBuildItem;
import io.quarkus.deployment.builditem.SystemPropertyBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.smallrye.health.deployment.spi.HealthBuildItem;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.jboss.jandex.DotName;
import org.kie.kogito.addons.quarkus.knative.eventing.KSinkInjectionHealthCheck;
import org.kie.kogito.addons.quarkus.knative.eventing.deployment.EventingConfiguration;
import org.kie.kogito.addons.quarkus.knative.eventing.deployment.KnativeResourcesUtil;
import org.kie.kogito.addons.quarkus.knative.eventing.deployment.KogitoKnativeGenerator;
import org.kie.kogito.addons.quarkus.knative.eventing.deployment.KogitoKnativeResourcesMetadataBuildItem;
import org.kie.kogito.addons.quarkus.knative.eventing.deployment.resources.KogitoSource;
import org.kie.kogito.addons.quarkus.knative.eventing.deployment.resources.KogitoSourceSpec;
import org.kie.kogito.event.EventKind;
import org.kie.kogito.quarkus.addons.common.deployment.AnyEngineKogitoAddOnProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KogitoAddOnKnativeEventingProcessor
extends AnyEngineKogitoAddOnProcessor {
    private static final String FEATURE = "kogito-addon-knative-eventing-extension";
    private static final String FILE_NAME = "kogito.yml";
    private static final String TARGET_KUBERNETES = "kubernetes";
    private static final Logger LOGGER = LoggerFactory.getLogger(KogitoAddOnKnativeEventingProcessor.class);
    public static final DotName PROCESS_EVENTS_PUBLISHER_CLASS = DotName.createSimple((String)"org.kie.kogito.events.process.ReactiveMessagingEventPublisher");
    EventingConfiguration config;

    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(FEATURE);
    }

    @BuildStep(onlyIfNot={IsDevelopment.class})
    HealthBuildItem registerKSinkInjectionHealthCheck(Optional<KogitoKnativeResourcesMetadataBuildItem> resourcesMetadata) {
        boolean hasProducedEvents = resourcesMetadata.map(KogitoAddOnKnativeEventingProcessor::hasProducedEvents).orElse(false);
        return new HealthBuildItem(KSinkInjectionHealthCheck.class.getName(), hasProducedEvents);
    }

    @BuildStep(onlyIfNot={IsTest.class, IsDevelopment.class})
    void generate(OutputTargetBuildItem outputTarget, Optional<KogitoKnativeResourcesMetadataBuildItem> resourcesMetadata, BuildProducer<GeneratedFileSystemResourceBuildItem> generatedResources) {
        if (resourcesMetadata.isPresent()) {
            List<Trigger> triggers = this.generateTriggers(resourcesMetadata.get());
            Optional<KogitoSource> kogitoSource = this.generateKogitoSource(resourcesMetadata.get());
            Optional<Object> sinkBinding = Optional.empty();
            if (kogitoSource.isEmpty()) {
                sinkBinding = this.generateSinkBinding(resourcesMetadata.get());
            }
            if (sinkBinding.isPresent() || kogitoSource.isPresent() || !triggers.isEmpty()) {
                Optional<Broker> broker = this.generateBroker();
                Path outputDir = outputTarget.getOutputDirectory().resolve(TARGET_KUBERNETES);
                byte[] resourcesBytes = new KogitoKnativeGenerator().addResources(triggers).addOptionalResource(kogitoSource).addOptionalResource(sinkBinding).addOptionalResource(broker).getResourcesBytes();
                if (resourcesBytes == null || resourcesBytes.length == 0) {
                    LOGGER.warn("Couldn't generate Kogito Knative resources for service {}", (Object)resourcesMetadata.get().getDeployment().getName());
                } else {
                    generatedResources.produce((BuildItem)new GeneratedFileSystemResourceBuildItem(Path.of(TARGET_KUBERNETES, FILE_NAME).toString(), resourcesBytes));
                    LOGGER.info("Generated Knative resources for Kogito Service {} in {}", (Object)resourcesMetadata.get().getDeployment().getName(), (Object)outputDir.resolve(FILE_NAME));
                }
            } else {
                LOGGER.info("No events found in the Kogito resources defined in the project. Skipping Kogito Knative resources generation.");
            }
        }
    }

    @BuildStep
    void checkProcessEvents(BuildProducer<SystemPropertyBuildItem> systemProperties, CombinedIndexBuildItem indexBuildItem) {
        if (indexBuildItem.getIndex().getClassByName(PROCESS_EVENTS_PUBLISHER_CLASS) != null) {
            systemProperties.produce((BuildItem)new SystemPropertyBuildItem("org.kie.kogito.addons.quarkus.knative.eventing.includeProcessEvents", "true"));
        }
    }

    private Optional<Broker> generateBroker() {
        if (this.config.autoGenerateBroker.booleanValue()) {
            LOGGER.warn("Generating in memory Knative Broke. Note that this Broker is not meant for production usage!");
            return Optional.of(((BrokerBuilder)((BrokerFluent.MetadataNested)new BrokerBuilder().withNewMetadata().withName("default")).endMetadata()).build());
        }
        return Optional.empty();
    }

    private Optional<KogitoSource> generateKogitoSource(KogitoKnativeResourcesMetadataBuildItem metadata) {
        if (this.config.generateKogitoSource.booleanValue()) {
            KogitoSource kogitoSource = new KogitoSource();
            KogitoSourceSpec spec = new KogitoSourceSpec();
            ObjectMeta objectMeta = new ObjectMeta();
            objectMeta.setName(metadata.getDeployment().getName());
            spec.setSink(((DestinationBuilder)((DestinationFluent.RefNested)((DestinationFluent.RefNested)((DestinationFluent.RefNested)((DestinationFluent.RefNested)new DestinationBuilder().withNewRef().withName(this.config.sink.name)).withApiVersion(this.config.sink.apiVersion)).withKind(this.config.sink.kind)).withNamespace(this.config.sink.namespace.orElse(""))).endRef()).build());
            spec.setSubject(((ReferenceBuilder)((ReferenceBuilder)((ReferenceBuilder)new ReferenceBuilder().withName(metadata.getDeployment().getName())).withKind(metadata.getDeployment().getKind())).withApiVersion(metadata.getDeployment().getApiVersion())).build());
            kogitoSource.setMetadata(objectMeta);
            kogitoSource.setSpec(spec);
            return Optional.of(kogitoSource);
        }
        return Optional.empty();
    }

    private Optional<SinkBinding> generateSinkBinding(KogitoKnativeResourcesMetadataBuildItem metadata) {
        if (KogitoAddOnKnativeEventingProcessor.hasProducedEvents(metadata)) {
            return Optional.of(((SinkBindingBuilder)((SinkBindingFluent.SpecNested)((SinkBindingSpecFluent.SinkNested)((DestinationFluent.RefNested)((DestinationFluent.RefNested)((DestinationFluent.RefNested)((DestinationFluent.RefNested)((SinkBindingFluent.SpecNested)((SinkBindingSpecFluent.SubjectNested)((SinkBindingSpecFluent.SubjectNested)((SinkBindingSpecFluent.SubjectNested)((SinkBindingBuilder)((SinkBindingFluent.MetadataNested)new SinkBindingBuilder().withNewMetadata().withName(KnativeResourcesUtil.generateSinkBindingName(metadata.getDeployment().getName()))).endMetadata()).withNewSpec().withNewSubject().withName(metadata.getDeployment().getName())).withKind(metadata.getDeployment().getKind())).withApiVersion(metadata.getDeployment().getApiVersion())).endSubject()).withNewSink().withNewRef().withName(this.config.sink.name)).withApiVersion(this.config.sink.apiVersion)).withKind(this.config.sink.kind)).withNamespace(this.config.sink.namespace.orElse(""))).endRef()).endSink()).endSpec()).build());
        }
        return Optional.empty();
    }

    private List<Trigger> generateTriggers(KogitoKnativeResourcesMetadataBuildItem metadata) {
        return metadata.getCloudEvents().stream().filter(ce -> ce.getKind() == EventKind.CONSUMED).map(ce -> ((TriggerBuilder)((TriggerFluent.SpecNested)((TriggerSpecFluent.SubscriberNested)((DestinationFluent.RefNested)((DestinationFluent.RefNested)((DestinationFluent.RefNested)((TriggerFluent.SpecNested)((TriggerFluent.SpecNested)((TriggerSpecFluent.FilterNested)((TriggerBuilder)((TriggerFluent.MetadataNested)new TriggerBuilder().withNewMetadata().withName(KnativeResourcesUtil.generateTriggerName(ce.getType(), metadata.getDeployment().getName()))).endMetadata()).withNewSpec().withNewFilter().addToAttributes(Collections.singletonMap("type", ce.getType()))).endFilter()).withBroker(this.config.broker)).withNewSubscriber().withNewRef().withKind(metadata.getDeployment().getKind())).withName(metadata.getDeployment().getName())).withApiVersion(metadata.getDeployment().getApiVersion())).endRef()).endSubscriber()).endSpec()).build()).collect(Collectors.toList());
    }

    private static boolean hasProducedEvents(KogitoKnativeResourcesMetadataBuildItem metadata) {
        return metadata.getCloudEvents().stream().anyMatch(ce -> ce.getKind() == EventKind.PRODUCED);
    }
}

