/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addons.quarkus.knative.eventing.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.GeneratedFileSystemResourceBuildItem;
import io.quarkus.deployment.builditem.SystemPropertyBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.smallrye.health.deployment.spi.HealthBuildItem;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.junit.jupiter.api.Test;
import org.kie.kogito.addons.quarkus.knative.eventing.KSinkInjectionHealthCheck;
import org.kie.kogito.addons.quarkus.knative.eventing.deployment.EventingConfiguration;
import org.kie.kogito.addons.quarkus.knative.eventing.deployment.KogitoAddOnKnativeEventingProcessor;
import org.kie.kogito.addons.quarkus.knative.eventing.deployment.KogitoKnativeResourcesMetadataBuildItem;
import org.kie.kogito.addons.quarkus.knative.eventing.deployment.KogitoServiceDeploymentTarget;
import org.kie.kogito.addons.quarkus.knative.eventing.deployment.SinkConfiguration;
import org.kie.kogito.event.EventKind;
import org.kie.kogito.event.cloudevents.CloudEventMeta;
import org.mockito.ArgumentCaptor;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class KogitoAddOnKnativeEventingProcessorTest {
    KogitoAddOnKnativeEventingProcessorTest() {
    }

    @Test
    void checkKogitoFileIsGeneratedWithDefaultConfig() {
        OutputTargetBuildItem outputTargetBuildItem = new OutputTargetBuildItem(Paths.get("/", new String[0]), "", false, null, Optional.empty());
        HashSet<CloudEventMeta> ces = new HashSet<CloudEventMeta>();
        ces.add(new CloudEventMeta("myProducedEvent", "/local/test", EventKind.PRODUCED));
        ces.add(new CloudEventMeta("myConsumedEvent", "/local/test", EventKind.CONSUMED));
        KogitoServiceDeploymentTarget deploymentTarget = new KogitoServiceDeploymentTarget("apps", "v1", "Deployment", "kogito-service");
        KogitoKnativeResourcesMetadataBuildItem resourcesMetadataBuildItem = new KogitoKnativeResourcesMetadataBuildItem(ces, deploymentTarget);
        KogitoAddOnKnativeEventingProcessor eventingProcessor = this.buildTestProcessorWithDefaultConfig();
        MockGeneratedFSProducer producer = new MockGeneratedFSProducer();
        eventingProcessor.generate(outputTargetBuildItem, Optional.of(resourcesMetadataBuildItem), (BuildProducer)producer);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)producer.getItem().getData());
        org.junit.jupiter.api.Assertions.assertTrue((producer.getItem().getData().length > 0 ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)new String(producer.getItem().getData()).contains("SinkBinding"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)new String(producer.getItem().getData()).contains("KogitoSource"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)new String(producer.getItem().getData()).contains("Trigger"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)new String(producer.getItem().getData()).contains("Broker"));
    }

    @Test
    void checkKogitoFileIsGeneratedOnlyProduced() {
        OutputTargetBuildItem outputTargetBuildItem = new OutputTargetBuildItem(Paths.get("/", new String[0]), "", false, null, Optional.empty());
        HashSet<CloudEventMeta> ces = new HashSet<CloudEventMeta>();
        ces.add(new CloudEventMeta("myProducedEvent", "/local/test", EventKind.PRODUCED));
        KogitoServiceDeploymentTarget deploymentTarget = new KogitoServiceDeploymentTarget("apps", "v1", "Deployment", "kogito-service");
        KogitoKnativeResourcesMetadataBuildItem resourcesMetadataBuildItem = new KogitoKnativeResourcesMetadataBuildItem(ces, deploymentTarget);
        KogitoAddOnKnativeEventingProcessor eventingProcessor = this.buildTestProcessorWithDefaultConfig();
        MockGeneratedFSProducer producer = new MockGeneratedFSProducer();
        eventingProcessor.generate(outputTargetBuildItem, Optional.of(resourcesMetadataBuildItem), (BuildProducer)producer);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)producer.getItem().getData());
        org.junit.jupiter.api.Assertions.assertTrue((producer.getItem().getData().length > 0 ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)new String(producer.getItem().getData()).contains("SinkBinding"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)new String(producer.getItem().getData()).contains("KogitoSource"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)new String(producer.getItem().getData()).contains("Trigger"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)new String(producer.getItem().getData()).contains("Broker"));
    }

    @Test
    void checkKogitoFileIsGeneratedWithKogitoSource() {
        OutputTargetBuildItem outputTargetBuildItem = new OutputTargetBuildItem(Paths.get("/", new String[0]), "", false, null, Optional.empty());
        HashSet<CloudEventMeta> ces = new HashSet<CloudEventMeta>();
        ces.add(new CloudEventMeta("myProducedEvent", "/local/test", EventKind.PRODUCED));
        KogitoServiceDeploymentTarget deploymentTarget = new KogitoServiceDeploymentTarget("apps", "v1", "Deployment", "kogito-service");
        KogitoKnativeResourcesMetadataBuildItem resourcesMetadataBuildItem = new KogitoKnativeResourcesMetadataBuildItem(ces, deploymentTarget);
        KogitoAddOnKnativeEventingProcessor eventingProcessor = this.buildTestProcessorWithDefaultConfig();
        eventingProcessor.config.generateKogitoSource = true;
        MockGeneratedFSProducer producer = new MockGeneratedFSProducer();
        eventingProcessor.generate(outputTargetBuildItem, Optional.of(resourcesMetadataBuildItem), (BuildProducer)producer);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)producer.getItem().getData());
        org.junit.jupiter.api.Assertions.assertTrue((producer.getItem().getData().length > 0 ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)new String(producer.getItem().getData()).contains("SinkBinding"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)new String(producer.getItem().getData()).contains("KogitoSource"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)new String(producer.getItem().getData()).contains("Trigger"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)new String(producer.getItem().getData()).contains("Broker"));
    }

    @Test
    void checkKogitoFileIsGeneratedOnlyConsumed() {
        OutputTargetBuildItem outputTargetBuildItem = new OutputTargetBuildItem(Paths.get("/", new String[0]), "", false, null, Optional.empty());
        HashSet<CloudEventMeta> ces = new HashSet<CloudEventMeta>();
        ces.add(new CloudEventMeta("myConsumedEvent", "/local/test", EventKind.CONSUMED));
        KogitoServiceDeploymentTarget deploymentTarget = new KogitoServiceDeploymentTarget("apps", "v1", "Deployment", "kogito-service");
        KogitoKnativeResourcesMetadataBuildItem resourcesMetadataBuildItem = new KogitoKnativeResourcesMetadataBuildItem(ces, deploymentTarget);
        KogitoAddOnKnativeEventingProcessor eventingProcessor = this.buildTestProcessorWithDefaultConfig();
        MockGeneratedFSProducer producer = new MockGeneratedFSProducer();
        eventingProcessor.generate(outputTargetBuildItem, Optional.of(resourcesMetadataBuildItem), (BuildProducer)producer);
        org.junit.jupiter.api.Assertions.assertNotNull((Object)producer.getItem().getData());
        org.junit.jupiter.api.Assertions.assertTrue((producer.getItem().getData().length > 0 ? 1 : 0) != 0);
        org.junit.jupiter.api.Assertions.assertFalse((boolean)new String(producer.getItem().getData()).contains("SinkBinding"));
        org.junit.jupiter.api.Assertions.assertFalse((boolean)new String(producer.getItem().getData()).contains("KogitoSource"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)new String(producer.getItem().getData()).contains("Trigger"));
        org.junit.jupiter.api.Assertions.assertTrue((boolean)new String(producer.getItem().getData()).contains("Broker"));
    }

    @Test
    void checkNotProducedIfNoCEs() {
        OutputTargetBuildItem outputTargetBuildItem = new OutputTargetBuildItem(Paths.get("/", new String[0]), "", false, null, Optional.empty());
        HashSet ces = new HashSet();
        KogitoServiceDeploymentTarget deploymentTarget = new KogitoServiceDeploymentTarget("apps", "v1", "Deployment", "kogito-service");
        KogitoKnativeResourcesMetadataBuildItem resourcesMetadataBuildItem = new KogitoKnativeResourcesMetadataBuildItem(ces, deploymentTarget);
        KogitoAddOnKnativeEventingProcessor eventingProcessor = this.buildTestProcessorWithDefaultConfig();
        MockGeneratedFSProducer producer = new MockGeneratedFSProducer();
        eventingProcessor.generate(outputTargetBuildItem, Optional.of(resourcesMetadataBuildItem), (BuildProducer)producer);
        org.junit.jupiter.api.Assertions.assertNull((Object)producer.getItem());
    }

    @Test
    void checkProcessEventsWithEventPublisher() {
        BuildProducer buildProducer = (BuildProducer)Mockito.mock(BuildProducer.class);
        IndexView indexView = (IndexView)Mockito.mock(IndexView.class);
        CombinedIndexBuildItem combinedIndex = new CombinedIndexBuildItem(indexView, null);
        ArgumentCaptor systemPropertyCaptor = ArgumentCaptor.forClass(SystemPropertyBuildItem.class);
        ((IndexView)Mockito.doReturn((Object)ClassInfo.create((DotName)DotName.createSimple((String)"MyEventPublisherClass"), null, (short)1, (DotName[])new DotName[0], Collections.emptyMap(), (boolean)false)).when((Object)indexView)).getClassByName(KogitoAddOnKnativeEventingProcessor.PROCESS_EVENTS_PUBLISHER_CLASS);
        KogitoAddOnKnativeEventingProcessor eventingProcessor = new KogitoAddOnKnativeEventingProcessor();
        eventingProcessor.checkProcessEvents(buildProducer, combinedIndex);
        ((BuildProducer)Mockito.verify((Object)buildProducer)).produce((BuildItem)((SystemPropertyBuildItem)systemPropertyCaptor.capture()));
        Assertions.assertThat((String)((SystemPropertyBuildItem)systemPropertyCaptor.getValue()).getKey()).isEqualTo("org.kie.kogito.addons.quarkus.knative.eventing.includeProcessEvents");
        Assertions.assertThat((String)((SystemPropertyBuildItem)systemPropertyCaptor.getValue()).getValue()).isEqualTo("true");
    }

    @Test
    void checkProcessEventsWithoutEventPublisher() {
        BuildProducer buildProducer = (BuildProducer)Mockito.mock(BuildProducer.class);
        IndexView indexView = (IndexView)Mockito.mock(IndexView.class);
        CombinedIndexBuildItem combinedIndex = new CombinedIndexBuildItem(indexView, null);
        KogitoAddOnKnativeEventingProcessor eventingProcessor = new KogitoAddOnKnativeEventingProcessor();
        eventingProcessor.checkProcessEvents(buildProducer, combinedIndex);
        ((BuildProducer)Mockito.verify((Object)buildProducer, (VerificationMode)Mockito.never())).produce((BuildItem)((SystemPropertyBuildItem)Mockito.any()));
    }

    @Test
    void registerKSinkInjectionHealthCheckWithProducedEvents() {
        Set<CloudEventMeta> cloudEvents = Collections.singleton(new CloudEventMeta("my_type", "my_source", EventKind.PRODUCED));
        KogitoAddOnKnativeEventingProcessorTest.registerKSinkInjectionHealthCheck(cloudEvents, true);
    }

    @Test
    void registerKSinkInjectionHealthCheckWithoutEvents() {
        KogitoAddOnKnativeEventingProcessorTest.registerKSinkInjectionHealthCheck(Collections.emptySet(), false);
    }

    @Test
    void registerKSinkInjectionHealthCheckWithOnlyConsumedEvents() {
        Set<CloudEventMeta> cloudEvents = Collections.singleton(new CloudEventMeta("my_type", "my_source", EventKind.CONSUMED));
        KogitoAddOnKnativeEventingProcessorTest.registerKSinkInjectionHealthCheck(cloudEvents, false);
    }

    private static void registerKSinkInjectionHealthCheck(Set<? extends CloudEventMeta> cloudEvents, boolean expectedIsEnabled) {
        KogitoKnativeResourcesMetadataBuildItem metadata = new KogitoKnativeResourcesMetadataBuildItem(cloudEvents, null);
        KogitoAddOnKnativeEventingProcessor eventingProcessor = new KogitoAddOnKnativeEventingProcessor();
        HealthBuildItem healthBuildItem = eventingProcessor.registerKSinkInjectionHealthCheck(Optional.of(metadata));
        Assertions.assertThat((String)healthBuildItem.getHealthCheckClass()).isEqualTo(KSinkInjectionHealthCheck.class.getName());
        Assertions.assertThat((boolean)healthBuildItem.isEnabled()).isEqualTo(expectedIsEnabled);
    }

    private KogitoAddOnKnativeEventingProcessor buildTestProcessorWithDefaultConfig() {
        KogitoAddOnKnativeEventingProcessor eventingProcessor = new KogitoAddOnKnativeEventingProcessor();
        SinkConfiguration sinkConfiguration = new SinkConfiguration();
        sinkConfiguration.apiVersion = "eventing.knative.dev/v1";
        sinkConfiguration.kind = "Broker";
        sinkConfiguration.name = "default";
        sinkConfiguration.namespace = Optional.empty();
        eventingProcessor.config = new EventingConfiguration();
        eventingProcessor.config.autoGenerateBroker = true;
        eventingProcessor.config.generateKogitoSource = false;
        eventingProcessor.config.broker = "default";
        eventingProcessor.config.sink = sinkConfiguration;
        return eventingProcessor;
    }

    private static final class MockGeneratedFSProducer
    implements BuildProducer<GeneratedFileSystemResourceBuildItem> {
        private GeneratedFileSystemResourceBuildItem item;

        private MockGeneratedFSProducer() {
        }

        public void produce(GeneratedFileSystemResourceBuildItem item) {
            this.item = item;
        }

        public GeneratedFileSystemResourceBuildItem getItem() {
            return this.item;
        }
    }
}

