/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addons.quarkus.knative.eventing;

import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import javax.enterprise.context.ApplicationScoped;
import org.eclipse.microprofile.health.HealthCheck;
import org.eclipse.microprofile.health.HealthCheckResponse;
import org.eclipse.microprofile.health.HealthCheckResponseBuilder;
import org.eclipse.microprofile.health.Liveness;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Liveness
@ApplicationScoped
public class KSinkInjectionHealthCheck
implements HealthCheck {
    private static final Logger LOGGER = LoggerFactory.getLogger(KSinkInjectionHealthCheck.class);
    public static final String CONFIG_ALIAS = "org.kie.kogito.addons.knative.eventing.health-enabled";
    public static final String NAME = "K_SINK environment variable injection check";

    public HealthCheckResponse call() {
        HealthCheckResponseBuilder responseBuilder = HealthCheckResponse.named((String)NAME);
        String sinkURL = System.getenv("K_SINK");
        if ("".equals(sinkURL) || sinkURL == null) {
            LOGGER.warn("K_SINK variable not set in this environment. Returning not healthy.");
        } else {
            try {
                URI uri = new URI(sinkURL);
                InetAddress address = InetAddress.getByName(uri.getHost());
                if (address != null) {
                    responseBuilder.up();
                    return responseBuilder.build();
                }
                LOGGER.warn("Impossible to resolve host " + uri.getHost() + " for URL " + sinkURL + ". Check if this host can resolve from this environment. Returning not healthy.");
            }
            catch (UnknownHostException e) {
                LOGGER.warn("Failed to lookup address " + sinkURL + ". Returning not healthy.");
            }
            catch (URISyntaxException e) {
                LOGGER.warn("The K_SINK URL syntax is invalid: " + sinkURL + ". Returning not healthy.", (Throwable)e);
            }
        }
        responseBuilder.down();
        return responseBuilder.build();
    }
}

