/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addons.quarkus.knative.serving.customfunctions;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.tomakehurst.wiremock.WireMockServer;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import io.fabric8.knative.client.KnativeClient;
import io.fabric8.kubernetes.client.server.mock.KubernetesServer;
import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.kubernetes.client.KubernetesTestServer;
import io.quarkus.test.kubernetes.client.WithKubernetesTestServer;
import io.smallrye.mutiny.TimeoutException;
import java.util.Map;
import javax.inject.Inject;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.addons.quarkus.knative.serving.customfunctions.KnativeServerlessWorkflowCustomFunction;
import org.kie.kogito.addons.quarkus.knative.serving.customfunctions.KnativeServiceDiscoveryTestUtil;
import org.kie.kogito.process.workitem.WorkItemExecutionException;

@QuarkusTest
@WithKubernetesTestServer
class KnativeServerlessWorkflowCustomFunctionTest {
    private static String remoteServiceUrl;
    @KubernetesTestServer
    KubernetesServer mockServer;
    @ConfigProperty(name="kogito.addon.knative-serving.request-timeout")
    Long requestTimeout;
    @Inject
    KnativeServerlessWorkflowCustomFunction knativeServerlessWorkflowCustomFunction;
    private static KnativeClient knativeClient;
    private static WireMockServer wireMockServer;

    KnativeServerlessWorkflowCustomFunctionTest() {
    }

    @BeforeAll
    static void beforeAll() {
        KnativeServerlessWorkflowCustomFunctionTest.createWiremockServer();
    }

    @BeforeEach
    void beforeEach() {
        KnativeServiceDiscoveryTestUtil.createServiceIfNotExists(this.mockServer, remoteServiceUrl, "knative/quarkus-greeting.yaml", "test", "serverless-workflow-greeting-quarkus").ifPresent(newKnativeClient -> {
            knativeClient = newKnativeClient;
        });
    }

    @AfterAll
    static void afterAll() {
        if (wireMockServer != null) {
            wireMockServer.stop();
        }
        knativeClient.close();
    }

    private static void createWiremockServer() {
        wireMockServer = new WireMockServer((Options)WireMockConfiguration.wireMockConfig().dynamicPort());
        wireMockServer.start();
        remoteServiceUrl = wireMockServer.baseUrl();
    }

    private void mockExecuteTimeoutEndpoint() {
        wireMockServer.stubFor(WireMock.post((UrlPattern)WireMock.urlEqualTo((String)"/timeout")).willReturn(WireMock.aResponse().withFixedDelay(Integer.valueOf(this.requestTimeout.intValue() + 500)).withStatus(200)));
    }

    private void mockExecute404Endpoint() {
        wireMockServer.stubFor(WireMock.post((UrlPattern)WireMock.urlEqualTo((String)"/non_existing_path")).willReturn(WireMock.aResponse().withStatus(404)));
    }

    private void mockExecuteWithQueryParametersEndpoint() {
        wireMockServer.stubFor(WireMock.post((UrlPattern)WireMock.urlEqualTo((String)"/hello")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", new String[]{"application/json"}).withJsonBody((JsonNode)JsonNodeFactory.instance.objectNode().put("message", "Hello Kogito"))));
    }

    private void mockExecuteWithParametersEndpoint() {
        wireMockServer.stubFor(WireMock.post((UrlPattern)WireMock.urlEqualTo((String)"/")).withRequestBody((ContentPattern)WireMock.equalToJson((String)JsonNodeFactory.instance.objectNode().put("org", "Acme").put("project", "Kogito").toString())).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", new String[]{"application/json"}).withJsonBody((JsonNode)JsonNodeFactory.instance.objectNode().put("message", "Kogito is awesome!"))));
    }

    private void mockExecuteWithEmptyParametersEndpoint() {
        wireMockServer.stubFor(WireMock.post((UrlPattern)WireMock.urlEqualTo((String)"/")).willReturn(WireMock.aResponse().withStatus(200).withHeader("Content-Type", new String[]{"application/json"}).withJsonBody((JsonNode)JsonNodeFactory.instance.objectNode().put("org", "Acme").put("project", "Kogito"))));
    }

    @Test
    void executeWithEmptyParameters() {
        this.mockExecuteWithEmptyParametersEndpoint();
        JsonNode output = this.knativeServerlessWorkflowCustomFunction.execute("serverless-workflow-greeting-quarkus", "/", Map.of());
        ObjectNode expected = JsonNodeFactory.instance.objectNode().put("org", "Acme").put("project", "Kogito");
        Assertions.assertThat((Iterable)output).isEqualTo((Object)expected);
    }

    @Test
    void executeWithParameters() {
        this.mockExecuteWithParametersEndpoint();
        Map<String, String> parameters = Map.of("org", "Acme", "project", "Kogito");
        JsonNode output = this.knativeServerlessWorkflowCustomFunction.execute("serverless-workflow-greeting-quarkus", "/", parameters);
        ObjectNode expected = JsonNodeFactory.instance.objectNode().put("message", "Kogito is awesome!");
        Assertions.assertThat((Iterable)output).isEqualTo((Object)expected);
    }

    @Test
    void executeWithQueryParameters() {
        this.mockExecuteWithQueryParametersEndpoint();
        Map parameters = Map.of();
        JsonNode output = this.knativeServerlessWorkflowCustomFunction.execute("serverless-workflow-greeting-quarkus", "/hello", parameters);
        ObjectNode expected = JsonNodeFactory.instance.objectNode().put("message", "Hello Kogito");
        Assertions.assertThat((Iterable)output).isEqualTo((Object)expected);
    }

    @Test
    void execute404() {
        this.mockExecute404Endpoint();
        Map parameters = Map.of();
        ((AbstractThrowableAssert)Assertions.assertThatCode(() -> this.knativeServerlessWorkflowCustomFunction.execute("serverless-workflow-greeting-quarkus", "/non_existing_path", parameters)).isInstanceOf(WorkItemExecutionException.class)).extracting("errorCode").isEqualTo((Object)"404");
    }

    @Test
    void executeTimeout() {
        this.mockExecuteTimeoutEndpoint();
        Map payload = Map.of();
        Assertions.assertThatExceptionOfType(TimeoutException.class).isThrownBy(() -> this.knativeServerlessWorkflowCustomFunction.execute("serverless-workflow-greeting-quarkus", "/timeout", payload));
    }
}

