/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addons.quarkus.knative.serving.customfunctions;

import io.fabric8.knative.client.KnativeClient;
import io.fabric8.kubernetes.client.server.mock.KubernetesServer;
import io.quarkus.test.junit.QuarkusTest;
import io.quarkus.test.kubernetes.client.KubernetesTestServer;
import io.quarkus.test.kubernetes.client.WithKubernetesTestServer;
import java.util.Optional;
import javax.inject.Inject;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.kie.kogito.addons.quarkus.knative.serving.customfunctions.KnativeServiceAddress;
import org.kie.kogito.addons.quarkus.knative.serving.customfunctions.KnativeServiceDiscovery;
import org.kie.kogito.addons.quarkus.knative.serving.customfunctions.KnativeServiceDiscoveryTestUtil;

@QuarkusTest
@WithKubernetesTestServer
class KnativeServiceDiscoveryTest {
    private static final String REMOTE_SERVICE_HOST = "serverless-workflow-greeting-quarkus.test.10.99.154.147.sslip.io";
    @KubernetesTestServer
    KubernetesServer mockServer;
    @Inject
    KnativeServiceDiscovery serviceDiscovery;
    static KnativeClient knativeClient;

    KnativeServiceDiscoveryTest() {
    }

    @BeforeEach
    void setup() {
        String remoteServiceUrl = "http://serverless-workflow-greeting-quarkus.test.10.99.154.147.sslip.io";
        KnativeServiceDiscoveryTestUtil.createServiceIfNotExists(this.mockServer, remoteServiceUrl, "knative/quarkus-greeting.yaml", "test", "serverless-workflow-greeting-quarkus").ifPresent(newKnativeClient -> {
            knativeClient = newKnativeClient;
        });
    }

    @AfterAll
    static void tearDown() {
        knativeClient.close();
    }

    @Test
    void discoverSpecificNamespace() {
        Optional serviceAddress = this.serviceDiscovery.discover("test/serverless-workflow-greeting-quarkus");
        Assertions.assertThat((Optional)serviceAddress).map(KnativeServiceAddress::getHost).hasValue((Object)REMOTE_SERVICE_HOST);
        Assertions.assertThat((Optional)serviceAddress).map(KnativeServiceAddress::getPort).hasValue((Object)80);
        Assertions.assertThat((Optional)serviceAddress).map(KnativeServiceAddress::isSsl).hasValue((Object)false);
    }

    @Test
    void discoverCurrentNamespace() {
        Optional serviceAddress = this.serviceDiscovery.discover("serverless-workflow-greeting-quarkus");
        Assertions.assertThat((Optional)serviceAddress).map(KnativeServiceAddress::getHost).hasValue((Object)REMOTE_SERVICE_HOST);
        Assertions.assertThat((Optional)serviceAddress).map(KnativeServiceAddress::getPort).hasValue((Object)80);
        Assertions.assertThat((Optional)serviceAddress).map(KnativeServiceAddress::isSsl).hasValue((Object)false);
    }

    @Test
    void serviceInDifferentNamespaceShouldNotBeFound() {
        Optional serviceAddress = this.serviceDiscovery.discover("different_namespace/serverless-workflow-greeting-quarkus");
        Assertions.assertThat((Optional)serviceAddress).isEmpty();
    }

    @Test
    void https() {
        String remoteServiceUrl = "https://serverless-workflow-greeting-quarkus.test.10.99.154.147.sslip.io";
        KnativeServiceDiscoveryTestUtil.createServiceIfNotExists(this.mockServer, remoteServiceUrl, "knative/quarkus-greeting-https.yaml", "test", "serverless-workflow-greeting-quarkus-https").ifPresent(newKnativeClient -> {
            knativeClient = newKnativeClient;
        });
        Optional serviceAddress = this.serviceDiscovery.discover("serverless-workflow-greeting-quarkus-https");
        Assertions.assertThat((Optional)serviceAddress).map(KnativeServiceAddress::getHost).hasValue((Object)REMOTE_SERVICE_HOST);
        Assertions.assertThat((Optional)serviceAddress).map(KnativeServiceAddress::getPort).hasValue((Object)443);
        Assertions.assertThat((Optional)serviceAddress).map(KnativeServiceAddress::isSsl).hasValue((Object)true);
    }
}

