/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addons.quarkus.knative.serving.customfunctions;

import io.fabric8.knative.client.KnativeClient;
import io.fabric8.knative.serving.v1.Service;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.ServiceResource;
import io.fabric8.kubernetes.client.server.mock.KubernetesServer;
import java.io.InputStream;
import java.util.Optional;

final class KnativeServiceDiscoveryTestUtil {
    private KnativeServiceDiscoveryTestUtil() {
    }

    static Optional<KnativeClient> createServiceIfNotExists(KubernetesServer k8sServer, String remoteServiceUrl, String knativeYaml, String namespace, String serviceName) {
        if (((ServiceResource)((NonNamespaceOperation)k8sServer.getClient().services().inNamespace("test")).withName(serviceName)).get() != null) {
            return Optional.empty();
        }
        KnativeClient knativeClient = (KnativeClient)k8sServer.getClient().adapt(KnativeClient.class);
        Service service = (Service)((Resource)((NonNamespaceOperation)knativeClient.services().inNamespace(namespace)).load(KnativeServiceDiscoveryTestUtil.getResourceAsStream(knativeYaml))).get();
        service.getStatus().setUrl(remoteServiceUrl);
        ((NonNamespaceOperation)knativeClient.services().inNamespace(namespace)).create((Object)service);
        return Optional.of(knativeClient);
    }

    private static InputStream getResourceAsStream(String knativeYaml) {
        return KnativeServiceDiscoveryTestUtil.class.getClassLoader().getResourceAsStream(knativeYaml);
    }
}

