/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addons.quarkus.knative.serving.customfunctions;

import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.kie.kogito.addons.quarkus.knative.serving.customfunctions.KnativeServiceIdentifier;

class KnativeServiceIdentifierTest {
    KnativeServiceIdentifierTest() {
    }

    @Test
    void testOnlyService() {
        KnativeServiceIdentifier serviceIdentifier = new KnativeServiceIdentifier("service");
        Assertions.assertThat((Optional)serviceIdentifier.getNamespace()).isEmpty();
        Assertions.assertThat((String)serviceIdentifier.getName()).isEqualTo("service");
    }

    @Test
    void testNamespaceAndService() {
        KnativeServiceIdentifier serviceIdentifier = new KnativeServiceIdentifier("namespace/service");
        Assertions.assertThat((Optional)serviceIdentifier.getNamespace()).hasValue((Object)"namespace");
        Assertions.assertThat((String)serviceIdentifier.getName()).isEqualTo("service");
    }

    @Test
    void testNullUrl() {
        Assertions.assertThatNullPointerException().isThrownBy(() -> new KnativeServiceIdentifier(null));
    }

    @ParameterizedTest
    @ValueSource(strings={"", " ", "namespace/", "/service", " / ", "several/slashes/slashes/slashes"})
    void testInvalidUrl(String url) {
        Assertions.assertThatIllegalArgumentException().isThrownBy(() -> new KnativeServiceIdentifier(url));
    }
}

