/*
 * Decompiled with CFR 0.152.
 */
package org.kie.kogito.addons.quarkus.knative.serving.customfunctions;

import com.fasterxml.jackson.databind.JsonNode;
import io.vertx.core.json.JsonObject;
import io.vertx.mutiny.core.Vertx;
import io.vertx.mutiny.core.buffer.Buffer;
import io.vertx.mutiny.ext.web.client.HttpRequest;
import io.vertx.mutiny.ext.web.client.HttpResponse;
import io.vertx.mutiny.ext.web.client.WebClient;
import java.net.URI;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.eclipse.microprofile.config.inject.ConfigProperty;
import org.kie.kogito.addons.quarkus.knative.serving.customfunctions.KnativeServiceRequestClient;
import org.kie.kogito.event.cloudevents.utils.CloudEventUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
class CloudEventKnativeServiceRequestClient
extends KnativeServiceRequestClient {
    private static final Logger logger = LoggerFactory.getLogger(CloudEventKnativeServiceRequestClient.class);
    private final WebClient webClient;
    private final Duration requestTimeout;

    @Inject
    CloudEventKnativeServiceRequestClient(Vertx vertx, @ConfigProperty(name="kogito.addon.knative-serving.request-timeout") Optional<Long> requestTimeout) {
        this.webClient = WebClient.create((Vertx)vertx);
        this.requestTimeout = Duration.ofMillis(requestTimeout.orElse(10000L));
    }

    @Override
    protected JsonNode sendRequest(String processInstanceId, URI serviceAddress, String path, Map<String, Object> cloudEvent) {
        this.validateCloudEvent(cloudEvent);
        HttpRequest request = serviceAddress.getPort() >= 0 ? this.webClient.post(serviceAddress.getPort(), serviceAddress.getHost(), path) : this.webClient.post(serviceAddress.getHost(), path);
        request.putHeader("Content-Type", "application/cloudevents+json; charset=UTF-8").ssl(Boolean.valueOf("https".equals(serviceAddress.getScheme())));
        JsonObject body = new JsonObject(CloudEventKnativeServiceRequestClient.createCloudEventWithGeneratedId(cloudEvent, processInstanceId));
        logger.debug("Sending request with CloudEvent - host: {}, port: {}, path: {}, CloudEvent: {}", new Object[]{serviceAddress.getHost(), serviceAddress.getPort(), path, body});
        HttpResponse response = (HttpResponse)request.sendBuffer(Buffer.buffer((String)body.encode())).await().atMost(this.requestTimeout);
        return this.responseAsJsonObject((HttpResponse<Buffer>)response);
    }

    private static HashMap<String, Object> createCloudEventWithGeneratedId(Map<String, Object> cloudEvent, String processInstanceId) {
        HashMap<String, Object> modifiableCloudEvent = new HashMap<String, Object>(cloudEvent);
        Object oldIdValue = modifiableCloudEvent.put("id", CloudEventKnativeServiceRequestClient.generateCloudEventId(processInstanceId, cloudEvent.get("source").toString()));
        if (oldIdValue != null) {
            logger.warn("CloudEvent id should not be set. Ignoring id {}. A generated value will be used instead.", oldIdValue);
        }
        return modifiableCloudEvent;
    }

    private static String generateCloudEventId(String processInstanceId, String source) {
        return source + "_" + processInstanceId;
    }

    private void validateCloudEvent(Map<String, Object> cloudEvent) {
        List missingAttributes = CloudEventUtils.getMissingAttributes(cloudEvent);
        missingAttributes.remove("id");
        if (!missingAttributes.isEmpty()) {
            throw new IllegalArgumentException("Invalid CloudEvent. The following mandatory attributes are missing: " + String.join((CharSequence)", ", missingAttributes));
        }
    }

    @PreDestroy
    void preDestroy() {
        this.webClient.close();
    }
}

